/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.vdx.data.wave;

import gov.usgs.util.Util;
import gov.usgs.vdx.data.wave.Wave;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class SAC {
    public float delta = FLOAT_UNDEF;
    public float depmin = FLOAT_UNDEF;
    public float depmax = FLOAT_UNDEF;
    public float scale = FLOAT_UNDEF;
    public float odelta = FLOAT_UNDEF;
    public float b = FLOAT_UNDEF;
    public float e = FLOAT_UNDEF;
    public float o = FLOAT_UNDEF;
    public float a = FLOAT_UNDEF;
    public float fmt = FLOAT_UNDEF;
    public float t0 = FLOAT_UNDEF;
    public float t1 = FLOAT_UNDEF;
    public float t2 = FLOAT_UNDEF;
    public float t3 = FLOAT_UNDEF;
    public float t4 = FLOAT_UNDEF;
    public float t5 = FLOAT_UNDEF;
    public float t6 = FLOAT_UNDEF;
    public float t7 = FLOAT_UNDEF;
    public float t8 = FLOAT_UNDEF;
    public float t9 = FLOAT_UNDEF;
    public float f = FLOAT_UNDEF;
    public float resp0 = FLOAT_UNDEF;
    public float resp1 = FLOAT_UNDEF;
    public float resp2 = FLOAT_UNDEF;
    public float resp3 = FLOAT_UNDEF;
    public float resp4 = FLOAT_UNDEF;
    public float resp5 = FLOAT_UNDEF;
    public float resp6 = FLOAT_UNDEF;
    public float resp7 = FLOAT_UNDEF;
    public float resp8 = FLOAT_UNDEF;
    public float resp9 = FLOAT_UNDEF;
    public float stla = FLOAT_UNDEF;
    public float stlo = FLOAT_UNDEF;
    public float stel = FLOAT_UNDEF;
    public float stdp = FLOAT_UNDEF;
    public float evla = FLOAT_UNDEF;
    public float evlo = FLOAT_UNDEF;
    public float evel = FLOAT_UNDEF;
    public float evdp = FLOAT_UNDEF;
    public float mag = FLOAT_UNDEF;
    public float user0 = FLOAT_UNDEF;
    public float user1 = FLOAT_UNDEF;
    public float user2 = FLOAT_UNDEF;
    public float user3 = FLOAT_UNDEF;
    public float user4 = FLOAT_UNDEF;
    public float user5 = FLOAT_UNDEF;
    public float user6 = FLOAT_UNDEF;
    public float user7 = FLOAT_UNDEF;
    public float user8 = FLOAT_UNDEF;
    public float user9 = FLOAT_UNDEF;
    public float dist = FLOAT_UNDEF;
    public float az = FLOAT_UNDEF;
    public float baz = FLOAT_UNDEF;
    public float gcarc = FLOAT_UNDEF;
    public float sb = FLOAT_UNDEF;
    public float sdelta = FLOAT_UNDEF;
    public float depmen = FLOAT_UNDEF;
    public float cmpaz = FLOAT_UNDEF;
    public float cmpinc = FLOAT_UNDEF;
    public float xminimum = FLOAT_UNDEF;
    public float xmaximum = FLOAT_UNDEF;
    public float yminimum = FLOAT_UNDEF;
    public float ymaximum = FLOAT_UNDEF;
    public float unused6 = FLOAT_UNDEF;
    public float unused7 = FLOAT_UNDEF;
    public float unused8 = FLOAT_UNDEF;
    public float unused9 = FLOAT_UNDEF;
    public float unused10 = FLOAT_UNDEF;
    public float unused11 = FLOAT_UNDEF;
    public float unused12 = FLOAT_UNDEF;
    public int nzyear = INT_UNDEF;
    public int nzjday = INT_UNDEF;
    public int nzhour = INT_UNDEF;
    public int nzmin = INT_UNDEF;
    public int nzsec = INT_UNDEF;
    public int nzmsec = INT_UNDEF;
    public int nvhdr = 6;
    public int norid = INT_UNDEF;
    public int nevid = INT_UNDEF;
    public int npts = INT_UNDEF;
    public int nsnpts = INT_UNDEF;
    public int nwfid = INT_UNDEF;
    public int nxsize = INT_UNDEF;
    public int nysize = INT_UNDEF;
    public int unused15 = INT_UNDEF;
    public int iftype = INT_UNDEF;
    public int idep = INT_UNDEF;
    public int iztype = INT_UNDEF;
    public int unused16 = INT_UNDEF;
    public int iinst = INT_UNDEF;
    public int istreg = INT_UNDEF;
    public int ievreg = INT_UNDEF;
    public int ievtyp = INT_UNDEF;
    public int iqual = INT_UNDEF;
    public int isynth = INT_UNDEF;
    public int imagtyp = INT_UNDEF;
    public int imagsrc = INT_UNDEF;
    public int unused19 = INT_UNDEF;
    public int unused20 = INT_UNDEF;
    public int unused21 = INT_UNDEF;
    public int unused22 = INT_UNDEF;
    public int unused23 = INT_UNDEF;
    public int unused24 = INT_UNDEF;
    public int unused25 = INT_UNDEF;
    public int unused26 = INT_UNDEF;
    public int leven = INT_UNDEF;
    public int lpspol = INT_UNDEF;
    public int lovrok = INT_UNDEF;
    public int lcalda = INT_UNDEF;
    public int unused27 = INT_UNDEF;
    public String kstnm = STRING8_UNDEF;
    public String kevnm = STRING16_UNDEF;
    public String khole = STRING8_UNDEF;
    public String ko = STRING8_UNDEF;
    public String ka = STRING8_UNDEF;
    public String kt0 = STRING8_UNDEF;
    public String kt1 = STRING8_UNDEF;
    public String kt2 = STRING8_UNDEF;
    public String kt3 = STRING8_UNDEF;
    public String kt4 = STRING8_UNDEF;
    public String kt5 = STRING8_UNDEF;
    public String kt6 = STRING8_UNDEF;
    public String kt7 = STRING8_UNDEF;
    public String kt8 = STRING8_UNDEF;
    public String kt9 = STRING8_UNDEF;
    public String kf = STRING8_UNDEF;
    public String kuser0 = STRING8_UNDEF;
    public String kuser1 = STRING8_UNDEF;
    public String kuser2 = STRING8_UNDEF;
    public String kcmpnm = STRING8_UNDEF;
    public String knetwk = STRING8_UNDEF;
    public String kdatrd = STRING8_UNDEF;
    public String kinst = STRING8_UNDEF;
    public float[] y;
    public float[] x;
    public float[] real;
    public float[] imaginary;
    public float[] amp;
    public float[] phase;
    public static float FLOAT_UNDEF = -12345.0f;
    public static int INT_UNDEF = -12345;
    public static String STRING8_UNDEF = "-12345  ";
    public static String STRING16_UNDEF = "-12345          ";
    public static final int TRUE = 1;
    public static final int FALSE = 0;
    public static final int IREAL = 0;
    public static final int ITIME = 1;
    public static final int IRLIM = 2;
    public static final int IAMPH = 3;
    public static final int IXY = 4;
    public static final int IUNKN = 5;
    public static final int IDISP = 6;
    public static final int IVEL = 7;
    public static final int IACC = 8;
    public static final int IB = 9;
    public static final int IDAY = 10;
    public static final int IO = 11;
    public static final int IA = 12;
    public static final int IT0 = 13;
    public static final int IT1 = 14;
    public static final int IT2 = 15;
    public static final int IT3 = 16;
    public static final int IT4 = 17;
    public static final int IT5 = 18;
    public static final int IT6 = 19;
    public static final int IT7 = 20;
    public static final int IT8 = 21;
    public static final int IT9 = 22;
    public static final int IRADNV = 23;
    public static final int ITANNV = 24;
    public static final int IRADEV = 25;
    public static final int ITANEV = 26;
    public static final int INORTH = 27;
    public static final int IEAST = 28;
    public static final int IHORZA = 29;
    public static final int IDOWN = 30;
    public static final int IUP = 31;
    public static final int ILLLBB = 32;
    public static final int IWWSN1 = 33;
    public static final int IWWSN2 = 34;
    public static final int IHGLP = 35;
    public static final int ISRO = 36;
    public static final int INUCL = 37;
    public static final int IPREN = 38;
    public static final int IPOSTN = 39;
    public static final int IQUAKE = 40;
    public static final int IPREQ = 41;
    public static final int IPOSTQ = 42;
    public static final int ICHEM = 43;
    public static final int IOTHER = 44;
    public static final int IGOOD = 45;
    public static final int IGLCH = 46;
    public static final int IDROP = 47;
    public static final int ILOWSN = 48;
    public static final int IRLDTA = 49;
    public static final int IVOLTS = 50;
    public static final int INIV51 = 51;
    public static final int INIV52 = 52;
    public static final int INIV53 = 53;
    public static final int INIV54 = 54;
    public static final int INIV55 = 55;
    public static final int INIV56 = 56;
    public static final int INIV57 = 57;
    public static final int INIV58 = 58;
    public static final int INIV59 = 59;
    public static final int INIV60 = 60;
    public static final int data_offset = 632;
    public boolean byteOrder = true;
    public static final boolean SunByteOrder = true;
    public static final boolean IntelByteOrder = false;

    public void read(String filename) throws FileNotFoundException, IOException {
        File sacFile = new File(filename);
        FileInputStream fis = new FileInputStream(filename);
        BufferedInputStream buf = new BufferedInputStream(fis);
        DataInputStream dis = new DataInputStream(buf);
        this.readHeader(dis);
        if (sacFile.length() != (long)(this.npts * 4 + 632)) {
            if (sacFile.length() == (long)(SAC.swapBytes(this.npts) * 4 + 632)) {
                this.byteOrder = false;
                this.swapHeader();
            } else {
                throw new IOException(String.valueOf(filename) + " does not appear to be a sac file!");
            }
        }
        this.readData(dis);
        dis.close();
    }

    public static final short swapBytes(short val) {
        return (short)(((val & 0xFF00) >> 8) + ((val & 0xFF) << 8));
    }

    public static final float swapBytes(float val) {
        return Float.intBitsToFloat(SAC.swapBytes(Float.floatToRawIntBits(val)));
    }

    public static final int swapBytes(int val) {
        return ((val & 0xFF000000) >>> 24) + ((val & 0xFF0000) >> 8) + ((val & 0xFF00) << 8) + ((val & 0xFF) << 24);
    }

    public static final double swapBytes(double val) {
        return Double.longBitsToDouble(SAC.swapBytes(Double.doubleToRawLongBits(val)));
    }

    public static final long swapBytes(long val) {
        return ((val & 0xFF00000000000000L) >>> 56) + ((val & 0xFF000000000000L) >> 40) + ((val & 0xFF0000000000L) >> 24) + ((val & 0xFF00000000L) >> 8) + ((val & 0xFF000000L) << 8) + ((val & 0xFF0000L) << 24) + ((val & 0xFF00L) << 40) + ((val & 0xFFL) << 56);
    }

    public void read(DataInputStream dis) throws IOException {
        this.readHeader(dis);
        this.readData(dis);
    }

    public void readHeader(String filename) throws FileNotFoundException, IOException {
        DataInputStream dis = new DataInputStream(new BufferedInputStream(new FileInputStream(filename)));
        this.readHeader(dis);
        dis.close();
    }

    protected void swapHeader() {
        this.delta = SAC.swapBytes(this.delta);
        this.depmin = SAC.swapBytes(this.depmin);
        this.depmax = SAC.swapBytes(this.depmax);
        this.scale = SAC.swapBytes(this.scale);
        this.odelta = SAC.swapBytes(this.odelta);
        this.b = SAC.swapBytes(this.b);
        this.e = SAC.swapBytes(this.e);
        this.o = SAC.swapBytes(this.o);
        this.a = SAC.swapBytes(this.a);
        this.fmt = SAC.swapBytes(this.fmt);
        this.t0 = SAC.swapBytes(this.t0);
        this.t1 = SAC.swapBytes(this.t1);
        this.t2 = SAC.swapBytes(this.t2);
        this.t3 = SAC.swapBytes(this.t3);
        this.t4 = SAC.swapBytes(this.t4);
        this.t5 = SAC.swapBytes(this.t5);
        this.t6 = SAC.swapBytes(this.t6);
        this.t7 = SAC.swapBytes(this.t7);
        this.t8 = SAC.swapBytes(this.t8);
        this.t9 = SAC.swapBytes(this.t9);
        this.f = SAC.swapBytes(this.f);
        this.resp0 = SAC.swapBytes(this.resp0);
        this.resp1 = SAC.swapBytes(this.resp1);
        this.resp2 = SAC.swapBytes(this.resp2);
        this.resp3 = SAC.swapBytes(this.resp3);
        this.resp4 = SAC.swapBytes(this.resp4);
        this.resp5 = SAC.swapBytes(this.resp5);
        this.resp6 = SAC.swapBytes(this.resp6);
        this.resp7 = SAC.swapBytes(this.resp7);
        this.resp8 = SAC.swapBytes(this.resp8);
        this.resp9 = SAC.swapBytes(this.resp9);
        this.stla = SAC.swapBytes(this.stla);
        this.stlo = SAC.swapBytes(this.stlo);
        this.stel = SAC.swapBytes(this.stel);
        this.stdp = SAC.swapBytes(this.stdp);
        this.evla = SAC.swapBytes(this.evla);
        this.evlo = SAC.swapBytes(this.evlo);
        this.evel = SAC.swapBytes(this.evel);
        this.evdp = SAC.swapBytes(this.evdp);
        this.mag = SAC.swapBytes(this.mag);
        this.user0 = SAC.swapBytes(this.user0);
        this.user1 = SAC.swapBytes(this.user1);
        this.user2 = SAC.swapBytes(this.user2);
        this.user3 = SAC.swapBytes(this.user3);
        this.user4 = SAC.swapBytes(this.user4);
        this.user5 = SAC.swapBytes(this.user5);
        this.user6 = SAC.swapBytes(this.user6);
        this.user7 = SAC.swapBytes(this.user7);
        this.user8 = SAC.swapBytes(this.user8);
        this.user9 = SAC.swapBytes(this.user9);
        this.dist = SAC.swapBytes(this.dist);
        this.az = SAC.swapBytes(this.az);
        this.baz = SAC.swapBytes(this.baz);
        this.gcarc = SAC.swapBytes(this.gcarc);
        this.sb = SAC.swapBytes(this.sb);
        this.sdelta = SAC.swapBytes(this.sdelta);
        this.depmen = SAC.swapBytes(this.depmen);
        this.cmpaz = SAC.swapBytes(this.cmpaz);
        this.cmpinc = SAC.swapBytes(this.cmpinc);
        this.xminimum = SAC.swapBytes(this.xminimum);
        this.xmaximum = SAC.swapBytes(this.xmaximum);
        this.yminimum = SAC.swapBytes(this.yminimum);
        this.ymaximum = SAC.swapBytes(this.ymaximum);
        this.unused6 = SAC.swapBytes(this.unused6);
        this.unused7 = SAC.swapBytes(this.unused7);
        this.unused8 = SAC.swapBytes(this.unused8);
        this.unused9 = SAC.swapBytes(this.unused9);
        this.unused10 = SAC.swapBytes(this.unused10);
        this.unused11 = SAC.swapBytes(this.unused11);
        this.unused12 = SAC.swapBytes(this.unused12);
        this.nzyear = SAC.swapBytes(this.nzyear);
        this.nzjday = SAC.swapBytes(this.nzjday);
        this.nzhour = SAC.swapBytes(this.nzhour);
        this.nzmin = SAC.swapBytes(this.nzmin);
        this.nzsec = SAC.swapBytes(this.nzsec);
        this.nzmsec = SAC.swapBytes(this.nzmsec);
        this.nvhdr = SAC.swapBytes(this.nvhdr);
        this.norid = SAC.swapBytes(this.norid);
        this.nevid = SAC.swapBytes(this.nevid);
        this.npts = SAC.swapBytes(this.npts);
        this.nsnpts = SAC.swapBytes(this.nsnpts);
        this.nwfid = SAC.swapBytes(this.nwfid);
        this.nxsize = SAC.swapBytes(this.nxsize);
        this.nysize = SAC.swapBytes(this.nysize);
        this.unused15 = SAC.swapBytes(this.unused15);
        this.iftype = SAC.swapBytes(this.iftype);
        this.idep = SAC.swapBytes(this.idep);
        this.iztype = SAC.swapBytes(this.iztype);
        this.unused16 = SAC.swapBytes(this.unused16);
        this.iinst = SAC.swapBytes(this.iinst);
        this.istreg = SAC.swapBytes(this.istreg);
        this.ievreg = SAC.swapBytes(this.ievreg);
        this.ievtyp = SAC.swapBytes(this.ievtyp);
        this.iqual = SAC.swapBytes(this.iqual);
        this.isynth = SAC.swapBytes(this.isynth);
        this.imagtyp = SAC.swapBytes(this.imagtyp);
        this.imagsrc = SAC.swapBytes(this.imagsrc);
        this.unused19 = SAC.swapBytes(this.unused19);
        this.unused20 = SAC.swapBytes(this.unused20);
        this.unused21 = SAC.swapBytes(this.unused21);
        this.unused22 = SAC.swapBytes(this.unused22);
        this.unused23 = SAC.swapBytes(this.unused23);
        this.unused24 = SAC.swapBytes(this.unused24);
        this.unused25 = SAC.swapBytes(this.unused25);
        this.unused26 = SAC.swapBytes(this.unused26);
        this.leven = SAC.swapBytes(this.leven);
        this.lpspol = SAC.swapBytes(this.lpspol);
        this.lovrok = SAC.swapBytes(this.lovrok);
        this.lcalda = SAC.swapBytes(this.lcalda);
        this.unused27 = SAC.swapBytes(this.unused27);
    }

    public void readHeader(DataInputStream dis) throws FileNotFoundException, IOException {
        this.delta = dis.readFloat();
        this.depmin = dis.readFloat();
        this.depmax = dis.readFloat();
        this.scale = dis.readFloat();
        this.odelta = dis.readFloat();
        this.b = dis.readFloat();
        this.e = dis.readFloat();
        this.o = dis.readFloat();
        this.a = dis.readFloat();
        this.fmt = dis.readFloat();
        this.t0 = dis.readFloat();
        this.t1 = dis.readFloat();
        this.t2 = dis.readFloat();
        this.t3 = dis.readFloat();
        this.t4 = dis.readFloat();
        this.t5 = dis.readFloat();
        this.t6 = dis.readFloat();
        this.t7 = dis.readFloat();
        this.t8 = dis.readFloat();
        this.t9 = dis.readFloat();
        this.f = dis.readFloat();
        this.resp0 = dis.readFloat();
        this.resp1 = dis.readFloat();
        this.resp2 = dis.readFloat();
        this.resp3 = dis.readFloat();
        this.resp4 = dis.readFloat();
        this.resp5 = dis.readFloat();
        this.resp6 = dis.readFloat();
        this.resp7 = dis.readFloat();
        this.resp8 = dis.readFloat();
        this.resp9 = dis.readFloat();
        this.stla = dis.readFloat();
        this.stlo = dis.readFloat();
        this.stel = dis.readFloat();
        this.stdp = dis.readFloat();
        this.evla = dis.readFloat();
        this.evlo = dis.readFloat();
        this.evel = dis.readFloat();
        this.evdp = dis.readFloat();
        this.mag = dis.readFloat();
        this.user0 = dis.readFloat();
        this.user1 = dis.readFloat();
        this.user2 = dis.readFloat();
        this.user3 = dis.readFloat();
        this.user4 = dis.readFloat();
        this.user5 = dis.readFloat();
        this.user6 = dis.readFloat();
        this.user7 = dis.readFloat();
        this.user8 = dis.readFloat();
        this.user9 = dis.readFloat();
        this.dist = dis.readFloat();
        this.az = dis.readFloat();
        this.baz = dis.readFloat();
        this.gcarc = dis.readFloat();
        this.sb = dis.readFloat();
        this.sdelta = dis.readFloat();
        this.depmen = dis.readFloat();
        this.cmpaz = dis.readFloat();
        this.cmpinc = dis.readFloat();
        this.xminimum = dis.readFloat();
        this.xmaximum = dis.readFloat();
        this.yminimum = dis.readFloat();
        this.ymaximum = dis.readFloat();
        this.unused6 = dis.readFloat();
        this.unused7 = dis.readFloat();
        this.unused8 = dis.readFloat();
        this.unused9 = dis.readFloat();
        this.unused10 = dis.readFloat();
        this.unused11 = dis.readFloat();
        this.unused12 = dis.readFloat();
        this.nzyear = dis.readInt();
        this.nzjday = dis.readInt();
        this.nzhour = dis.readInt();
        this.nzmin = dis.readInt();
        this.nzsec = dis.readInt();
        this.nzmsec = dis.readInt();
        this.nvhdr = dis.readInt();
        this.norid = dis.readInt();
        this.nevid = dis.readInt();
        this.npts = dis.readInt();
        this.nsnpts = dis.readInt();
        this.nwfid = dis.readInt();
        this.nxsize = dis.readInt();
        this.nysize = dis.readInt();
        this.unused15 = dis.readInt();
        this.iftype = dis.readInt();
        this.idep = dis.readInt();
        this.iztype = dis.readInt();
        this.unused16 = dis.readInt();
        this.iinst = dis.readInt();
        this.istreg = dis.readInt();
        this.ievreg = dis.readInt();
        this.ievtyp = dis.readInt();
        this.iqual = dis.readInt();
        this.isynth = dis.readInt();
        this.imagtyp = dis.readInt();
        this.imagsrc = dis.readInt();
        this.unused19 = dis.readInt();
        this.unused20 = dis.readInt();
        this.unused21 = dis.readInt();
        this.unused22 = dis.readInt();
        this.unused23 = dis.readInt();
        this.unused24 = dis.readInt();
        this.unused25 = dis.readInt();
        this.unused26 = dis.readInt();
        this.leven = dis.readInt();
        this.lpspol = dis.readInt();
        this.lovrok = dis.readInt();
        this.lcalda = dis.readInt();
        this.unused27 = dis.readInt();
        byte[] eightBytes = new byte[8];
        byte[] sixteenBytes = new byte[16];
        dis.readFully(eightBytes);
        this.kstnm = new String(eightBytes);
        dis.readFully(sixteenBytes);
        this.kevnm = new String(sixteenBytes);
        dis.readFully(eightBytes);
        this.khole = new String(eightBytes);
        dis.readFully(eightBytes);
        this.ko = new String(eightBytes);
        dis.readFully(eightBytes);
        this.ka = new String(eightBytes);
        dis.readFully(eightBytes);
        this.kt0 = new String(eightBytes);
        dis.readFully(eightBytes);
        this.kt1 = new String(eightBytes);
        dis.readFully(eightBytes);
        this.kt2 = new String(eightBytes);
        dis.readFully(eightBytes);
        this.kt3 = new String(eightBytes);
        dis.readFully(eightBytes);
        this.kt4 = new String(eightBytes);
        dis.readFully(eightBytes);
        this.kt5 = new String(eightBytes);
        dis.readFully(eightBytes);
        this.kt6 = new String(eightBytes);
        dis.readFully(eightBytes);
        this.kt7 = new String(eightBytes);
        dis.readFully(eightBytes);
        this.kt8 = new String(eightBytes);
        dis.readFully(eightBytes);
        this.kt9 = new String(eightBytes);
        dis.readFully(eightBytes);
        this.kf = new String(eightBytes);
        dis.readFully(eightBytes);
        this.kuser0 = new String(eightBytes);
        dis.readFully(eightBytes);
        this.kuser1 = new String(eightBytes);
        dis.readFully(eightBytes);
        this.kuser2 = new String(eightBytes);
        dis.readFully(eightBytes);
        this.kcmpnm = new String(eightBytes);
        dis.readFully(eightBytes);
        this.knetwk = new String(eightBytes);
        dis.readFully(eightBytes);
        this.kdatrd = new String(eightBytes);
        dis.readFully(eightBytes);
        this.kinst = new String(eightBytes);
    }

    public void readData(DataInputStream fis) throws IOException {
        DataInputStream in = fis;
        this.y = new float[this.npts];
        int numAdded = 0;
        byte[] overflow = new byte[4];
        byte[] prevoverflow = new byte[4];
        int overflowBytes = 0;
        int prevoverflowBytes = 0;
        byte[] buf = new byte[4096];
        while (numAdded < this.npts) {
            int numRead = ((InputStream)in).read(buf);
            if (numRead == 0) continue;
            if (numRead == -1) {
                throw new EOFException();
            }
            overflowBytes = (numRead + prevoverflowBytes) % 4;
            if (overflowBytes != 0) {
                System.arraycopy(buf, numRead - overflowBytes, overflow, 0, overflowBytes);
            }
            int i = 0;
            if (prevoverflowBytes != 0) {
                int temp = 0;
                i = 0;
                while (i < prevoverflowBytes) {
                    temp <<= 8;
                    temp += prevoverflow[i] & 0xFF;
                    ++i;
                }
                i = 0;
                while (i < 4 - prevoverflowBytes) {
                    temp <<= 8;
                    temp += buf[i] & 0xFF;
                    ++i;
                }
                this.y[numAdded] = Float.intBitsToFloat(temp);
                ++numAdded;
            }
            while (i <= numRead - 4) {
                this.y[numAdded++] = Float.intBitsToFloat(((buf[i++] & 0xFF) << 24) + ((buf[i++] & 0xFF) << 16) + ((buf[i++] & 0xFF) << 8) + ((buf[i++] & 0xFF) << 0));
            }
            System.arraycopy(overflow, 0, prevoverflow, 0, overflowBytes);
            prevoverflowBytes = overflowBytes;
        }
        if (!this.byteOrder) {
            int j = 0;
            while (j < this.y.length) {
                this.y[j] = SAC.swapBytes(this.y[j]);
                ++j;
            }
        }
    }

    protected void readDataOld(DataInputStream dis) throws FileNotFoundException, IOException {
        this.y = new float[this.npts];
        int i = 0;
        while (i < this.npts) {
            this.y[i] = dis.readFloat();
            ++i;
        }
        if (this.leven == 0 || this.iftype == 2 || this.iftype == 3) {
            this.x = new float[this.npts];
            i = 0;
            while (i < this.npts) {
                this.x[i] = dis.readFloat();
                ++i;
            }
            if (this.iftype == 2) {
                this.real = this.y;
                this.imaginary = this.x;
            }
            if (this.iftype == 3) {
                this.amp = this.y;
                this.phase = this.x;
            }
        }
    }

    public void write(String filename) throws FileNotFoundException, IOException {
        File f = new File(filename);
        this.write(f);
    }

    public void write(File file) throws FileNotFoundException, IOException {
        DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
        this.writeHeader(dos);
        this.writeData(dos);
        dos.close();
    }

    private final void writeFloat(DataOutputStream dos, float val) throws IOException {
        if (!this.byteOrder) {
            dos.writeFloat(SAC.swapBytes(val));
        } else {
            dos.writeFloat(val);
        }
    }

    private final void writeInt(DataOutputStream dos, int val) throws IOException {
        if (!this.byteOrder) {
            dos.writeInt(SAC.swapBytes(val));
        } else {
            dos.writeInt(val);
        }
    }

    public void writeHeader(DataOutputStream dos) throws IOException {
        this.writeFloat(dos, this.delta);
        this.writeFloat(dos, this.depmin);
        this.writeFloat(dos, this.depmax);
        this.writeFloat(dos, this.scale);
        this.writeFloat(dos, this.odelta);
        this.writeFloat(dos, this.b);
        this.writeFloat(dos, this.e);
        this.writeFloat(dos, this.o);
        this.writeFloat(dos, this.a);
        this.writeFloat(dos, this.fmt);
        this.writeFloat(dos, this.t0);
        this.writeFloat(dos, this.t1);
        this.writeFloat(dos, this.t2);
        this.writeFloat(dos, this.t3);
        this.writeFloat(dos, this.t4);
        this.writeFloat(dos, this.t5);
        this.writeFloat(dos, this.t6);
        this.writeFloat(dos, this.t7);
        this.writeFloat(dos, this.t8);
        this.writeFloat(dos, this.t9);
        this.writeFloat(dos, this.f);
        this.writeFloat(dos, this.resp0);
        this.writeFloat(dos, this.resp1);
        this.writeFloat(dos, this.resp2);
        this.writeFloat(dos, this.resp3);
        this.writeFloat(dos, this.resp4);
        this.writeFloat(dos, this.resp5);
        this.writeFloat(dos, this.resp6);
        this.writeFloat(dos, this.resp7);
        this.writeFloat(dos, this.resp8);
        this.writeFloat(dos, this.resp9);
        this.writeFloat(dos, this.stla);
        this.writeFloat(dos, this.stlo);
        this.writeFloat(dos, this.stel);
        this.writeFloat(dos, this.stdp);
        this.writeFloat(dos, this.evla);
        this.writeFloat(dos, this.evlo);
        this.writeFloat(dos, this.evel);
        this.writeFloat(dos, this.evdp);
        this.writeFloat(dos, this.mag);
        this.writeFloat(dos, this.user0);
        this.writeFloat(dos, this.user1);
        this.writeFloat(dos, this.user2);
        this.writeFloat(dos, this.user3);
        this.writeFloat(dos, this.user4);
        this.writeFloat(dos, this.user5);
        this.writeFloat(dos, this.user6);
        this.writeFloat(dos, this.user7);
        this.writeFloat(dos, this.user8);
        this.writeFloat(dos, this.user9);
        this.writeFloat(dos, this.dist);
        this.writeFloat(dos, this.az);
        this.writeFloat(dos, this.baz);
        this.writeFloat(dos, this.gcarc);
        this.writeFloat(dos, this.sb);
        this.writeFloat(dos, this.sdelta);
        this.writeFloat(dos, this.depmen);
        this.writeFloat(dos, this.cmpaz);
        this.writeFloat(dos, this.cmpinc);
        this.writeFloat(dos, this.xminimum);
        this.writeFloat(dos, this.xmaximum);
        this.writeFloat(dos, this.yminimum);
        this.writeFloat(dos, this.ymaximum);
        this.writeFloat(dos, this.unused6);
        this.writeFloat(dos, this.unused7);
        this.writeFloat(dos, this.unused8);
        this.writeFloat(dos, this.unused9);
        this.writeFloat(dos, this.unused10);
        this.writeFloat(dos, this.unused11);
        this.writeFloat(dos, this.unused12);
        this.writeInt(dos, this.nzyear);
        this.writeInt(dos, this.nzjday);
        this.writeInt(dos, this.nzhour);
        this.writeInt(dos, this.nzmin);
        this.writeInt(dos, this.nzsec);
        this.writeInt(dos, this.nzmsec);
        this.writeInt(dos, this.nvhdr);
        this.writeInt(dos, this.norid);
        this.writeInt(dos, this.nevid);
        this.writeInt(dos, this.npts);
        this.writeInt(dos, this.nsnpts);
        this.writeInt(dos, this.nwfid);
        this.writeInt(dos, this.nxsize);
        this.writeInt(dos, this.nysize);
        this.writeInt(dos, this.unused15);
        this.writeInt(dos, this.iftype);
        this.writeInt(dos, this.idep);
        this.writeInt(dos, this.iztype);
        this.writeInt(dos, this.unused16);
        this.writeInt(dos, this.iinst);
        this.writeInt(dos, this.istreg);
        this.writeInt(dos, this.ievreg);
        this.writeInt(dos, this.ievtyp);
        this.writeInt(dos, this.iqual);
        this.writeInt(dos, this.isynth);
        this.writeInt(dos, this.imagtyp);
        this.writeInt(dos, this.imagsrc);
        this.writeInt(dos, this.unused19);
        this.writeInt(dos, this.unused20);
        this.writeInt(dos, this.unused21);
        this.writeInt(dos, this.unused22);
        this.writeInt(dos, this.unused23);
        this.writeInt(dos, this.unused24);
        this.writeInt(dos, this.unused25);
        this.writeInt(dos, this.unused26);
        this.writeInt(dos, this.leven);
        this.writeInt(dos, this.lpspol);
        this.writeInt(dos, this.lovrok);
        this.writeInt(dos, this.lcalda);
        this.writeInt(dos, this.unused27);
        if (this.kstnm.length() > 8) {
            this.kstnm = this.kstnm.substring(0, 7);
        }
        while (this.kstnm.length() < 8) {
            this.kstnm = String.valueOf(this.kstnm) + " ";
        }
        dos.writeBytes(this.kstnm);
        if (this.kevnm.length() > 16) {
            this.kevnm = this.kevnm.substring(0, 15);
        }
        while (this.kevnm.length() < 16) {
            this.kevnm = String.valueOf(this.kevnm) + " ";
        }
        dos.writeBytes(this.kevnm);
        if (this.khole.length() > 8) {
            this.khole = this.khole.substring(0, 7);
        }
        while (this.khole.length() < 8) {
            this.khole = String.valueOf(this.khole) + " ";
        }
        dos.writeBytes(this.khole);
        if (this.ko.length() > 8) {
            this.ko = this.ko.substring(0, 7);
        }
        while (this.ko.length() < 8) {
            this.ko = String.valueOf(this.ko) + " ";
        }
        dos.writeBytes(this.ko);
        if (this.ka.length() > 8) {
            this.ka = this.ka.substring(0, 7);
        }
        while (this.ka.length() < 8) {
            this.ka = String.valueOf(this.ka) + " ";
        }
        dos.writeBytes(this.ka);
        if (this.kt0.length() > 8) {
            this.kt0 = this.kt0.substring(0, 7);
        }
        while (this.kt0.length() < 8) {
            this.kt0 = String.valueOf(this.kt0) + " ";
        }
        dos.writeBytes(this.kt0);
        if (this.kt1.length() > 8) {
            this.kt1 = this.kt1.substring(0, 7);
        }
        while (this.kt1.length() < 8) {
            this.kt1 = String.valueOf(this.kt1) + " ";
        }
        dos.writeBytes(this.kt1);
        if (this.kt2.length() > 8) {
            this.kt2 = this.kt2.substring(0, 7);
        }
        while (this.kt2.length() < 8) {
            this.kt2 = String.valueOf(this.kt2) + " ";
        }
        dos.writeBytes(this.kt2);
        if (this.kt3.length() > 8) {
            this.kt3 = this.kt3.substring(0, 7);
        }
        while (this.kt3.length() < 8) {
            this.kt3 = String.valueOf(this.kt3) + " ";
        }
        dos.writeBytes(this.kt3);
        if (this.kt4.length() > 8) {
            this.kt4 = this.kt4.substring(0, 7);
        }
        while (this.kt4.length() < 8) {
            this.kt4 = String.valueOf(this.kt4) + " ";
        }
        dos.writeBytes(this.kt4);
        if (this.kt5.length() > 8) {
            this.kt5 = this.kt5.substring(0, 7);
        }
        while (this.kt5.length() < 8) {
            this.kt5 = String.valueOf(this.kt5) + " ";
        }
        dos.writeBytes(this.kt5);
        if (this.kt6.length() > 8) {
            this.kt6 = this.kt6.substring(0, 7);
        }
        while (this.kt6.length() < 8) {
            this.kt6 = String.valueOf(this.kt6) + " ";
        }
        dos.writeBytes(this.kt6);
        if (this.kt7.length() > 8) {
            this.kt7 = this.kt7.substring(0, 7);
        }
        while (this.kt7.length() < 8) {
            this.kt7 = String.valueOf(this.kt7) + " ";
        }
        dos.writeBytes(this.kt7);
        if (this.kt8.length() > 8) {
            this.kt8 = this.kt8.substring(0, 7);
        }
        while (this.kt8.length() < 8) {
            this.kt8 = String.valueOf(this.kt8) + " ";
        }
        dos.writeBytes(this.kt8);
        if (this.kt9.length() > 8) {
            this.kt9 = this.kt9.substring(0, 7);
        }
        while (this.kt9.length() < 8) {
            this.kt9 = String.valueOf(this.kt9) + " ";
        }
        dos.writeBytes(this.kt9);
        if (this.kf.length() > 8) {
            this.kf = this.kf.substring(0, 7);
        }
        while (this.kf.length() < 8) {
            this.kf = String.valueOf(this.kf) + " ";
        }
        dos.writeBytes(this.kf);
        if (this.kuser0.length() > 8) {
            this.kuser0 = this.kuser0.substring(0, 7);
        }
        while (this.kuser0.length() < 8) {
            this.kuser0 = String.valueOf(this.kuser0) + " ";
        }
        dos.writeBytes(this.kuser0);
        if (this.kuser1.length() > 8) {
            this.kuser1 = this.kuser1.substring(0, 7);
        }
        while (this.kuser1.length() < 8) {
            this.kuser1 = String.valueOf(this.kuser1) + " ";
        }
        dos.writeBytes(this.kuser1);
        if (this.kuser2.length() > 8) {
            this.kuser2 = this.kuser2.substring(0, 7);
        }
        while (this.kuser2.length() < 8) {
            this.kuser2 = String.valueOf(this.kuser2) + " ";
        }
        dos.writeBytes(this.kuser2);
        if (this.kcmpnm.length() > 8) {
            this.kcmpnm = this.kcmpnm.substring(0, 7);
        }
        while (this.kcmpnm.length() < 8) {
            this.kcmpnm = String.valueOf(this.kcmpnm) + " ";
        }
        dos.writeBytes(this.kcmpnm);
        if (this.knetwk.length() > 8) {
            this.knetwk = this.knetwk.substring(0, 7);
        }
        while (this.knetwk.length() < 8) {
            this.knetwk = String.valueOf(this.knetwk) + " ";
        }
        dos.writeBytes(this.knetwk);
        if (this.kdatrd.length() > 8) {
            this.kdatrd = this.kdatrd.substring(0, 7);
        }
        while (this.kdatrd.length() < 8) {
            this.kdatrd = String.valueOf(this.kdatrd) + " ";
        }
        dos.writeBytes(this.kdatrd);
        if (this.kinst.length() > 8) {
            this.kinst = this.kinst.substring(0, 7);
        }
        while (this.kinst.length() < 8) {
            this.kinst = String.valueOf(this.kinst) + " ";
        }
        dos.writeBytes(this.kinst);
    }

    public void writeData(DataOutputStream dos) throws IOException {
        int i = 0;
        while (i < this.npts) {
            this.writeFloat(dos, this.y[i]);
            ++i;
        }
        if (this.leven == 0 || this.iftype == 2 || this.iftype == 3) {
            i = 0;
            while (i < this.npts) {
                this.writeFloat(dos, this.x[i]);
                ++i;
            }
        }
    }

    public void printHeader() {
        System.out.println("delta = " + this.delta + " depmin = " + this.depmin + " depmax = " + this.depmax + " scale = " + this.scale + " odelta = " + this.odelta);
        System.out.println("b = " + this.b + " e = " + this.e + " o = " + this.o + " a = " + this.a + " fmt = " + this.fmt);
        System.out.println("t0 = " + this.t0 + " t1 = " + this.t1 + " t2 = " + this.t2 + " t3 = " + this.t3 + " t4 = " + this.t4);
        System.out.println("t5 = " + this.t5 + " t6 = " + this.t6 + " t7 = " + this.t7 + " t8 = " + this.t8 + " t9 = " + this.t9);
        System.out.println("f = " + this.f + " resp0 = " + this.resp0 + " resp1 = " + this.resp1 + " resp2 = " + this.resp2 + " resp3 = " + this.resp3);
        System.out.println("resp4 = " + this.resp4 + " resp5 = " + this.resp5 + " resp6 = " + this.resp6 + " resp7 = " + this.resp7 + " resp8 = " + this.resp8);
        System.out.println("resp9 = " + this.resp9 + " stla = " + this.stla + " stlo = " + this.stlo + " stel = " + this.stel + " stdp = " + this.stdp);
        System.out.println("evla = " + this.evla + " evlo = " + this.evlo + " evel = " + this.evel + " evdp = " + this.evdp + " mag = " + this.mag);
        System.out.println("user0 = " + this.user0 + " user1 = " + this.user1 + " user2 = " + this.user2 + " user3 = " + this.user3 + " user4 = " + this.user4);
        System.out.println("user5 = " + this.user5 + " user6 = " + this.user6 + " user7 = " + this.user7 + " user8 = " + this.user8 + " user9 = " + this.user9);
        System.out.println("dist = " + this.dist + " az = " + this.az + " baz = " + this.baz + " gcarc = " + this.gcarc + " sb = " + this.sb);
        System.out.println("sdelta = " + this.sdelta + " depmen = " + this.depmen + " cmpaz = " + this.cmpaz + " cmpinc = " + this.cmpinc + " xminimum = " + this.xminimum);
        System.out.println("xmaximum = " + this.xmaximum + " yminimum = " + this.yminimum + " ymaximum = " + this.ymaximum + " unused6 = " + this.unused6 + " unused7 = " + this.unused7);
        System.out.println("unused8 = " + this.unused8 + " unused9 = " + this.unused9 + " unused10 = " + this.unused10 + " unused11 = " + this.unused11 + " unused12 = " + this.unused12);
        System.out.println("nzyear = " + this.nzyear + " nzjday = " + this.nzjday + " nzhour = " + this.nzhour + " nzmin = " + this.nzmin + " nzsec = " + this.nzsec);
        System.out.println("nzmsec = " + this.nzmsec + " nvhdr = " + this.nvhdr + " norid = " + this.norid + " nevid = " + this.nevid + " npts = " + this.npts);
        System.out.println("nsnpts = " + this.nsnpts + " nwfid = " + this.nwfid + " nxsize = " + this.nxsize + " nysize = " + this.nysize + " unused15 = " + this.unused15);
        System.out.println("iftype = " + this.iftype + " idep = " + this.idep + " iztype = " + this.iztype + " unused16 = " + this.unused16 + " iinst = " + this.iinst);
        System.out.println("istreg = " + this.istreg + " ievreg = " + this.ievreg + " ievtyp = " + this.ievtyp + " iqual = " + this.iqual + " isynth = " + this.isynth);
        System.out.println("imagtyp = " + this.imagtyp + " imagsrc = " + this.imagsrc + " unused19 = " + this.unused19 + " unused20 = " + this.unused20 + " unused21 = " + this.unused21);
        System.out.println("unused22 = " + this.unused22 + " unused23 = " + this.unused23 + " unused24 = " + this.unused24 + " unused25 = " + this.unused25 + " unused26 = " + this.unused26);
        System.out.println("leven = " + this.leven + " lpspol = " + this.lpspol + " lovrok = " + this.lovrok + " lcalda = " + this.lcalda + " unused27 = " + this.unused27);
        System.out.println(" kstnm = " + this.kstnm + " kevnm = " + this.kevnm + " khole = " + this.khole + " ko = " + this.ko);
        System.out.println(" ka = " + this.ka + " kt0 = " + this.kt0 + " kt1 = " + this.kt1 + " kt2 = " + this.kt2);
        System.out.println(" kt3 = " + this.kt3 + " kt4 = " + this.kt4 + " kt5 = " + this.kt5 + " kt6 = " + this.kt6);
        System.out.println(" kt7 = " + this.kt7 + " kt8 = " + this.kt8 + " kt9 = " + this.kt9 + " kf = " + this.kf);
        System.out.println(" kuser0 = " + this.kuser0 + " kuser1 = " + this.kuser1 + " kuser2 = " + this.kuser2 + " kcmpnm = " + this.kcmpnm);
        System.out.println(" knetwk = " + this.knetwk + " kdatrd = " + this.kdatrd + " kinst = " + this.kinst);
    }

    public Wave toWave() {
        Wave sw = new Wave();
        sw.setStartTime(Util.dateToJ2K(this.getStartTime()));
        sw.setSamplingRate(this.getSamplingRate());
        sw.buffer = new int[this.y.length];
        int i = 0;
        while (i < this.y.length) {
            sw.buffer[i] = Math.round(this.y[i]);
            ++i;
        }
        return sw;
    }

    public String getStationInfo() {
        return String.valueOf(this.kstnm.trim()) + "_" + this.kcmpnm.trim() + "_" + this.knetwk.trim();
    }

    public String getWinstonChannel() {
        return String.valueOf(this.kstnm.trim()) + "$" + this.kcmpnm.trim() + "$" + this.knetwk.trim().replace('-', 'D');
    }

    public Date getStartTime() {
        String ds = String.valueOf(this.nzyear) + "," + this.nzjday + "," + this.nzhour + "," + this.nzmin + "," + this.nzsec + "," + this.nzmsec;
        SimpleDateFormat format = new SimpleDateFormat("yyyy,DDD,HH,mm,ss,SSS");
        format.setTimeZone(TimeZone.getTimeZone("GMT"));
        Date d = null;
        try {
            d = format.parse(ds);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return d;
    }

    public double getSamplingRate() {
        return 1.0f / this.delta;
    }

    public static void main(String[] args) {
        SAC data = new SAC();
        if (args.length != 1) {
            System.out.println("Usage: java gov.usgs.vdx.data.wave.SAC sacsourcefile ");
            return;
        }
        try {
            data.read(args[0]);
            data.printHeader();
            System.out.println(data.getStationInfo());
            System.out.println(Util.formatDate(data.getStartTime()));
            System.out.println(data.getSamplingRate());
            Wave sw = data.toWave();
            System.out.println(sw);
        }
        catch (FileNotFoundException e) {
            System.out.println("File " + args[0] + " doesn't exist.");
        }
        catch (IOException e) {
            System.out.println("IOException: " + e.getMessage());
        }
    }
}

