/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.winston.db;

import gov.usgs.earthworm.TraceBuf;
import gov.usgs.util.Time;
import gov.usgs.util.Util;
import gov.usgs.vdx.data.heli.HelicorderData;
import gov.usgs.vdx.data.rsam.RSAMData;
import gov.usgs.vdx.data.wave.Wave;
import gov.usgs.winston.db.Channels;
import gov.usgs.winston.db.WinstonDatabase;
import java.io.IOException;
import java.sql.Blob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;
import java.util.logging.Level;

public class Data {
    private WinstonDatabase winston;
    private Channels channels;
    private DateFormat dateFormat;
    private static final double EPSILON = 1.0E-7;

    public Data(WinstonDatabase w) {
        this.winston = w;
        this.channels = new Channels(w);
        this.dateFormat = new SimpleDateFormat("yyyy_MM_dd");
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    public double[] getTimeSpan(String code) {
        if (!this.winston.checkConnect()) {
            return null;
        }
        try {
            ResultSet rs = this.winston.getStatement().executeQuery("SELECT st, et FROM " + this.winston.getDatabasePrefix() + "_ROOT.channels WHERE code='" + code + "'");
            rs.next();
            double[] d = new double[]{rs.getDouble(1), rs.getDouble(2)};
            rs.close();
            return d;
        }
        catch (Exception e) {
            this.winston.getLogger().log(Level.SEVERE, "Could not get time span for channel: " + code, e);
            return null;
        }
    }

    public double[] getTimeSpan(int sid) {
        String code = this.channels.getChannelCode(sid);
        return this.getTimeSpan(code);
    }

    private List<String> daysBetween(double t1, double t2) {
        ArrayList<String> result = new ArrayList<String>();
        double ct = t1;
        while (ct < t2 + 86400.0) {
            result.add(Time.format("yyyy_MM_dd", ct));
            ct += 86400.0;
        }
        return result;
    }

    public List<double[]> findGaps(String code, double t1, double t2) {
        if (!this.winston.checkConnect()) {
            return null;
        }
        ArrayList<double[]> gaps = new ArrayList<double[]>();
        if (!this.winston.useDatabase(code)) {
            gaps.add(new double[]{t1, t2});
            return gaps;
        }
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy_MM_dd");
            List<String> days = this.daysBetween(t1, t2);
            dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            ArrayList<double[]> bufs = new ArrayList<double[]>(172800);
            for (String day : days) {
                double tst = Time.parse("yyyy_MM_dd", day);
                double tet = tst + 86400.0;
                String table = String.valueOf(code) + "$$" + day;
                if (!this.winston.tableExists(code, table) || tet < t1 || tst > t2) continue;
                ResultSet rs = this.winston.getStatement().executeQuery("SELECT st, et FROM " + table + " ORDER BY st ASC");
                while (rs.next()) {
                    double start = rs.getDouble(1);
                    double end = rs.getDouble(2);
                    if (end < t1 || start > t2) continue;
                    bufs.add(new double[]{start, end});
                }
                rs.close();
            }
            if (bufs == null || bufs.size() == 0) {
                gaps.add(new double[]{t1, t2});
                return gaps;
            }
            double epsilon = 0.01;
            if (((double[])bufs.get(0))[0] > t1) {
                gaps.add(new double[]{t1, ((double[])bufs.get(0))[0]});
            }
            double last = ((double[])bufs.get(0))[1];
            int i = 1;
            while (i < bufs.size()) {
                block16: {
                    double[] buf;
                    block15: {
                        buf = (double[])bufs.get(i);
                        if (!(buf[0] - last > epsilon)) break block15;
                        double start = last;
                        double end = buf[0];
                        if (end < t1 || start > t2) break block16;
                        if (start < t1) {
                            start = t1;
                        }
                        if (end > t2) {
                            end = t2;
                        }
                        gaps.add(new double[]{start, end});
                    }
                    last = buf[1];
                }
                ++i;
            }
            if (((double[])bufs.get(bufs.size() - 1))[1] < t2) {
                gaps.add(new double[]{((double[])bufs.get(bufs.size() - 1))[1], t2});
            }
            return gaps;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public double[] findFirstGap(String channel, double t1, double t2) {
        if (!this.winston.checkConnect()) {
            return null;
        }
        double[] gap = new double[]{Double.NaN, Double.NaN};
        if (!this.winston.useDatabase(channel)) {
            gap[0] = t1;
            gap[1] = t2;
            return gap;
        }
        try {
            List<String> days = this.daysBetween(t1, t2);
            int i = 0;
            double lastKnownGood = t1;
            double epsilon = 0.01;
            i = 0;
            while (i < days.size()) {
                String day = days.get(i);
                double tst = Time.parse("yyyy_MM_dd", day);
                double tet = tst + 86400.0;
                String table = String.valueOf(channel) + "$$" + day;
                if (!this.winston.tableExists(channel, table)) {
                    gap[0] = lastKnownGood;
                    gap[1] = Math.min(tet, t2);
                    return gap;
                }
                ResultSet rs = this.winston.getStatement().executeQuery("SELECT st, et FROM " + table + " WHERE st >= " + (lastKnownGood - 2.0) + " ORDER BY st ASC");
                int j = 0;
                while (rs.next()) {
                    double start = rs.getDouble(1);
                    double end = rs.getDouble(2);
                    if (end < t1 || start > t2) continue;
                    if (start - lastKnownGood > epsilon) {
                        gap[0] = lastKnownGood;
                        gap[1] = start;
                        rs.close();
                        return gap;
                    }
                    lastKnownGood = end;
                    ++j;
                }
                rs.close();
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public double[] getOverlapper(String code, double t1, double t2) {
        if (!this.winston.checkConnect()) return null;
        if (!this.winston.useDatabase(code)) {
            return null;
        }
        try {
            String endDate = this.dateFormat.format(Util.j2KToDate(t2));
            String firstDate = this.dateFormat.format(Util.j2KToDate(t1));
            if (!endDate.equals(firstDate)) {
                System.out.println("spans day");
                return null;
            }
            String sql = "SELECT st, et FROM " + code + "$$" + firstDate + " WHERE st<" + (t2 - 1.0E-7) + " AND st>" + (t1 + 1.0E-7) + " LIMIT 1";
            ResultSet rs = this.winston.getStatement().executeQuery(sql);
            if (rs.next()) {
                double[] d = new double[]{rs.getDouble(1), rs.getDouble(2)};
                rs.close();
                return d;
            }
            sql = "SELECT st, et FROM " + code + "$$" + firstDate + " WHERE et<" + (t2 - 1.0E-7) + " AND et>" + (t1 + 1.0E-7) + " LIMIT 1";
            rs = this.winston.getStatement().executeQuery(sql);
            if (!rs.next()) {
                return null;
            }
            double[] d = new double[]{rs.getDouble(1), rs.getDouble(2)};
            rs.close();
            return d;
        }
        catch (Exception e) {
            if (e.getMessage().indexOf("doesn't exist") != -1) return null;
            this.winston.getLogger().log(Level.SEVERE, "Could not determine tracebuf existence: " + code, e);
        }
        return null;
    }

    public Wave getWave(int sid, double t1, double t2) {
        String code = this.channels.getChannelCode(sid);
        return this.getWave(code, t1, t2);
    }

    private byte[] getTraceBufBytes(ResultSet rs) throws SQLException, IOException {
        Blob b = rs.getBlob("tracebuf");
        byte[] bs = b.getBytes(1L, (int)b.length());
        bs = Util.decompress(bs, 512);
        return bs;
    }

    /*
     * Unable to fully structure code
     */
    public List<byte[]> getTraceBufBytes(String code, double t1, double t2) {
        if (!this.winston.checkConnect() || !this.winston.useDatabase(code)) {
            return null;
        }
        try {
            ct = t1;
            bufs = new ArrayList<byte[]>((int)Math.ceil(t2 - t1) + 1);
            endDate = this.dateFormat.format(Util.j2KToDate(t2));
            done = false;
            rs = null;
            firstDate = this.dateFormat.format(Util.j2KToDate(t1 - 86400.0));
            secondDate = this.dateFormat.format(Util.j2KToDate(t1));
            sql = "SELECT st, et, sr, datatype, tracebuf FROM " + code + "$$" + firstDate + " WHERE st<? ORDER BY st DESC LIMIT 1";
            ps = this.winston.getPreparedStatement(sql);
            try {
                ps.setDouble(1, t1);
                rs = ps.executeQuery();
                if (rs.next() && t1 >= rs.getDouble(1) && t1 <= rs.getDouble(2)) {
                    bufs.add(this.getTraceBufBytes(rs));
                }
                rs.close();
            }
            catch (SQLException var16_14) {
                // empty catch block
            }
            sql = "SELECT st, et, sr, datatype, tracebuf FROM " + code + "$$" + secondDate + " WHERE st<? ORDER BY st DESC LIMIT 1";
            ps = this.winston.getPreparedStatement(sql);
            ps.setDouble(1, t1);
            rs = ps.executeQuery();
            if (rs.next() && t1 >= rs.getDouble(1) && t1 <= rs.getDouble(2)) {
                bufs.add(this.getTraceBufBytes(rs));
            }
            rs.close();
            while (!done) {
                date = this.dateFormat.format(Util.j2KToDate(ct));
                if (date.equals(endDate)) {
                    done = true;
                }
                ct += 86400.0;
                sql = "SELECT sr, datatype, tracebuf FROM " + code + "$$" + date + " WHERE st>=" + t1 + " AND st<=" + t2 + " ORDER BY st ASC";
                try {
                    rs = this.winston.getStatement().executeQuery(sql);
                    if (true) ** GOTO lbl45
                }
                catch (SQLException e) {
                    continue;
                }
                do {
                    bufs.add(this.getTraceBufBytes(rs));
lbl45:
                    // 2 sources

                } while (rs.next());
                rs.close();
            }
            return bufs;
        }
        catch (Exception e) {
            this.winston.getLogger().log(Level.INFO, "Could not get TraceBuf bytes for " + code + ", " + t1 + "->" + t2, Util.getLineNumber(this, e));
            return null;
        }
    }

    public List<TraceBuf> getTraceBufs(String code, double t1, double t2) {
        List<byte[]> rawBufs = this.getTraceBufBytes(code, t1, t2);
        if (rawBufs == null || rawBufs.size() == 0) {
            return null;
        }
        try {
            ArrayList<TraceBuf> traceBufs = new ArrayList<TraceBuf>(rawBufs.size());
            for (byte[] buf : rawBufs) {
                traceBufs.add(new TraceBuf(buf));
            }
            return traceBufs;
        }
        catch (Exception e) {
            this.winston.getLogger().log(Level.SEVERE, "Could not get TraceBufs for " + code + ", " + t1 + "->" + t2, Util.getLineNumber(this, e));
            return null;
        }
    }

    public Wave getWave(String code, double t1, double t2) {
        if (!this.winston.checkConnect() || !this.winston.useDatabase(code)) {
            return null;
        }
        List<TraceBuf> bufs = this.getTraceBufs(code, t1, t2);
        if (bufs == null || bufs.size() == 0) {
            return null;
        }
        Wave wave = TraceBuf.traceBufToWave(bufs, true);
        wave.convertToJ2K();
        return wave;
    }

    /*
     * Unable to fully structure code
     */
    public HelicorderData getHelicorderData(String code, double t1, double t2) {
        if (!this.winston.checkConnect() || !this.winston.useDatabase(code)) {
            return null;
        }
        try {
            ct = t1;
            endDate = this.dateFormat.format(Util.j2KToDate(t2));
            done = false;
            list = new ArrayList<double[]>((int)(t2 - t1) + 2);
            while (!done) {
                date = this.dateFormat.format(Util.j2KToDate(ct));
                if (date.equals(endDate)) {
                    done = true;
                }
                ct += 86400.0;
                table = String.valueOf(code) + "$$H" + date;
                rs = null;
                select = this.winston.getPreparedStatement("SELECT j2ksec, smin, smax, rcnt FROM " + table + " WHERE j2ksec>=? AND j2ksec<=? AND rcnt>0 ORDER BY j2ksec ASC");
                try {
                    select.setDouble(1, t1);
                    select.setDouble(2, t2);
                    rs = select.executeQuery();
                    if (true) ** GOTO lbl28
                }
                catch (Exception e) {
                    continue;
                }
                do {
                    d = new double[]{rs.getDouble(1), rs.getDouble(2), rs.getDouble(3)};
                    if (!(rs.getDouble(4) > 0.0)) continue;
                    list.add(d);
lbl28:
                    // 3 sources

                } while (rs.next());
                rs.close();
            }
            return new HelicorderData(list);
        }
        catch (Exception e) {
            this.winston.getLogger().log(Level.SEVERE, "Could not get helicorder for " + code + ", " + t1 + "->" + t2, Util.getLineNumber(this, e));
            return null;
        }
    }

    /*
     * Unable to fully structure code
     */
    public RSAMData getRSAMData(String code, double t1, double t2, double period) {
        if (!this.winston.checkConnect() || !this.winston.useDatabase(code)) {
            return null;
        }
        try {
            ct = t1;
            endDate = this.dateFormat.format(Util.j2KToDate(t2));
            done = false;
            list = new ArrayList<double[]>((int)(t2 - t1) + 2);
            while (!done) {
                date = this.dateFormat.format(Util.j2KToDate(ct));
                if (date.equals(endDate)) {
                    done = true;
                }
                ct += 86400.0;
                table = String.valueOf(code) + "$$H" + date;
                rs = null;
                try {
                    sql = "SELECT MIN(j2ksec), AVG(rsam) FROM " + table + " WHERE j2ksec>=" + t1 + " AND j2ksec<=" + t2 + " AND rcnt>0 GROUP BY FLOOR(j2ksec/" + period + ") ORDER BY 1";
                    rs = this.winston.getStatement().executeQuery(sql);
                    if (true) ** GOTO lbl25
                }
                catch (Exception e) {
                    continue;
                }
                do {
                    d = new double[]{rs.getDouble(1), rs.getDouble(2)};
                    list.add(d);
lbl25:
                    // 2 sources

                } while (rs.next());
                rs.close();
            }
            return new RSAMData(list);
        }
        catch (Exception e) {
            this.winston.getLogger().log(Level.SEVERE, "Could not get RSAM for " + code + ", " + t1 + "->" + t2, Util.getLineNumber(this, e));
            return null;
        }
    }
}

