/*
 * Decompiled with CFR 0.152.
 */
package nz.org.geonet.data;

import gov.usgs.swarm.map.ClickableGeoLabel;
import gov.usgs.swarm.map.Hypocenter;
import gov.usgs.swarm.map.LabelSource;
import gov.usgs.util.Log;
import gov.usgs.util.ResourceReader;
import gov.usgs.util.Time;
import gov.usgs.util.xml.SimpleXMLParser;
import gov.usgs.util.xml.XMLDocHandler;
import gov.usgs.util.xml.XMLToMap;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class RSSHypocenters
implements LabelSource {
    public static final String RSS_URL = "http://www.geonet.org.nz/feeds/earthquake/geonet-recent-quakes-1.0.xml";
    public static final String QUAKE_URL = "http://www.geonet.org.nz/services/quake/";

    @Override
    public List<? extends ClickableGeoLabel> getLabels() {
        ResourceReader rr = ResourceReader.getResourceReader(RSS_URL);
        ArrayList<Hypocenter> hypos = new ArrayList<Hypocenter>();
        try {
            GetQuakeIDs q = new GetQuakeIDs();
            SimpleXMLParser.parse(q, rr.getReader());
            for (String id : q.ids) {
                Log.getLogger("nz.org.geonet").fine(id);
                XMLToMap qm = new XMLToMap();
                ResourceReader qr = ResourceReader.getResourceReader("http://www.geonet.org.nz/services/quake//" + id);
                SimpleXMLParser.parse(qm, qr.getReader());
                Hypocenter h = new Hypocenter();
                double lat = Double.parseDouble(qm.text.get("report/lat"));
                double lon = Double.parseDouble(qm.text.get("report/lon"));
                h.location = new Point2D.Double(lon, lat);
                h.text = "M" + qm.text.get("report/mag");
                h.depth = Double.parseDouble(qm.text.get("report/depth"));
                String year = qm.text.get("report/uttime/year");
                String mo = qm.text.get("report/uttime/month");
                String day = qm.text.get("report/uttime/day");
                String hour = qm.text.get("report/uttime/hour");
                String minute = qm.text.get("report/uttime/minute");
                String second = qm.text.get("report/uttime/second");
                String ms = qm.text.get("report/uttime/msec");
                String ds = String.format("%s-%s-%s %s:%s:%s.%s", year, mo, day, hour, minute, second, ms);
                h.time = Time.parse("yyyy-MM-dd HH:mm:ss.SSS", ds);
                hypos.add(h);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return hypos;
    }

    public static void main(String[] args) {
        new RSSHypocenters().getLabels();
    }

    private static class GetQuakeIDs
    implements XMLDocHandler {
        public List<String> ids = new ArrayList<String>();
        private boolean idTag;

        private GetQuakeIDs() {
        }

        @Override
        public void endDocument() throws Exception {
        }

        @Override
        public void endElement(String tag) throws Exception {
        }

        @Override
        public void startDocument() throws Exception {
        }

        @Override
        public void startElement(String tag, Map<String, String> h) throws Exception {
            if ("quake:id".equals(tag)) {
                this.idTag = true;
            }
        }

        @Override
        public void text(String str) throws Exception {
            if (this.idTag) {
                this.ids.add(str);
                this.idTag = false;
            }
        }
    }
}

