/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.earthworm;

import gov.usgs.earthworm.Message;
import gov.usgs.earthworm.MessageFactory;
import gov.usgs.earthworm.MessageListener;
import gov.usgs.earthworm.MessageLogo;
import gov.usgs.util.Retriable;
import gov.usgs.util.Util;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class ImportGeneric
extends Thread {
    protected byte[] msgBuf = new byte[65000];
    private static final byte ESC = 27;
    private static final byte STX = 2;
    private static final byte ETX = 3;
    protected String host;
    protected int port;
    protected int maxRetries = 3;
    protected int timeout = 10000;
    protected int heartbeatInterval = 30000;
    protected int expectedHeartbeatInterval = 30000;
    protected String recvIDString;
    protected String sendIDString;
    protected Socket socket;
    protected DataOutputStream socketOut;
    protected PrintWriter socketWriter;
    protected DataInputStream socketIn;
    protected HeartbeatThread heartbeat;
    protected ExpectedHeartbeatThread expectedHeartbeat;
    protected Map<Integer, List<MessageListener>> listeners;
    protected boolean connected;
    protected boolean needReconnect;
    protected volatile boolean shutdown = false;
    protected Logger logger = Logger.getLogger("gov.usgs.earthworm");
    protected long lastHeartbeat;
    protected long lastHeartbeatSent;
    protected long lastConnectUpdate = -1L;

    public ImportGeneric() {
        super("ImportGeneric");
        this.listeners = new HashMap<Integer, List<MessageListener>>();
    }

    public ImportGeneric(String h, int p) {
        this();
        this.host = h;
        this.port = p;
    }

    public void outOfMemoryErrorOccurred(OutOfMemoryError e) {
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public void setLogger(Logger l) {
        this.logger = l;
    }

    public void setHostAndPort(String h, int p) {
        this.host = h;
        this.port = p;
    }

    public void setRecvIDString(String s) {
        this.recvIDString = s;
    }

    public void setSendIDString(String s) {
        this.sendIDString = s;
    }

    public void setHeartbeatInterval(int ms) {
        this.heartbeatInterval = ms;
    }

    public void setExpectedHeartbeatInterval(int ms) {
        this.expectedHeartbeatInterval = ms;
    }

    public void setTimeout(int ms) {
        this.timeout = ms;
    }

    public boolean connect() {
        Retriable<Boolean> result = new Retriable<Boolean>("Import.connect()", this.maxRetries){

            @Override
            public void giveUp() {
                if (System.currentTimeMillis() - ImportGeneric.this.lastConnectUpdate > 600000L) {
                    ImportGeneric.this.logger.severe("ImportGeneric: can not connect, will update periodically while attempting to reconnect.");
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ImportGeneric.this.lastConnectUpdate = System.currentTimeMillis();
                }
            }

            @Override
            public boolean attempt() {
                this.output = false;
                try {
                    ImportGeneric.this.socket = new Socket();
                    ImportGeneric.this.socket.connect(new InetSocketAddress(ImportGeneric.this.host, ImportGeneric.this.port), ImportGeneric.this.timeout);
                    ImportGeneric.this.socket.setSoLinger(false, 0);
                    ImportGeneric.this.socket.setSoTimeout(ImportGeneric.this.timeout);
                    ImportGeneric.this.socketOut = new DataOutputStream(ImportGeneric.this.socket.getOutputStream());
                    ImportGeneric.this.socketWriter = new PrintWriter(ImportGeneric.this.socket.getOutputStream());
                    ImportGeneric.this.socketIn = new DataInputStream(new BufferedInputStream(ImportGeneric.this.socket.getInputStream()));
                    ImportGeneric.this.logger.fine("ImportGeneric connected.");
                    this.result = new Boolean(true);
                    ImportGeneric.this.heartbeat = new HeartbeatThread();
                    ImportGeneric.this.heartbeat.start();
                    ImportGeneric.this.expectedHeartbeat = new ExpectedHeartbeatThread();
                    ImportGeneric.this.addListener(3, ImportGeneric.this.expectedHeartbeat);
                    ImportGeneric.this.connected = true;
                    ImportGeneric.this.needReconnect = false;
                    if (!ImportGeneric.this.isAlive()) {
                        ImportGeneric.this.start();
                    }
                    return true;
                }
                catch (SocketTimeoutException e) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return false;
            }
        };
        Boolean b = (Boolean)result.go();
        return b != null && b != false;
    }

    public void shutdown() {
        this.shutdown = true;
    }

    public void close() {
        try {
            if (this.socket.isClosed()) {
                return;
            }
            this.connected = false;
            this.heartbeat.kill();
            this.expectedHeartbeat.kill();
            this.removeListener(3, this.expectedHeartbeat);
            this.socketOut.close();
            this.socketWriter.close();
            this.socketIn.close();
            this.socket.close();
        }
        catch (IOException e) {
            this.logger.severe("ImportGeneric.close() IOException: " + e.getMessage());
        }
    }

    public void removeListener(int type, MessageListener ml) {
        List<MessageListener> list = this.listeners.get(type);
        if (list == null) {
            return;
        }
        list.remove(ml);
    }

    public void addListener(int type, MessageListener ml) {
        List<MessageListener> list = this.listeners.get(type);
        if (list == null) {
            list = new ArrayList<MessageListener>();
            this.listeners.put(type, list);
        }
        list.add(ml);
    }

    public void dispatchMessage(Message msg) {
        List<MessageListener> list = this.listeners.get(msg.logo.getType());
        if (list != null) {
            for (MessageListener ml : list) {
                ml.messageReceived(msg);
            }
        }
    }

    public void run() {
        int lastByte = 27;
        while (!this.shutdown) {
            try {
                if (this.needReconnect) {
                    this.close();
                    this.connect();
                    continue;
                }
                if (!this.connected) {
                    Thread.sleep(250L);
                    continue;
                }
                byte b = this.socketIn.readByte();
                boolean start = false;
                if (b == 2) {
                    if (lastByte != 27) {
                        start = true;
                    } else {
                        lastByte = b;
                    }
                }
                if (start) {
                    int i = 0;
                    int seq = Integer.MAX_VALUE;
                    boolean done = false;
                    boolean escape = false;
                    while (!done) {
                        byte b3 = this.socketIn.readByte();
                        if (!escape && b3 == 3) {
                            done = true;
                        } else if (!escape && b3 == 27) {
                            escape = true;
                        } else {
                            this.msgBuf[i++] = b3;
                            escape = false;
                        }
                        if (i != 6 || seq != Integer.MAX_VALUE || (seq = this.findSeq(new String(this.msgBuf, 0, 6))) == Integer.MIN_VALUE) continue;
                        i = 0;
                    }
                    this.msgBuf[i++] = 0;
                    Message msg = MessageFactory.createMessage(this.msgBuf, i, seq);
                    this.dispatchMessage(msg);
                }
                if (!this.shutdown) continue;
                this.close();
            }
            catch (Exception e) {
                this.logger.severe("Main loop exception: " + e.getMessage() + ", will attempt reconnect.");
                e.printStackTrace();
                this.needReconnect = true;
            }
            catch (OutOfMemoryError e) {
                this.outOfMemoryErrorOccurred(e);
            }
        }
    }

    public int findSeq(String s) {
        int seq = s.startsWith("SQ:") ? Integer.parseInt(s.substring(3, 6).trim()) : Integer.MIN_VALUE;
        return seq;
    }

    public void sendAck(int seq) {
        String ackString = "ACK:" + seq;
        MessageLogo logo = new MessageLogo();
        logo.installationID = Util.intToByte(255);
        logo.module = Util.intToByte(28);
        logo.type = Util.intToByte(6);
        try {
            this.sendMsg(logo, ackString);
        }
        catch (IOException e) {
            this.logger.warning("Exception sending ACK #" + seq);
        }
    }

    public void sendMsg(MessageLogo l, String s) throws IOException {
        byte[] b = new byte[50];
        b[0] = 2;
        byte[] lb = l.toDataStreamBytes();
        System.arraycopy(lb, 0, b, 1, 9);
        int j = 10;
        int i = 0;
        while (i < s.length()) {
            b[j] = Util.intToByte(s.charAt(i));
            ++i;
            ++j;
        }
        b[j++] = 0;
        b[j++] = 3;
        this.socketOut.write(b, 0, j);
        this.socketOut.flush();
    }

    public long getLastHeartbeatTime() {
        return this.lastHeartbeat;
    }

    public long getLastHeartbeatSentTime() {
        return this.lastHeartbeatSent;
    }

    public static void main(String[] args) {
        if (args.length == 2) {
            ImportGeneric imp = new ImportGeneric(args[0], Integer.parseInt(args[1]));
            imp.addListener(3, new MessageListener(){

                public void messageReceived(Message msg) {
                    System.out.println(msg);
                }
            });
            imp.connect();
        } else {
            System.err.println("This program is intended to be a stub for more interesting applications");
            System.err.println("that interpret Earthworm information.  Use this program alone to test");
            System.err.println("a connection to export_generic.");
            System.err.println();
            System.err.println("usage: java gov.usgs.earthworm.ImportGeneric [host] [port]");
            System.exit(1);
        }
    }

    class HeartbeatThread
    extends Thread {
        private MessageLogo logo;
        private boolean kill;

        public HeartbeatThread() {
            super("Heartbeat");
            this.kill = false;
            this.logo = new MessageLogo();
            this.logo.installationID = Util.intToByte(255);
            this.logo.module = Util.intToByte(28);
            this.logo.type = Util.intToByte(3);
        }

        public void kill() {
            this.kill = true;
            this.interrupt();
        }

        public void run() {
            while (!this.kill) {
                try {
                    Thread.sleep(ImportGeneric.this.heartbeatInterval);
                    ImportGeneric.this.logger.finer("Sending heartbeat.");
                    ImportGeneric.this.sendMsg(this.logo, ImportGeneric.this.sendIDString);
                    ImportGeneric.this.lastHeartbeatSent = System.currentTimeMillis();
                }
                catch (InterruptedException e) {
                }
                catch (IOException e) {
                    ImportGeneric.this.logger.warning("Exception in heartbeat sending thread, reconnecting.");
                    ImportGeneric.this.needReconnect = true;
                    this.kill = true;
                }
                catch (OutOfMemoryError e) {
                    ImportGeneric.this.outOfMemoryErrorOccurred(e);
                }
            }
            ImportGeneric.this.logger.fine("Heartbeat thread died.");
        }
    }

    class ExpectedHeartbeatThread
    extends Thread
    implements MessageListener {
        private boolean kill;

        public ExpectedHeartbeatThread() {
            super("ExpectedHeartbeat");
            this.kill = false;
            ImportGeneric.this.lastHeartbeat = System.currentTimeMillis();
            this.start();
        }

        public void messageReceived(Message msg) {
            ImportGeneric.this.logger.finer("Received heartbeat.");
            String recv = msg.bytesToString().trim();
            if (!recv.equals(ImportGeneric.this.recvIDString)) {
                ImportGeneric.this.logger.fine("Warning: heartbeat message, '" + recv + "', does not match expected message, '" + ImportGeneric.this.recvIDString + "'.");
            }
            ImportGeneric.this.lastHeartbeat = System.currentTimeMillis();
            if (msg.sendAck) {
                ImportGeneric.this.sendAck(msg.seq);
            }
        }

        public void kill() {
            this.kill = true;
            this.interrupt();
        }

        public void run() {
            while (!this.kill) {
                try {
                    Thread.sleep(ImportGeneric.this.expectedHeartbeatInterval);
                    if (System.currentTimeMillis() - ImportGeneric.this.lastHeartbeat < (long)(ImportGeneric.this.expectedHeartbeatInterval * 2)) continue;
                    ImportGeneric.this.logger.fine("Have not received heartbeat recently.  Reconnecting.");
                    ImportGeneric.this.needReconnect = true;
                    this.kill = true;
                }
                catch (InterruptedException e) {
                }
                catch (OutOfMemoryError e) {
                    ImportGeneric.this.outOfMemoryErrorOccurred(e);
                }
            }
            ImportGeneric.this.logger.fine("Expected heartbeat thread died.");
        }
    }
}

