/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.net;

import gov.usgs.net.ReadListener;
import gov.usgs.util.Log;
import gov.usgs.util.Retriable;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.logging.Logger;

public class InternetClient {
    protected String host;
    protected int port;
    protected Socket socket;
    protected PrintWriter socketOut;
    protected DataInputStream socketIn;
    protected int timeout = 15000;
    protected int maxRetries = 3;
    protected Logger logger = Log.getLogger("gov.usgs.net");

    public InternetClient() {
    }

    public InternetClient(String sp) {
        this();
        String[] hp = sp.split(":");
        this.host = hp[0];
        this.port = Integer.parseInt(hp[1]);
    }

    public InternetClient(String s, int p) {
        this();
        this.host = s;
        this.port = p;
    }

    public void setLogger(Logger l) {
        this.logger = l;
    }

    public void setMaxRetries(int mr) {
        this.maxRetries = mr;
    }

    public void setTimeout(int ms) {
        this.timeout = ms;
    }

    public void setHost(String s) {
        this.host = s;
    }

    public void setPort(int p) {
        this.port = p;
    }

    public boolean connected() {
        if (this.socket == null) {
            return false;
        }
        if (this.socket.isClosed()) {
            return false;
        }
        return this.socketOut != null && this.socketIn != null;
    }

    public void writeString(String msg) {
        this.socketOut.print(msg);
        this.socketOut.flush();
    }

    public String readString() throws IOException {
        byte b;
        byte[] bb = new byte[256];
        int i = 0;
        while ((b = this.socketIn.readByte()) != 10) {
            if (i == bb.length) {
                byte[] obb = bb;
                bb = new byte[obb.length * 2];
                System.arraycopy(obb, 0, bb, 0, obb.length);
            }
            bb[i++] = b;
        }
        return new String(bb, 0, i);
    }

    public byte[] readBinary(int bytes) throws IOException {
        return this.readBinary(bytes, null);
    }

    public byte[] readBinary(int bytes, ReadListener listener) throws IOException {
        byte[] buf = new byte[bytes];
        for (int read = 0; read < bytes; read += this.socketIn.read(buf, read, bytes - read)) {
            if (listener == null) continue;
            listener.readProgress((double)read / (double)bytes);
        }
        return buf;
    }

    public boolean connect() {
        Retriable<Boolean> result = new Retriable<Boolean>(this + "/connect()", this.maxRetries){

            @Override
            public boolean attempt() {
                try {
                    InternetClient.this.socket = new Socket();
                    InternetClient.this.socket.connect(new InetSocketAddress(InternetClient.this.host, InternetClient.this.port), InternetClient.this.timeout);
                    InternetClient.this.socket.setSoLinger(false, 0);
                    InternetClient.this.socket.setSoTimeout(InternetClient.this.timeout);
                    InternetClient.this.socketOut = new PrintWriter(InternetClient.this.socket.getOutputStream());
                    BufferedInputStream bis = new BufferedInputStream(InternetClient.this.socket.getInputStream());
                    InternetClient.this.socketIn = new DataInputStream(bis);
                    this.result = new Boolean(true);
                    InternetClient.this.logger.finer(InternetClient.this + "/connection opened.");
                    return true;
                }
                catch (SocketTimeoutException e) {
                    InternetClient.this.logger.warning(InternetClient.this + "/connect() timeout: " + e.getMessage());
                }
                catch (IOException e) {
                    InternetClient.this.logger.warning(InternetClient.this + "/connect() IOException: " + e.getMessage());
                }
                return false;
            }
        };
        Boolean b = (Boolean)result.go();
        return b != null && b != false;
    }

    public void close() {
        if (!this.connected()) {
            return;
        }
        try {
            this.socketOut.close();
            this.socketIn.close();
            this.socket.close();
            this.logger.finer(this + "/connection closed.");
        }
        catch (IOException e) {
            this.logger.warning(this + "/close() IOException: " + e.getMessage());
        }
    }

    public String toString() {
        return this.host + ":" + this.port;
    }
}

