/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.plot;

import gov.usgs.util.Util;
import java.util.LinkedHashSet;

public class Data {
    public static double NO_DATA = Double.NaN;
    public static double LN10 = Math.log(10.0);
    public static double LOG10 = Math.log(10.0);
    private double[][] data;
    private boolean sorted;
    private boolean[] visible;

    public Data(double[][] d) {
        this.data = d;
        if (d == null) {
            return;
        }
        this.visible = new boolean[d[0].length - 2];
        for (int i = 0; i < this.visible.length; ++i) {
            this.visible[i] = true;
        }
    }

    public Data subset(int[] columns) {
        double[][] d = new double[this.data.length][columns.length];
        for (int i = 0; i < this.data.length; ++i) {
            for (int j = 0; j < columns.length; ++j) {
                d[i][j] = this.data[i][columns[j]];
            }
        }
        return new Data(d);
    }

    public int size() {
        return this.data.length;
    }

    public void setVisible(boolean[] b) {
        this.visible = b;
    }

    public boolean isVisible(int column) {
        return this.visible[column];
    }

    public double[][] getData() {
        return this.data;
    }

    public int getNumRows() {
        return this.data.length;
    }

    public int getNumColumns() {
        if (this.data == null || this.data.length == 0) {
            return 0;
        }
        return this.data[0].length;
    }

    public double getMinTime() {
        if (this.data == null || this.data.length == 0) {
            return Double.NaN;
        }
        if (this.sorted) {
            return this.data[0][0];
        }
        double min = 1.0E300;
        for (int i = 0; i < this.data.length; ++i) {
            if (!(this.data[i][0] < min)) continue;
            min = this.data[i][0];
        }
        return min;
    }

    public double getMaxTime() {
        if (this.data == null || this.data.length == 0) {
            return Double.NaN;
        }
        if (this.sorted) {
            return this.data[0][this.data[0].length - 1];
        }
        double max = -1.0E300;
        for (int i = 0; i < this.data.length; ++i) {
            if (!(this.data[i][0] > max)) continue;
            max = this.data[i][0];
        }
        return max;
    }

    public double getMinData() {
        if (this.data == null || this.data.length == 0) {
            return Double.NaN;
        }
        double min = 1.0E300;
        for (int i = 0; i < this.data.length; ++i) {
            for (int j = 1; j < this.data[0].length; ++j) {
                if (!this.visible[j - 1] || this.data[i][j] == NO_DATA || !(this.data[i][j] < min)) continue;
                min = this.data[i][j];
            }
        }
        return min;
    }

    public double getMaxData() {
        if (this.data == null || this.data.length == 0) {
            return Double.NaN;
        }
        double max = -1.0E300;
        for (int i = 0; i < this.data.length; ++i) {
            for (int j = 1; j < this.data[0].length; ++j) {
                if (!this.visible[j - 1] || this.data[i][j] == NO_DATA || !(this.data[i][j] > max)) continue;
                max = this.data[i][j];
            }
        }
        return max;
    }

    public double[] getDistinctEntries(int column) {
        if (this.data == null || this.data.length == 0) {
            return null;
        }
        LinkedHashSet<Double> set = new LinkedHashSet<Double>();
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i][column] == NO_DATA) continue;
            Double value = this.data[i][1];
            set.add(value);
        }
        double[] values = new double[set.size()];
        int cursor = 0;
        for (Double d : set) {
            values[cursor++] = d;
        }
        return values;
    }

    public double getMean(int column) {
        double sum = 0.0;
        int nodatas = 0;
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i][column] == NO_DATA) {
                ++nodatas;
                continue;
            }
            sum += this.data[i][column];
        }
        return sum / (double)(this.data.length - nodatas);
    }

    public void subtractMean(int column) {
        double mean = this.getMean(column);
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i][column] == NO_DATA) continue;
            double[] dArray = this.data[i];
            int n = column;
            dArray[n] = dArray[n] - mean;
        }
    }

    public double getMin(int column) {
        double min = Double.MAX_VALUE;
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i][column] == NO_DATA || !(this.data[i][column] < min)) continue;
            min = this.data[i][column];
        }
        return min;
    }

    public double getMax(int column) {
        double max = -1.7976931348623157E308;
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i][column] == NO_DATA || !(this.data[i][column] > max)) continue;
            max = this.data[i][column];
        }
        return max;
    }

    public void add(int column, double val) {
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i][column] == NO_DATA) continue;
            double[] dArray = this.data[i];
            int n = column;
            dArray[n] = dArray[n] + val;
        }
    }

    public void unbias(int column) {
        double ym = this.getMean(column);
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i][column] == NO_DATA) continue;
            double[] dArray = this.data[i];
            int n = column;
            dArray[n] = dArray[n] - ym;
        }
    }

    public void detrend(int column) {
        double ym = this.getMean(column);
        double xm = this.getMean(0);
        double ssxy = 0.0;
        double ssxx = 0.0;
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i][column] == NO_DATA) continue;
            ssxy += (this.data[i][0] - xm) * (this.data[i][column] - ym);
            ssxx += (this.data[i][0] - xm) * (this.data[i][0] - xm);
        }
        double m = ssxy / ssxx;
        double b = ym - m * xm;
        for (int i = 0; i < this.data.length; ++i) {
            double[] dArray = this.data[i];
            int n = column;
            dArray[n] = dArray[n] - (this.data[i][0] * m + b);
        }
    }

    public double[] leastSquares(int column) {
        double ym = this.getMean(column);
        double xm = this.getMean(0);
        double ssxy = 0.0;
        double ssxx = 0.0;
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i][column] == NO_DATA) continue;
            ssxy += (this.data[i][0] - xm) * (this.data[i][column] - ym);
            ssxx += (this.data[i][0] - xm) * (this.data[i][0] - xm);
        }
        double m = ssxy / ssxx;
        double b = ym - m * xm;
        return new double[]{m, b};
    }

    public void log10(int column) {
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i][column] == NO_DATA) continue;
            this.data[i][column] = Math.log(this.data[i][column]) / LN10;
        }
    }

    public void stack(double interval) {
        int nv = 0;
        for (int i = 0; i < this.visible.length; ++i) {
            if (!this.visible[i]) continue;
            ++nv;
        }
        if (nv <= 1) {
            return;
        }
        double add = (double)(nv / 2) * interval;
        for (int i = 1; i < this.data[0].length; ++i) {
            if (!this.visible[i - 1]) continue;
            this.add(i, add);
            add -= interval;
        }
    }

    public boolean isSorted() {
        return this.sorted;
    }

    public void setSorted(boolean b) {
        this.sorted = b;
    }

    public void output() {
        for (int i = 0; i < this.data.length; ++i) {
            for (int j = 0; j < this.data[i].length; ++j) {
                System.out.print(this.data[i][j] + "\t");
            }
            System.out.println();
        }
    }

    public String toCSV() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.data.length; ++i) {
            sb.append(Util.j2KToDateString(this.data[i][0]) + ",");
            for (int j = 1; j < this.data[0].length; ++j) {
                sb.append(this.data[i][j] + ",");
            }
            if (sb.charAt(sb.length() - 1) != ',') continue;
            sb.setCharAt(sb.length() - 1, '\n');
        }
        return sb.toString();
    }
}

