/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.plot;

import gov.usgs.math.Geometry;
import gov.usgs.plot.IdentityTransformer;
import gov.usgs.plot.PointRenderer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;

public class DataPointRenderer
extends PointRenderer {
    public Shape shape;
    public Color color;
    public Color fillColor;
    public Stroke stroke = new BasicStroke(1.0f);
    public Paint paint;
    public boolean antiAlias;
    public boolean filled;

    public DataPointRenderer() {
        this('o', 8.0f);
    }

    public DataPointRenderer(char type, float size) {
        this.setShapeFromType(type, size);
    }

    public void setShapeFromType(char type, float size) {
        switch (type) {
            case '0': 
            case 'O': 
            case 'o': {
                this.shape = new Ellipse2D.Double(-size / 2.0f, -size / 2.0f, size, size);
                break;
            }
            case 's': {
                this.shape = new Rectangle2D.Double(-size / 2.0f, -size / 2.0f, size, size);
                break;
            }
            case 't': {
                GeneralPath gp = new GeneralPath();
                gp.moveTo(0.0f, -size / 2.0f);
                gp.lineTo(size / 2.0f, size / 2.0f);
                gp.lineTo(-size / 2.0f, size / 2.0f);
                gp.lineTo(0.0f, -size / 2.0f);
                this.shape = gp;
                break;
            }
            case '*': {
                this.shape = Geometry.getStar(size, true);
            }
        }
    }

    public void render(Graphics2D g) {
        Stroke origStroke = g.getStroke();
        Paint origPaint = g.getPaint();
        Color origColor = g.getColor();
        Object origRenderingHint = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        if (this.antiAlias) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        if (this.stroke != null) {
            g.setStroke(this.stroke);
        }
        if (this.color != null) {
            g.setColor(this.color);
        }
        if (this.transformer == null) {
            this.transformer = new IdentityTransformer();
        }
        double xt = this.transformer.getXPixel(this.x);
        double yt = this.transformer.getYPixel(this.y);
        g.translate(xt, yt);
        if (this.filled) {
            if (this.fillColor != null) {
                g.setColor(this.fillColor);
            } else if (this.color != null) {
                g.setColor(this.color);
            }
            g.fill(this.shape);
        }
        if (this.stroke != null) {
            g.setStroke(this.stroke);
            if (this.color != null) {
                g.setColor(this.color);
            }
            g.draw(this.shape);
        }
        g.translate(-xt, -yt);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, origRenderingHint);
        g.setStroke(origStroke);
        g.setPaint(origPaint);
        g.setColor(origColor);
    }

    public void renderAtOrigin(Graphics2D g) {
        Stroke origStroke = g.getStroke();
        Paint origPaint = g.getPaint();
        Color origColor = g.getColor();
        Object origRenderingHint = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        if (this.antiAlias) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        if (this.stroke != null) {
            g.setStroke(this.stroke);
        }
        if (this.color != null) {
            g.setColor(this.color);
        }
        if (this.filled) {
            if (this.paint != null) {
                g.setPaint(this.paint);
            }
            g.fill(this.shape);
        }
        if (this.stroke != null) {
            if (this.color != null) {
                g.setColor(this.color);
            }
            g.draw(this.shape);
        }
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, origRenderingHint);
        g.setStroke(origStroke);
        g.setPaint(origPaint);
        g.setColor(origColor);
    }
}

