/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.plot;

import gov.usgs.math.Util;
import gov.usgs.plot.AxisRenderer;
import gov.usgs.plot.FrameDecorator;
import gov.usgs.plot.FrameRenderer;
import gov.usgs.plot.RectangleRenderer;
import gov.usgs.plot.SmartTick;
import gov.usgs.plot.TextRenderer;
import java.awt.Color;
import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.text.NumberFormat;

public class DefaultFrameDecorator
extends FrameDecorator {
    public TitleLocation titleLocation = TitleLocation.INSET;
    public Color titleBackground;
    public Font titleFont;
    public String title;
    public XAxis xAxis = XAxis.TIME;
    public YAxis yAxis = YAxis.LINEAR;
    public boolean hasAxis = true;
    public boolean hasFrame = true;
    public boolean xAxisLabels = true;
    public boolean yAxisLabels = true;
    public double xAxisTopTickLength = 8.0;
    public double xAxisBottomTickLength = 8.0;
    public double yAxisLeftTickLength = 8.0;
    public double yAxisRightTickLength = 8.0;
    public Grid xAxisGrid = Grid.DASH;
    public Grid yAxisGrid = Grid.DASH;
    public int hTicks = -1;
    public int vTicks = -1;
    public String xAxisLabel = null;
    public String yAxisLabel = null;
    private static NumberFormat numberFormat = NumberFormat.getInstance();

    public static String[] createLabels(double[] t, boolean log, double m, double b) {
        String[] labels = new String[t.length];
        for (int i = 0; i < t.length; ++i) {
            double v = log ? Math.pow(10.0, t[i]) : t[i];
            double exp = Util.getExp(v);
            labels[i] = exp >= 5.0 ? numberFormat.format(v / Math.pow(10.0, exp)) + "e" + numberFormat.format(exp) : numberFormat.format(v);
        }
        return labels;
    }

    private void createTitle(FrameRenderer fr) {
        if (this.title == null || this.title.length() == 0) {
            return;
        }
        switch (this.titleLocation) {
            case TOP: 
            case INSET: {
                AxisRenderer ar = fr.getAxis();
                if (this.titleFont == null) {
                    this.titleFont = Font.decode("dialog-plain-12");
                }
                TextRenderer label = new TextRenderer(fr.getGraphX() + 5, fr.getGraphY() + 16, this.title, Color.BLACK);
                label.font = this.titleFont;
                if (this.titleBackground != null) {
                    FontRenderContext frc = new FontRenderContext(new AffineTransform(), false, false);
                    RectangleRenderer rr = ar.getFrame();
                    rr.color = Color.GRAY;
                    rr = new RectangleRenderer();
                    rr.rect = new Rectangle2D.Double();
                    rr.rect.setFrame(this.titleFont.getStringBounds(this.title, frc));
                    rr.rect.x = fr.getGraphX() + 3;
                    rr.rect.y = fr.getGraphY() + 3;
                    rr.rect.width += 6.0;
                    rr.rect.height += 2.0;
                    rr.color = Color.GRAY;
                    rr.backgroundColor = this.titleBackground;
                    ar.addPostRenderer(rr);
                }
                ar.addPostRenderer(label);
            }
        }
    }

    private void createXAxis(FrameRenderer fr) {
        AxisRenderer axis = fr.getAxis();
        boolean doAxis = true;
        Object[] stt = null;
        boolean log = false;
        switch (this.xAxis) {
            case NONE: {
                doAxis = false;
                break;
            }
            case LOG: {
                log = true;
            }
            case LINEAR: {
                if (this.hTicks == -1) {
                    this.hTicks = fr.getGraphWidth() / 108;
                }
                double[] t = SmartTick.autoTick(fr.getMinXAxis(), fr.getMaxXAxis(), this.hTicks, false);
                String[] st = new String[t.length];
                for (int i = 0; i < t.length; ++i) {
                    double val = log ? Math.pow(10.0, t[i]) : t[i];
                    st[i] = numberFormat.format(val);
                }
                stt = new Object[]{t, st};
                break;
            }
            case TIME: {
                if (this.hTicks == -1) {
                    this.hTicks = fr.getGraphWidth() / 108;
                }
                stt = SmartTick.autoTimeTick(fr.getMinXAxis(), fr.getMaxXAxis(), this.hTicks);
            }
        }
        if (doAxis && stt != null) {
            if (this.xAxisBottomTickLength > 0.0) {
                axis.createBottomTicks((double[])stt[0], this.xAxisBottomTickLength, Color.BLACK);
            }
            if (this.xAxisTopTickLength > 0.0) {
                axis.createTopTicks((double[])stt[0], this.xAxisTopTickLength, Color.BLACK);
            }
            if (this.xAxisGrid != Grid.NONE) {
                axis.createVerticalGridLines((double[])stt[0]);
            }
            if (this.xAxisLabels) {
                axis.createBottomTickLabels((double[])stt[0], (String[])stt[1]);
            }
        }
    }

    private void createYAxis(FrameRenderer fr) {
        AxisRenderer axis = fr.getAxis();
        boolean doAxis = true;
        double[] yt = null;
        double[] ytm = null;
        boolean log = false;
        switch (this.yAxis) {
            case NONE: {
                break;
            }
            case LOG: {
                log = true;
            }
            case LINEAR: {
                if (this.vTicks == -1) {
                    this.vTicks = fr.getGraphHeight() / 24;
                }
                yt = SmartTick.autoTick(fr.getMinYAxis(), fr.getMaxYAxis(), this.vTicks, false);
                ytm = new double[yt.length];
                for (int i = 0; i < yt.length; ++i) {
                    ytm[i] = (yt[i] - fr.getYAxisOffset()) / fr.getYAxisMult();
                }
                break;
            }
        }
        if (doAxis && yt != null) {
            if (this.yAxisLeftTickLength > 0.0) {
                axis.createLeftTicks(ytm, this.yAxisLeftTickLength, Color.BLACK);
            }
            if (this.yAxisRightTickLength > 0.0) {
                axis.createRightTicks(ytm, this.yAxisRightTickLength, Color.BLACK);
            }
            if (this.yAxisGrid != Grid.NONE) {
                axis.createHorizontalGridLines(ytm);
            }
            if (this.yAxisLabels) {
                axis.createLeftTickLabels(ytm, DefaultFrameDecorator.createLabels(yt, log, fr.getYAxisMult(), fr.getYAxisOffset()));
            }
            if (this.yAxisLabel != null) {
                this.addLabel(fr, this.yAxisLabel, Location.LEFT);
            }
        }
    }

    public TextRenderer addLabel(FrameRenderer fr, String text, Location loc) {
        return this.addLabel(fr, text, loc, null, null);
    }

    public TextRenderer addLabel(FrameRenderer fr, String text, Location loc, Font font, Color bgColor) {
        TextRenderer tr = new TextRenderer();
        tr.text = text;
        switch (loc) {
            case LEFT: {
                tr.x = 6.0;
                tr.y = fr.getGraphY() + fr.getGraphHeight() / 2;
                tr.horizJustification = 1;
                tr.orientation = -90.0f;
                fr.getAxis().addRenderer(tr);
            }
        }
        return tr;
    }

    public void decorate(FrameRenderer fr) {
        if (this.hasAxis) {
            AxisRenderer ar = new AxisRenderer(fr);
            ar.createDefault();
            if (!this.hasFrame) {
                ar.setFrame(null);
            }
            fr.setAxis(ar);
            this.createXAxis(fr);
            this.createYAxis(fr);
            this.createTitle(fr);
        }
    }

    static {
        numberFormat.setMaximumFractionDigits(3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Location {
        TOP,
        BOTTOM,
        LEFT,
        RIGHT,
        BOTTOM_LEFT,
        BOTTOM_RIGHT,
        TOP_LEFT,
        TOP_RIGHT,
        GRAPH_TOP,
        GRAPH_BOTTOM,
        GRAPH_LEFT,
        GRAPH_RIGHT,
        GRAPH_BOTTOM_LEFT,
        GRAPH_BOTTOM_RIGHT,
        GRAPH_TOP_LEFT,
        GRAPH_TOP_RIGHT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Grid {
        NONE,
        DASH,
        SOLID;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum YAxis {
        NONE,
        LINEAR,
        LOG;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum XAxis {
        NONE,
        TIME,
        LINEAR,
        LOG;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TitleLocation {
        TOP,
        INSET;

    }
}

