/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.plot;

import gov.usgs.plot.FrameRenderer;
import gov.usgs.plot.LineData;
import gov.usgs.plot.Renderer;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;

public class LineDataRenderer
extends FrameRenderer {
    private LineData lineData;
    private List<Renderer> renderers;
    private boolean antiAlias;
    private Paint paint;
    public Color color;
    public Stroke stroke;

    public LineDataRenderer(LineData d) {
        this.lineData = d;
        this.renderers = new ArrayList<Renderer>();
        this.color = Color.black;
    }

    public void addRenderer(Renderer r) {
        this.renderers.add(r);
    }

    public void setAntiAlias(boolean b) {
        this.antiAlias = b;
    }

    public void setPaint(Paint p) {
        this.paint = p;
    }

    public void render(Graphics2D g) {
        AffineTransform origAT = g.getTransform();
        Color origColor = g.getColor();
        Stroke origStroke = g.getStroke();
        Shape origClip = g.getClip();
        Paint origPaint = g.getPaint();
        if (this.axis != null) {
            this.axis.render(g);
        }
        if (this.antiAlias) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        g.setClip(new Rectangle(this.graphX, this.graphY, this.graphWidth + 2, this.graphHeight + 2));
        if (this.color != null) {
            g.setColor(this.color);
        }
        if (this.stroke != null) {
            g.setStroke(this.stroke);
        }
        if (this.lineData != null) {
            if (this.paint != null) {
                GeneralPath gp = this.lineData.getPolygon(this);
                g.setPaint(this.paint);
                g.fill(gp);
            } else {
                List<Point2D.Double> points = this.lineData.getPoints();
                Line2D.Double line = new Line2D.Double();
                for (int i = 0; i < points.size() - 1; ++i) {
                    Point2D.Double pt1 = points.get(i);
                    if (Double.isNaN(pt1.x) || Double.isNaN(pt1.y)) continue;
                    Point2D.Double pt2 = points.get(i + 1);
                    if (Double.isNaN(pt2.x) || Double.isNaN(pt2.y)) continue;
                    line.setLine((float)this.getXPixel(pt1.x), (float)this.getYPixel(pt1.y), (float)this.getXPixel(pt2.x), (float)this.getYPixel(pt2.y));
                    g.draw(line);
                }
            }
        }
        for (Renderer renderer : this.renderers) {
            renderer.render(g);
        }
        if (this.antiAlias) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        g.setClip(origClip);
        g.setPaint(origPaint);
        g.setStroke(origStroke);
        g.setColor(origColor);
        g.setTransform(origAT);
    }
}

