/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.plot;

import gov.usgs.plot.Renderer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;

public class ShapeRenderer
implements Renderer {
    public Color color;
    public Shape shape;
    public Stroke stroke = new BasicStroke(1.0f);
    public boolean antiAlias;

    public ShapeRenderer(Shape s) {
        this.shape = s;
    }

    public void render(Graphics2D g) {
        Stroke origStroke = g.getStroke();
        Color origColor = g.getColor();
        Object origRenderingHint = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        if (this.antiAlias) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        if (this.stroke != null) {
            g.setStroke(this.stroke);
        }
        if (this.color != null) {
            g.setColor(this.color);
        }
        if (this.shape != null) {
            g.draw(this.shape);
        }
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, origRenderingHint);
        g.setColor(origColor);
        g.setStroke(origStroke);
    }
}

