/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.plot.map;

import gov.usgs.plot.DataPointRenderer;
import gov.usgs.plot.PointRenderer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.awt.geom.Point2D;

public class GeoLabel {
    public String text;
    public Point2D.Double location;
    public PointRenderer tick;
    public Stroke stroke = new BasicStroke(1.0f);

    public GeoLabel() {
    }

    public GeoLabel(String s) {
        String[] ss = s.split("\t");
        this.text = ss[0];
        this.location = new Point2D.Double(Double.parseDouble(ss[1]), Double.parseDouble(ss[2]));
        this.tick = new DataPointRenderer('t', 6.0f);
        ((DataPointRenderer)this.tick).antiAlias = true;
        ((DataPointRenderer)this.tick).stroke = this.stroke;
    }

    public GeoLabel(String s, double lon, double lat) {
        this.text = s;
        this.location = new Point2D.Double(lon, lat);
        this.tick = new DataPointRenderer('s', 3.0f);
        ((DataPointRenderer)this.tick).antiAlias = true;
    }

    public static GeoLabel fromString(String s) {
        try {
            GeoLabel gl = new GeoLabel();
            String[] ss = s.split(";");
            String label = ss[0];
            String option = ss[1];
            String[] options = option.split(",");
            gl.text = label;
            gl.location = new Point2D.Double(Double.parseDouble(options[0].trim()), Double.parseDouble(options[1].trim()));
            char pt = 's';
            if (options.length > 2) {
                pt = options[2].trim().charAt(0);
            }
            DataPointRenderer dr = new DataPointRenderer(pt, 6.0f);
            dr.stroke = new BasicStroke(1.0f);
            dr.color = Color.BLACK;
            dr.antiAlias = true;
            gl.tick = dr;
            return gl;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

