/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.plot.map;

import gov.usgs.plot.BasicFrameRenderer;
import gov.usgs.plot.LineData;
import gov.usgs.plot.LineDataRenderer;
import gov.usgs.plot.LineRenderer;
import gov.usgs.plot.Plot;
import gov.usgs.plot.RenderedImageDataRenderer;
import gov.usgs.plot.Renderer;
import gov.usgs.plot.ShadowedTextRenderer;
import gov.usgs.plot.SmartTick;
import gov.usgs.plot.TextRenderer;
import gov.usgs.plot.map.GeoImageSet;
import gov.usgs.plot.map.GeoLabel;
import gov.usgs.plot.map.GeoLabelSet;
import gov.usgs.proj.GeoRange;
import gov.usgs.proj.Projection;
import gov.usgs.proj.TransverseMercator;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.image.RenderedImage;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapRenderer
extends BasicFrameRenderer {
    protected Projection projection;
    protected GeoRange range;
    protected RenderedImage mapImage;
    protected LineData graticule;
    protected LineData box;
    protected List<Renderer> labels;
    protected List<LineData> lineDatas;
    protected GeoLabelSet geoLabelSet;
    private static final double[] scales = new double[]{100000.0, 50000.0, 20000.0, 10000.0, 5000.0, 2000.0, 1000.0, 500.0, 200.0, 100.0, 50.0, 20.0, 10.0, 5.0, 2.0, 1.0, 0.5, 0.2, 0.1, 0.05, 0.02};
    protected Renderer scaleRenderer;
    protected NumberFormat numberFormat = DecimalFormat.getInstance();

    public MapRenderer(GeoRange r, Projection p) {
        this.numberFormat.setMaximumFractionDigits(3);
        this.range = r;
        this.projection = p;
        double[] extents = this.range.getProjectedExtents(this.projection);
        this.setExtents(extents[0], extents[1], extents[2], extents[3]);
    }

    public void setLocationByMaxBounds(int x, int y, int w, int h) {
        double[] extents = this.range.getProjectedExtents(this.projection);
        double aspect = (extents[3] - extents[2]) / (extents[1] - extents[0]);
        int height = (int)((double)w * aspect);
        if (height <= h) {
            this.setLocation(x, y, w, height);
            return;
        }
        int width = (int)((double)h * 1.0 / aspect);
        if (width <= w) {
            int ofs = w - width;
            this.setLocation(x + ofs / 2, y, width, h);
            return;
        }
        this.setLocation(x, y, w, h);
    }

    public void setLocation(int x, int y, int w) {
        double[] extents = this.range.getProjectedExtents(this.projection);
        double aspect = (extents[3] - extents[2]) / (extents[1] - extents[0]);
        int height = (int)((double)w * aspect);
        this.setLocation(x, y, w, height);
    }

    public void setGeoLabelSet(GeoLabelSet ls) {
        this.geoLabelSet = ls;
    }

    public void setMapImage(RenderedImage ri) {
        this.mapImage = ri;
    }

    public void setGraticule(LineData ld) {
        this.graticule = ld;
    }

    public double getScale() {
        return (this.maxX - this.minX) / (double)this.graphWidth;
    }

    public void createGraticule(int pts, boolean createLabels) {
        this.createGraticule(pts, createLabels, Color.BLACK);
    }

    public void createGraticule(int pts, boolean createLabels, Color labelColor) {
        double[] gridX = SmartTick.autoTick(this.range.getWest(), this.range.getWest() + this.range.getLonRange(), pts, true, true);
        double[] gridY = SmartTick.autoTick(this.range.getSouth(), this.range.getNorth(), pts, true, true);
        this.graticule = new LineData(gridX, gridY, false);
        this.graticule.applyProjection(this.projection);
        if (createLabels) {
            int i;
            this.labels = new ArrayList<Renderer>();
            for (i = 1; i < gridX.length - 1; ++i) {
                double nx = GeoRange.normalize(gridX[i]);
                Point2D.Double pt = new Point2D.Double(nx, gridY[0]);
                pt = this.projection.forward(pt);
                TextRenderer tr = new TextRenderer(pt.x, pt.y, this.numberFormat.format(nx));
                tr.transformer = this;
                tr.horizJustification = 1;
                tr.vertJustification = 4;
                tr.color = labelColor;
                this.labels.add(tr);
            }
            for (i = 1; i < gridY.length - 1; ++i) {
                Point2D.Double pt = new Point2D.Double(gridX[0], gridY[i]);
                pt = this.projection.forward(pt);
                TextRenderer tr = new TextRenderer(pt.x, pt.y, this.numberFormat.format(gridY[i]));
                tr.transformer = this;
                tr.xBump = -2;
                tr.horizJustification = 3;
                tr.vertJustification = 1;
                tr.color = labelColor;
                this.labels.add(tr);
            }
        }
    }

    public void createBox(int pts) {
        this.box = new LineData(this.range.getWest(), this.range.getSouth(), this.range.getLonRange(), this.range.getLatRange(), pts);
        this.box.applyProjection(this.projection);
    }

    private boolean boxOverlaps(List<Rectangle> boxes, Rectangle bb) {
        for (Rectangle rect : boxes) {
            if (!rect.intersects(bb)) continue;
            return false;
        }
        return true;
    }

    private Point allowLabel(List<Rectangle> boxes, Rectangle bb) {
        if (this.boxOverlaps(boxes, bb)) {
            return new Point(0, 0);
        }
        bb.translate(-bb.width - 7, 0);
        if (this.boxOverlaps(boxes, bb)) {
            return new Point(-bb.width - 7, 0);
        }
        bb.translate(0, bb.height / 2);
        if (this.boxOverlaps(boxes, bb)) {
            return new Point(-bb.width - 7, bb.height / 2 + 3);
        }
        bb.translate(bb.width + 7, 0);
        if (this.boxOverlaps(boxes, bb)) {
            return new Point(0, bb.height / 2 + 3);
        }
        return null;
    }

    public void renderGeoLabels(Graphics2D g) {
        ArrayList<Rectangle> boxes = new ArrayList<Rectangle>();
        if (this.geoLabelSet != null) {
            List<GeoLabel> gls = this.geoLabelSet.getGeoLabels();
            for (GeoLabel gl : gls) {
                if (!this.range.contains(gl.location)) continue;
                Point2D.Double pt = this.projection.forward(gl.location);
                ShadowedTextRenderer tr = new ShadowedTextRenderer(pt.x, pt.y, gl.text);
                tr.transformer = this;
                tr.xBump = 4;
                tr.yBump = -1;
                Rectangle bb = tr.getBoundingBox(g);
                Point offset = this.allowLabel(boxes, bb);
                if (offset != null) {
                    tr.xBump += offset.x;
                    tr.yBump += offset.y;
                    boxes.add(bb);
                    tr.render(g);
                }
                if (gl.tick == null) continue;
                gl.tick.transformer = this;
                gl.tick.x = pt.x;
                gl.tick.y = pt.y;
                gl.tick.render(g);
            }
        }
    }

    public void createScaleRenderer() {
        this.createScaleRenderer(1.0, this.graphX, this.graphY + this.graphHeight + 32, Color.BLACK);
    }

    public void createScaleRenderer(double f, int x, int y) {
        this.createScaleRenderer(f, x, y, null);
    }

    public void createScaleRenderer(final double f, final int x, final int y, final Color color) {
        this.scaleRenderer = new Renderer(){

            public void render(Graphics2D g) {
                Font origFont = g.getFont();
                if (color != null) {
                    g.setColor(color);
                }
                g.setFont(new Font("Arial", 0, 10));
                g.setStroke(new BasicStroke(2.0f));
                double scale = MapRenderer.this.getScale() / 1000.0 * f;
                Line2D.Double line = new Line2D.Double();
                double len = 0.0;
                int index = -1;
                double cur = 1.0E300;
                for (int i = 0; i < scales.length; ++i) {
                    double s = 1.0 / scale * scales[i];
                    double d = Math.abs(s - 150.0);
                    if (!(d < cur)) continue;
                    len = s;
                    index = i;
                    cur = d;
                }
                line.setLine(x, y, (double)x + len, y);
                g.draw(line);
                g.drawString(scales[index] + " km", (float)x, (float)(y - 2));
                g.setFont(origFont);
            }
        };
    }

    @Override
    public void render(Graphics2D g) {
        super.render(g);
        double[] extents = this.range.getProjectedExtents(this.projection);
        LineDataRenderer ldr = null;
        if (this.mapImage != null) {
            RenderedImageDataRenderer mapImageRenderer = new RenderedImageDataRenderer(this.mapImage);
            mapImageRenderer.setLocation(this);
            mapImageRenderer.setExtents(extents[0], extents[1], extents[2], extents[3]);
            mapImageRenderer.setDataExtents(extents[0], extents[1], extents[2], extents[3]);
            mapImageRenderer.render(g);
        }
        if (this.lineDatas != null) {
            for (LineData ld : this.lineDatas) {
                ld.applyProjection(this.projection);
                LineDataRenderer lldr = new LineDataRenderer(ld);
                lldr.setAntiAlias(true);
                lldr.setLocation(this);
                lldr.setExtents(extents[0], extents[1], extents[2], extents[3]);
                lldr.render(g);
            }
        }
        if (this.box != null) {
            ldr = new LineDataRenderer(this.box);
            ldr.setLocation(this);
            ldr.setExtents(extents[0], extents[1], extents[2], extents[3]);
            ldr.render(g);
        }
        if (this.graticule != null) {
            LineDataRenderer gldr = new LineDataRenderer(this.graticule);
            gldr.setAntiAlias(true);
            gldr.setLocation(this);
            gldr.setExtents(extents[0], extents[1], extents[2], extents[3]);
            gldr.stroke = LineRenderer.DASHED_STROKE;
            gldr.color = Color.DARK_GRAY;
            gldr.render(g);
        }
        if (this.labels != null) {
            for (Renderer label : this.labels) {
                label.render(g);
            }
        }
        if (this.scaleRenderer != null) {
            this.scaleRenderer.render(g);
        }
        if (this.geoLabelSet != null) {
            this.renderGeoLabels(g);
        }
    }

    public static void main(String[] args) {
        GeoImageSet images = new GeoImageSet(args[0]);
        GeoLabelSet labels = new GeoLabelSet(args[1]);
        GeoRange range = new GeoRange(Double.parseDouble(args[2]), Double.parseDouble(args[3]), Double.parseDouble(args[4]), Double.parseDouble(args[5]));
        Plot plot = new Plot();
        plot.setBackgroundColor(Color.white);
        plot.setSize(1200, 900);
        TransverseMercator proj = new TransverseMercator();
        Point2D.Double origin = range.getCenter();
        proj.setup(origin, 0.0, 0.0);
        MapRenderer mr = new MapRenderer(range, proj);
        mr.setLocation(50, 50, 800);
        mr.setGeoLabelSet(labels.getSubset(range));
        RenderedImage ri = images.getMapBackground(proj, range, 800);
        mr.setMapImage(ri);
        mr.createBox(8);
        mr.createGraticule(8, true);
        mr.getDefaultTranslation(plot.getHeight());
        plot.addRenderer(mr);
        plot.quickShow();
    }
}

