/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.plot.map;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageDecoder;
import gov.usgs.plot.map.GeoImage;
import gov.usgs.plot.map.GeoImageSet;
import gov.usgs.proj.GeoRange;
import gov.usgs.util.Log;
import gov.usgs.util.Retriable;
import gov.usgs.util.Util;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Logger;

public class WMSGeoImageSet
extends GeoImageSet {
    public static final String DEFAULT_SERVER = "http://wms.jpl.nasa.gov/wms.cgi";
    public static final String DEFAULT_LAYER = "global_mosaic";
    public static final String DEFAULT_STYLE = "visual";
    public static final ExceptionType DEFAULT_EXCEPTION_TYPE = ExceptionType.XML;
    public static final ImageType DEFAULT_IMAGE_TYPE = ImageType.JPEG;
    public static final String EPSG_4326 = "EPSG:4326";
    protected String server = "http://wms.jpl.nasa.gov/wms.cgi";
    protected String layer = "global_mosaic";
    protected String styles = "visual";
    protected ExceptionType exceptionType;
    protected ImageType imageType;
    protected BufferedReader in;
    protected BufferedInputStream inputStream;
    protected Logger logger = Log.getLogger("gov.usgs.plot");

    public WMSGeoImageSet() {
        this.exceptionType = DEFAULT_EXCEPTION_TYPE;
        this.imageType = DEFAULT_IMAGE_TYPE;
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String svr) {
        this.server = svr;
    }

    public void setLayer(String l) {
        this.layer = l;
    }

    public void setStyle(String s) {
        this.styles = s;
    }

    public void addStyle(String s) {
        this.styles = this.styles == null || this.styles.length() == 0 ? s : this.styles + "," + s;
    }

    private void getReader(String resource) throws MalformedURLException, IOException {
        if (resource.indexOf("://") != -1) {
            URL url = new URL(resource);
            this.inputStream = new BufferedInputStream(url.openStream());
            this.in = new BufferedReader(new InputStreamReader(this.inputStream));
        } else {
            this.in = new BufferedReader(new FileReader(resource));
        }
    }

    public void getCapabilities() {
        char c = this.server.indexOf(63) == -1 ? (char)'?' : '&';
        String request = this.server + c + "REQUEST=GetCapabilities";
        try {
            String s;
            this.getReader(request);
            while ((s = this.in.readLine()) != null) {
                System.out.println(s);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized GeoImage getCompositeImage(final GeoRange range, final int ppdLon, final int ppdLat, double scale) {
        Retriable<GeoImage> rt = new Retriable<GeoImage>("WMS", 3){

            @Override
            public void attemptFix() {
                Util.sleep(500L);
            }

            @Override
            public boolean attempt() {
                double e;
                GeoImage image = null;
                double width = range.getLonRange() * (double)ppdLon;
                double height = range.getLatRange() * (double)ppdLat;
                double w = range.getWest();
                if (w > (e = range.getEast())) {
                    e += 360.0;
                }
                char c = WMSGeoImageSet.this.server.indexOf(63) == -1 ? (char)'?' : '&';
                String request = String.format("%s%cSERVICE=WMS&VERSION=1.1.1&REQUEST=GetMap&LAYERS=%s&STYLES=%s&WIDTH=%d&HEIGHT=%d&FORMAT=%s&EXCEPTIONS=%s&SRS=%s&BBOX=%.5f,%.5f,%.5f,%.5f", WMSGeoImageSet.this.server, Character.valueOf(c), WMSGeoImageSet.this.layer, WMSGeoImageSet.this.styles, (int)width, (int)height, WMSGeoImageSet.this.imageType.mime, WMSGeoImageSet.this.exceptionType.mime, WMSGeoImageSet.EPSG_4326, w, range.getSouth(), e, range.getNorth());
                WMSGeoImageSet.this.logger.info(request);
                try {
                    WMSGeoImageSet.this.getReader(request);
                    WMSGeoImageSet.this.inputStream.mark(16384);
                    JPEGImageDecoder codec = JPEGCodec.createJPEGDecoder((InputStream)WMSGeoImageSet.this.inputStream);
                    BufferedImage im = codec.decodeAsBufferedImage();
                    BufferedImage copy = new BufferedImage(im.getWidth(), im.getHeight(), 2);
                    copy.getGraphics().drawImage(im, 0, 0, null);
                    image = GeoImage.createMemoryImage(copy, range);
                }
                catch (Exception ex) {
                    try {
                        String s;
                        WMSGeoImageSet.this.inputStream.reset();
                        WMSGeoImageSet.this.logger.warning("WMS failure: " + ex.getMessage());
                        while ((s = WMSGeoImageSet.this.in.readLine()) != null) {
                            WMSGeoImageSet.this.logger.warning("\t" + s);
                        }
                    }
                    catch (IOException ioex) {
                        ioex.printStackTrace();
                    }
                }
                this.result = image;
                return this.result != null;
            }
        };
        return (GeoImage)rt.go();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ExceptionType {
        XML("application/vnd.ogc.se_xml"),
        IN_IMAGE("application/vnd.ogc.se_inimage"),
        BLANK("application/vnd.ogc.se_blank");

        public String mime;

        private ExceptionType(String s) {
            this.mime = s;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ImageType {
        JPEG("image/jpeg"),
        PNG("image/png");

        public String mime;

        private ImageType(String s) {
            this.mime = s;
        }
    }
}

