/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.vdx.data.generic.variable;

import gov.usgs.util.ConfigFile;
import gov.usgs.util.Util;
import gov.usgs.vdx.data.DataSource;
import gov.usgs.vdx.data.GenericDataMatrix;
import gov.usgs.vdx.data.SQLDataSource;
import gov.usgs.vdx.data.generic.variable.DataType;
import gov.usgs.vdx.data.generic.variable.Station;
import gov.usgs.vdx.server.BinaryResult;
import gov.usgs.vdx.server.RequestResult;
import gov.usgs.vdx.server.TextResult;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLGenericVariableDataSource
extends SQLDataSource
implements DataSource {
    public static final String DATABASE_NAME = "genericvariable";
    public static final boolean channels = true;
    public static final boolean translations = true;
    public static final boolean channelTypes = false;
    public static final boolean ranks = true;
    public static final boolean columns = true;
    public static final boolean menuColumns = false;

    @Override
    public String getType() {
        return DATABASE_NAME;
    }

    @Override
    public boolean getChannelsFlag() {
        return true;
    }

    @Override
    public boolean getTranslationsFlag() {
        return true;
    }

    @Override
    public boolean getChannelTypesFlag() {
        return false;
    }

    @Override
    public boolean getRanksFlag() {
        return true;
    }

    @Override
    public boolean getColumnsFlag() {
        return true;
    }

    @Override
    public boolean getMenuColumnsFlag() {
        return false;
    }

    @Override
    public void initialize(ConfigFile params) {
        this.defaultInitialize(params);
        if (!this.databaseExists()) {
            this.createDatabase();
        }
    }

    @Override
    public void disconnect() {
        this.defaultDisconnect();
    }

    @Override
    public boolean databaseExists() {
        return this.defaultDatabaseExists();
    }

    @Override
    public boolean createDatabase() {
        try {
            this.defaultCreateDatabase(true, true, false, true, true, false);
            this.database.useDatabase(this.dbName);
            this.st = this.database.getStatement();
            this.st.execute("CREATE TABLE channel_column_xref (ccid INT PRIMARY KEY AUTO_INCREMENT, cid INT, colid INT)");
            return true;
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "SQLGenericVariableDataSource.createDatabase() failed.", e);
            return false;
        }
    }

    public boolean createChannel(String channelCode, String channelName, double lon, double lat, double height, int tid) {
        return this.defaultCreateChannel(channelCode, channelName, lon, lat, height, tid, true, true, true, true);
    }

    @Override
    public RequestResult getData(Map<String, String> params) {
        String selectedTypes;
        double et;
        double st;
        int cid;
        GenericDataMatrix data;
        String action = params.get("action");
        if (action == null) {
            return null;
        }
        if (action.equals("channels")) {
            return new TextResult(this.defaultGetChannels(false));
        }
        if (action.equals("data") && (data = this.getGenericVariableData(cid = Integer.parseInt(params.get("cid")), st = Double.parseDouble(params.get("st")), et = Double.parseDouble(params.get("et")), selectedTypes = params.get("selectedTypes"))) != null) {
            return new BinaryResult(data);
        }
        return null;
    }

    public GenericDataMatrix getGenericVariableData(int cid, double st, double et, String selectedTypes) {
        return this.defaultGetData(cid, 0, st, et, true, true);
    }

    public List<DataType> getDataTypes() {
        ArrayList<DataType> result = new ArrayList<DataType>();
        try {
            this.database.useDatabase(this.dbName);
            this.ps = this.database.getPreparedStatement("SELECT type, name FROM data_types");
            this.rs = this.ps.executeQuery();
            while (this.rs.next()) {
                int type = this.rs.getInt(1);
                String name = this.rs.getString(2);
                DataType dt = new DataType(type, name);
                result.add(dt);
            }
            this.rs.close();
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Could not get data type list.", e);
        }
        return result;
    }

    public int getStationName(String code) {
        try {
            this.database.useDatabase(this.dbName);
            this.ps = this.database.getPreparedStatement("SELECT sid FROM stations WHERE code=?");
            this.ps.setString(1, code);
            this.rs = this.ps.executeQuery();
            this.rs.next();
            int id = this.rs.getInt(1);
            this.rs.close();
            return id;
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Could not get station id.", e);
            return -1;
        }
    }

    public int getStationID(String code) {
        try {
            this.database.useDatabase(this.dbName);
            this.ps = this.database.getPreparedStatement("SELECT sid FROM stations WHERE code=?");
            this.ps.setString(1, code);
            this.rs = this.ps.executeQuery();
            this.rs.next();
            int id = this.rs.getInt(1);
            this.rs.close();
            return id;
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Could not get station id.", e);
            return -1;
        }
    }

    public void insertDataType(DataType dt) {
        try {
            this.database.useDatabase(this.dbName);
            this.ps = this.database.getPreparedStatement("INSERT IGNORE INTO data_types (type, name) VALUES (?,?)");
            this.ps.setInt(1, dt.getId());
            this.ps.setString(2, dt.getName());
            this.ps.execute();
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Could not insert data type.", e);
        }
    }

    public void insertRecord(Date d, Station station, DataType dt, double dd) {
        this.insertRecord(d, station, dt, dd, false);
    }

    public void insertRecord(Date d, Station station, DataType dt, double dd, boolean r) {
        System.out.print(".");
        String stationTable = station.getOrg() + station.getSiteNo();
        if (!this.database.tableExists(this.dbName, stationTable)) {
            this.createStationTable(stationTable);
        }
        try {
            this.database.useDatabase(this.dbName);
            String sql = r ? "REPLACE INTO " : "INSERT IGNORE INTO ";
            sql = sql + stationTable + " (date, dataType, value) VALUES (?,?,?)";
            this.ps = this.database.getPreparedStatement(sql);
            this.ps.setDouble(1, Util.dateToJ2K(d));
            this.ps.setInt(2, dt.getId());
            this.ps.setDouble(3, dd);
            this.ps.execute();
            this.st = this.database.getStatement();
            this.st.execute("INSERT IGNORE INTO channel_data_types (sid, channel, type)  values (0, " + station.getId() + ", " + dt.getId() + ")");
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Could not insert record.", e);
        }
    }

    public boolean createStationTable(String stationTable) {
        boolean success = false;
        try {
            this.database.useDatabase(this.dbName);
            this.st = this.database.getStatement();
            String sql = "CREATE TABLE " + stationTable + " (date double NOT NULL," + "dataType int NOT NULL," + "value double," + "PRIMARY KEY(date,dataType));";
            this.st.execute(sql);
            success = true;
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "SQLNWISDataSource.createDatabase() failed.", e);
        }
        return success;
    }
}

