/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.vdx.data.rsam;

import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix2D;
import gov.usgs.vdx.data.hypo.HypocenterList;
import gov.usgs.vdx.data.rsam.RSAMData;
import hep.aida.ref.Histogram1D;
import java.nio.ByteBuffer;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EWRSAMData
extends RSAMData {
    protected static final int MAX_BINS = 1000000;
    public DoubleMatrix2D events;

    public EWRSAMData() {
        this.columnMap.put("time", 0);
        this.columnMap.put("rsam", 0);
    }

    public EWRSAMData(List<double[]> list, List<double[]> e) {
        super(list);
        if (e != null) {
            int rows = e.size();
            int cols = e.get(0).length;
            this.events = DoubleFactory2D.dense.make(rows, cols);
            for (int i = 0; i < rows; ++i) {
                double[] d = e.get(i);
                for (int j = 0; j < cols; ++j) {
                    this.events.setQuick(i, j, d[j]);
                }
            }
            System.out.println("Events is " + this.events.size());
        }
    }

    @Override
    public ByteBuffer toBinary() {
        ByteBuffer eventsBb;
        int j;
        int i;
        ByteBuffer dataBb;
        int cols;
        int rows;
        if (this.data != null && this.data.size() != 0) {
            rows = this.data.rows();
            cols = this.data.columns();
            dataBb = ByteBuffer.allocate(8 + rows * cols * 8);
            dataBb.putInt(rows);
            dataBb.putInt(cols);
            for (i = 0; i < rows; ++i) {
                for (j = 0; j < cols; ++j) {
                    dataBb.putDouble(this.data.getQuick(i, j));
                }
            }
        } else {
            dataBb = ByteBuffer.allocate(8);
            dataBb.putInt(0);
            dataBb.putInt(0);
        }
        if (this.events != null && this.events.size() != 0) {
            rows = this.events.rows();
            cols = this.events.columns();
            eventsBb = ByteBuffer.allocate(8 + rows * cols * 8);
            eventsBb.putInt(rows);
            eventsBb.putInt(cols);
            for (i = 0; i < rows; ++i) {
                for (j = 0; j < cols; ++j) {
                    eventsBb.putDouble(this.events.getQuick(i, j));
                }
            }
        } else {
            eventsBb = ByteBuffer.allocate(8);
            eventsBb.putInt(0);
            eventsBb.putInt(0);
        }
        ByteBuffer bb = ByteBuffer.allocate(dataBb.capacity() + eventsBb.capacity());
        bb.put(dataBb.array(), 0, dataBb.array().length);
        bb.put(eventsBb.array(), 0, eventsBb.array().length);
        return bb;
    }

    @Override
    public void fromBinary(ByteBuffer bb) {
        int j;
        int i;
        int rows = bb.getInt();
        int cols = bb.getInt();
        if (rows > 0) {
            this.data = DoubleFactory2D.dense.make(rows, cols);
            for (i = 0; i < rows; ++i) {
                for (j = 0; j < cols; ++j) {
                    this.data.setQuick(i, j, bb.getDouble());
                }
            }
        } else {
            System.out.println(":: FOUND NO VALUES IN " + bb.capacity());
        }
        rows = bb.getInt();
        cols = bb.getInt();
        if (rows > 0) {
            this.events = DoubleFactory2D.dense.make(rows, cols);
            for (i = 0; i < rows; ++i) {
                for (j = 0; j < cols; ++j) {
                    this.events.setQuick(i, j, bb.getDouble());
                }
            }
        } else {
            System.out.println(":: FOUND NO EVENTS");
        }
    }

    @Override
    public DoubleMatrix2D getCumulativeCounts() {
        return this.events;
    }

    @Override
    public Histogram1D getCountsHistogram(HypocenterList.BinSize bin) {
        System.err.println("Entering ew hist");
        if (this.events == null || this.events.size() == 0) {
            System.out.println("No events");
            return null;
        }
        System.out.println("Filling histogram with " + this.events.size() + " points");
        Histogram1D hist = new Histogram1D("", this.getHistogramAxis(bin));
        for (int i = 1; i < this.events.rows() - 1; ++i) {
            hist.fill(this.events.get(i, 0));
        }
        return hist;
    }
}

