/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.vdx.data.rsam;

import gov.usgs.util.ConfigFile;
import gov.usgs.util.Util;
import gov.usgs.vdx.data.Channel;
import gov.usgs.vdx.data.Column;
import gov.usgs.vdx.data.DataSource;
import gov.usgs.vdx.data.SQLDataSource;
import gov.usgs.vdx.data.rsam.RSAMData;
import gov.usgs.vdx.server.BinaryResult;
import gov.usgs.vdx.server.RequestResult;
import gov.usgs.vdx.server.TextResult;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLRSAMDataSource
extends SQLDataSource
implements DataSource {
    public static final String DATABASE_NAME = "rsam";
    public static final boolean channels = true;
    public static final boolean translations = false;
    public static final boolean channelTypes = false;
    public static final boolean ranks = false;
    public static final boolean columns = true;
    public static final boolean menuColumns = false;
    public static final Column[] DATA_COLUMNS = new Column[]{new Column(1, "rsam", "RSAM", "RSAM", false, true)};

    @Override
    public String getType() {
        return DATABASE_NAME;
    }

    @Override
    public boolean getChannelsFlag() {
        return true;
    }

    @Override
    public boolean getTranslationsFlag() {
        return false;
    }

    @Override
    public boolean getChannelTypesFlag() {
        return false;
    }

    @Override
    public boolean getRanksFlag() {
        return false;
    }

    @Override
    public boolean getColumnsFlag() {
        return true;
    }

    @Override
    public boolean getMenuColumnsFlag() {
        return false;
    }

    @Override
    public void initialize(ConfigFile params) {
        this.defaultInitialize(params);
        if (!this.databaseExists()) {
            this.createDatabase();
        }
    }

    @Override
    public void disconnect() {
        this.defaultDisconnect();
    }

    @Override
    public boolean databaseExists() {
        return this.defaultDatabaseExists();
    }

    @Override
    public boolean createDatabase() {
        this.defaultCreateDatabase(true, false, false, false, true, false);
        for (int i = 0; i < DATA_COLUMNS.length; ++i) {
            this.defaultInsertColumn(DATA_COLUMNS[i]);
        }
        return true;
    }

    public boolean createChannel(String channelCode, String channelName, double lon, double lat, double height) {
        return this.defaultCreateChannel(channelCode, channelName, lon, lat, height, 0, true, false, false, true);
    }

    @Override
    public RequestResult getData(Map<String, String> params) {
        double period;
        double et;
        double st;
        String cids;
        RSAMData data;
        String action = params.get("action");
        if (action == null) {
            return null;
        }
        if (action.equals("channels")) {
            return new TextResult(this.defaultGetChannels(false));
        }
        if (action.equals("data")) {
            double period2;
            double et2;
            double st2;
            int cid = Integer.parseInt(params.get("ch"));
            RSAMData data2 = this.getRSAMData(cid, st2 = Double.parseDouble(params.get("st")), et2 = Double.parseDouble(params.get("et")), period2 = Util.stringToDouble(params.get("period"), 60.0));
            if (data2 != null) {
                return new BinaryResult(data2);
            }
        } else if (action.equals("ratdata") && (data = this.getRatSAMData(cids = params.get("ch"), st = Double.parseDouble(params.get("st")), et = Double.parseDouble(params.get("et")), period = Util.stringToDouble(params.get("period"), 60.0))) != null) {
            return new BinaryResult(data);
        }
        return null;
    }

    public RSAMData getRSAMData(int cid, double st, double et, double period) {
        ArrayList<double[]> pts = new ArrayList<double[]>();
        RSAMData result = null;
        try {
            this.database.useDatabase(this.dbName);
            Channel ch = this.defaultGetChannel(cid, false);
            this.sql = "SELECT MIN(j2ksec), AVG(rsam) ";
            this.sql = this.sql + "FROM   " + ch.getCode() + " ";
            this.sql = this.sql + "WHERE  j2ksec >= ? ";
            this.sql = this.sql + "AND    j2ksec <= ? ";
            this.sql = this.sql + "GROUP BY FLOOR(j2ksec / ?) ";
            this.sql = this.sql + "ORDER BY MIN(j2ksec)";
            this.ps = this.database.getPreparedStatement(this.sql);
            this.ps.setDouble(1, st);
            this.ps.setDouble(2, et);
            this.ps.setDouble(3, period);
            this.rs = this.ps.executeQuery();
            while (this.rs.next()) {
                double[] dataRow = new double[]{this.rs.getDouble(1), this.rs.getDouble(2)};
                pts.add(dataRow);
            }
            this.rs.close();
            if (pts.size() > 0) {
                return new RSAMData(pts);
            }
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "SQLRSAMDataSource.getRSAMData()", e);
        }
        return result;
    }

    public RSAMData getRatSAMData(String ch, double st, double et, double period) {
        RSAMData result1 = null;
        RSAMData result2 = null;
        String[] channels = ch.split(",");
        int ch1 = Integer.valueOf(channels[0]);
        int ch2 = Integer.valueOf(channels[1]);
        result1 = this.getRSAMData(ch1, st, et, period);
        result2 = this.getRSAMData(ch2, st, et, period);
        return result1.getRatSAM(result2);
    }
}

