/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.vdx.data.tilt;

import cern.colt.function.DoubleDoubleFunction;
import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import cern.jet.math.Functions;
import gov.usgs.vdx.data.GenericDataMatrix;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TiltData
extends GenericDataMatrix {
    public TiltData() {
    }

    public TiltData(List<double[]> pts) {
        super(pts);
    }

    @Override
    public void setColumnNames() {
        this.columnMap.put("time", 0);
        this.columnMap.put("rank", 1);
        this.columnMap.put("east", 2);
        this.columnMap.put("north", 3);
        this.columnMap.put("holeTemp", 4);
        this.columnMap.put("boxTemp", 5);
        this.columnMap.put("instVolt", 6);
        this.columnMap.put("rainfall", 7);
    }

    public double[] getTEN(int row) {
        return new double[]{this.data.get(row, 0), this.data.get(row, 2), this.data.get(row, 3)};
    }

    public DoubleMatrix2D getAllData(double theta) {
        return DoubleFactory2D.dense.compose((DoubleMatrix2D[][])new DoubleMatrix2D[][]{{this.data.viewPart(0, 0, this.data.rows(), 2), this.getRotatedDataWithoutTime(theta), this.data.viewPart(0, 2, this.data.rows(), 2), this.getVelocityDataWithoutTime(), this.data.viewPart(0, 4, this.data.rows(), 3), this.getRainDataWithoutTime()}});
    }

    public DoubleMatrix2D getRainDataWithoutTime() {
        DoubleMatrix2D rain = DoubleFactory2D.dense.make(this.data.rows(), 1, Double.NaN);
        double total = 0.0;
        double r = 0.0;
        double last = this.data.getQuick(0, 7);
        rain.setQuick(0, 0, 0.0);
        for (int i = 1; i < this.data.rows(); ++i) {
            r = this.data.getQuick(i, 7);
            if (Double.isNaN(r)) continue;
            if (r < last) {
                last = 0.0;
            }
            last = r;
            rain.setQuick(i, 0, total += r - last);
        }
        return rain;
    }

    public DoubleMatrix2D getRotatedDataWithoutTime(double theta) {
        DoubleMatrix2D en = this.data.viewPart(0, 2, this.data.rows(), 2);
        return Algebra.DEFAULT.mult(en, this.getRotationMatrix(theta));
    }

    public DoubleMatrix2D getRotatedData(double theta) {
        DoubleMatrix2D rt = this.getRotatedDataWithoutTime(theta);
        return DoubleFactory2D.dense.compose((DoubleMatrix2D[][])new DoubleMatrix2D[][]{{this.data.viewPart(0, 0, this.data.rows(), 1), rt}});
    }

    public DoubleMatrix2D getVelocityDataWithoutTime() {
        final DoubleMatrix2D en = this.data.viewPart(0, 2, this.data.rows(), 2);
        DoubleMatrix2D ma = en.copy();
        DoubleMatrix1D m = ma.viewColumn(0);
        m.assign(ma.viewColumn(1), new DoubleDoubleFunction(){
            private double ox;
            private double oy;
            {
                this.ox = en.get(0, 0);
                this.oy = en.get(0, 1);
            }

            public double apply(double x, double y) {
                return Math.sqrt((x - this.ox) * (x - this.ox) + (y - this.oy) * (y - this.oy));
            }
        });
        DoubleMatrix1D a = ma.viewColumn(1);
        a.assign(en.viewColumn(0), new DoubleDoubleFunction(){
            private double ox;
            private double oy;
            {
                this.ox = en.get(0, 0);
                this.oy = en.get(0, 1);
            }

            public double apply(double y, double x) {
                return Math.atan2(y - this.oy, x - this.ox);
            }
        });
        return ma;
    }

    public DoubleMatrix2D getVelocityData() {
        DoubleMatrix2D ma = this.getVelocityDataWithoutTime();
        return DoubleFactory2D.dense.compose((DoubleMatrix2D[][])new DoubleMatrix2D[][]{{this.data.viewPart(0, 0, this.data.rows(), 1), ma}});
    }

    private DoubleMatrix2D getRotationMatrix(double theta) {
        DoubleMatrix2D rm = DoubleFactory2D.dense.make(2, 2);
        double tr = Math.toRadians(theta);
        rm.setQuick(0, 0, Math.cos(tr));
        rm.setQuick(0, 1, Math.sin(tr));
        rm.setQuick(1, 0, -Math.sin(tr));
        rm.setQuick(1, 1, Math.cos(tr));
        return rm;
    }

    public double getOptimalAzimuth() {
        if (this.data.rows() <= 1) {
            return 0.0;
        }
        DoubleMatrix2D G = DoubleFactory2D.dense.compose((DoubleMatrix2D[][])new DoubleMatrix2D[][]{{this.data.viewPart(0, 0, this.data.rows(), 1), DoubleFactory2D.dense.make(this.data.rows(), 1, 1.0)}});
        DoubleMatrix2D Ginv = Algebra.DEFAULT.mult(Algebra.DEFAULT.inverse(Algebra.DEFAULT.mult(G.viewDice(), G)), G.viewDice());
        double minR = Double.MAX_VALUE;
        double minTheta = 0.0;
        for (double theta = 0.0; theta <= 360.0; theta += 1.0) {
            DoubleMatrix2D rm = this.getRotationMatrix(theta);
            DoubleMatrix2D D = Algebra.DEFAULT.mult(rm, this.data.viewPart(0, 2, this.data.rows(), 2).viewDice());
            DoubleMatrix2D d = D.viewPart(0, 0, 1, D.columns()).viewDice();
            DoubleMatrix2D m = Algebra.DEFAULT.mult(Ginv, d);
            DoubleMatrix2D r = d.assign(Algebra.DEFAULT.mult(G, m), Functions.minus);
            double val = (r = Algebra.DEFAULT.mult(r.viewDice(), r)).get(0, 0);
            if (!(val < minR)) continue;
            minR = val;
            minTheta = theta;
        }
        minTheta %= 360.0;
        minTheta = 360.0 - minTheta;
        return minTheta;
    }
}

