/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.vdx.in;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Vector;

public class IPConnection
extends Thread {
    protected String ip;
    protected int port;
    private Socket socket;
    private PrintWriter out;
    private InputStreamReader in;
    private char[] buffer;
    private static final int BUFFER_SIZE = 2048;
    private boolean echo;
    protected boolean stopThread = false;
    protected boolean open;
    protected Vector msgQueue;
    protected boolean lockQueue;

    public IPConnection(String i, int p) {
        super("IPConnection Thread");
        this.ip = i;
        this.port = p;
        this.buffer = new char[2048];
        this.msgQueue = new Vector(100);
        this.echo = false;
    }

    public void setEcho(boolean b) {
        this.echo = b;
    }

    public boolean open() throws UnknownHostException, IOException {
        boolean result = false;
        this.socket = new Socket(this.ip, this.port);
        this.out = new PrintWriter(this.socket.getOutputStream());
        this.in = new InputStreamReader(this.socket.getInputStream());
        result = true;
        this.open = true;
        this.stopThread = false;
        if (!this.isAlive()) {
            this.start();
        }
        return result;
    }

    public void close() {
        try {
            if (this.open) {
                this.open = false;
                this.stopThread = true;
                this.out.close();
                this.in.close();
                this.socket.close();
                this.msgQueue.removeAllElements();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean isOpen() {
        return this.open;
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    if (this.open && !this.stopThread) {
                        int count = this.in.read(this.buffer);
                        this.receiveData(this.buffer, count);
                        continue;
                    }
                    Thread.sleep(300L);
                }
            }
            catch (SocketException sockEx) {
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    private synchronized void receiveData(char[] data, int count) {
        this.lockQueue = true;
        String msg = new String(data, 0, count);
        this.msgQueue.add(msg);
        if (this.echo) {
            System.out.print(msg);
        }
        this.lockQueue = false;
    }

    public synchronized String getMessage() {
        String msg = null;
        if (this.msgQueue.size() != 0) {
            msg = (String)this.msgQueue.elementAt(0);
            this.msgQueue.removeElementAt(0);
        }
        return msg;
    }

    public void writeChar(char c) {
        this.out.print(c);
        this.out.flush();
    }

    public void writeString(String s) {
        int len = s.length();
        int idx = 0;
        while (idx < len) {
            this.out.write(s.charAt(idx++));
        }
        this.out.flush();
    }
}

