/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.winston;

import gov.usgs.winston.Instrument;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Channel {
    private int sid;
    private Instrument instrument;
    private String code;
    private double minTime;
    private double maxTime;
    private double linearA;
    private double linearB;
    private String alias;
    private String unit;
    private List<String> groups;
    private Map<String, String> metadata;

    public Channel() {
        this.sid = -1;
        this.code = null;
        this.instrument = Instrument.NULL;
        this.minTime = Double.NaN;
        this.maxTime = Double.NaN;
    }

    public Channel(int s, String c, double min, double max) {
        this.sid = s;
        this.code = c;
        this.minTime = min;
        this.maxTime = max;
    }

    public Channel(ResultSet rs) throws SQLException {
        this.sid = rs.getInt("sid");
        this.code = rs.getString("code");
        this.minTime = rs.getDouble("st");
        this.maxTime = rs.getDouble("et");
        this.instrument = new Instrument(rs);
        this.linearA = rs.getDouble("linearA");
        if (this.linearA == 1.0E300) {
            this.linearA = Double.NaN;
        }
        this.linearB = rs.getDouble("linearB");
        if (this.linearB == 1.0E300) {
            this.linearB = Double.NaN;
        }
        this.unit = rs.getString("unit");
        if (this.unit == null) {
            this.unit = "";
        }
        this.alias = rs.getString("alias");
        if (this.alias == null) {
            this.alias = "";
        }
    }

    public void setMetadata(Map<String, String> map) {
        this.metadata = map;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void addGroup(String g) {
        if (this.groups == null) {
            this.groups = new ArrayList<String>(2);
        }
        this.groups.add(g);
    }

    public Channel(String s) {
        String[] ss = s.split(":");
        this.sid = Integer.parseInt(ss[0]);
        this.code = ss[1];
        this.minTime = Double.parseDouble(ss[2]);
        this.maxTime = Double.parseDouble(ss[3]);
        this.instrument = new Instrument();
        this.instrument.setLongitude(Double.parseDouble(ss[4]));
        this.instrument.setLatitude(Double.parseDouble(ss[5]));
        if (ss.length == 12) {
            if (ss[6].length() >= 1) {
                this.instrument.setTimeZone(ss[6]);
            }
            if (ss[7].length() >= 1) {
                this.alias = ss[7];
            }
            if (ss[8].length() >= 1) {
                this.unit = ss[8];
            }
            this.linearA = Double.parseDouble(ss[9]);
            this.linearB = Double.parseDouble(ss[10]);
            if (!ss[11].equals("~")) {
                String[] gs;
                for (String g : gs = ss[11].split("\\|")) {
                    this.addGroup(g);
                }
            }
        }
    }

    public int getSID() {
        return this.sid;
    }

    public String getCode() {
        return this.code;
    }

    public Instrument getInstrument() {
        return this.instrument;
    }

    public double getMinTime() {
        return this.minTime;
    }

    public double getMaxTime() {
        return this.maxTime;
    }

    public String toString() {
        return this.code;
    }

    public String getGroupString() {
        if (this.groups == null) {
            return "~";
        }
        String gs = "";
        for (int i = 0; i < this.groups.size() - 1; ++i) {
            gs = gs + this.groups.get(i) + "|";
        }
        gs = gs + this.groups.get(this.groups.size() - 1);
        return gs;
    }

    public List<String> getGroups() {
        return this.groups;
    }

    public String toMetadataString() {
        return String.format("%s:%s:%s:%s:%f:%f:%s:", this.toPV2String(), this.instrument.getTimeZone(), this.alias, this.unit, this.linearA, this.linearB, this.getGroupString());
    }

    public String toPV2String() {
        return String.format("%d:%s:%f:%f:%f:%f", this.sid, this.code, this.minTime, this.maxTime, this.instrument.getLongitude(), this.instrument.getLatitude());
    }

    public String toVDXString() {
        String stripped = this.code.replace('$', ' ');
        return String.format("%d:%s:%s:%f:%f:%f:%s", this.sid, this.code, stripped, this.instrument.getLongitude(), this.instrument.getLatitude(), this.instrument.getHeight(), "0");
    }

    public double getLinearA() {
        return this.linearA;
    }

    public void setLinearA(double linearA) {
        this.linearA = linearA;
    }

    public double getLinearB() {
        return this.linearB;
    }

    public void setLinearB(double linearB) {
        this.linearB = linearB;
    }

    public String getAlias() {
        if (this.alias == null || this.alias.length() == 0) {
            return null;
        }
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getUnit() {
        if (this.unit == null || this.unit.length() == 0) {
            return null;
        }
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }
}

