/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.winston.db;

import gov.usgs.earthworm.TraceBuf;
import gov.usgs.util.CodeTimer;
import gov.usgs.util.ConfigFile;
import gov.usgs.util.Log;
import gov.usgs.util.Time;
import gov.usgs.util.Util;
import gov.usgs.winston.db.Data;
import gov.usgs.winston.db.InputEW;
import gov.usgs.winston.db.WinstonDatabase;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Deriver {
    private static final String DEFAULT_CONFIG_FILENAME = "Deriver.config";
    private static final double DEFAULT_CHUNK_SIZE = 600.0;
    private static final boolean DEFAULT_RSAM_ENABLE = true;
    private static final int DEFAULT_RSAM_DELTA = 10;
    private static final int DEFAULT_RSAM_DURATION = 60;
    private WinstonDatabase winston;
    private InputEW input;
    private Data data;
    private double startTime;
    private double endTime;
    private Logger logger = Log.getLogger("gov.usgs.winston");
    private double chunkSize = 3600.0;
    private boolean quit = false;
    private boolean rsamEnable = true;
    private int rsamDelta = 10;
    private int rsamDuration = 60;
    private ConfigFile config;
    private List<String> sourceChannels;

    public Deriver() {
        this.logger.setLevel(Level.FINE);
        this.config = new ConfigFile(DEFAULT_CONFIG_FILENAME);
        this.processConfigFile();
        this.input = new InputEW(this.winston);
        this.data = new Data(this.winston);
        this.deriveAll();
    }

    public void processConfigFile() {
        this.winston = WinstonDatabase.processWinstonConfigFile(this.config);
        this.sourceChannels = this.config.getList("channel");
        String timeRange = this.config.getString("timeRange");
        double[] t = Time.parseTimeRangeQuiet(timeRange);
        this.startTime = t[0];
        this.endTime = t[1];
        this.chunkSize = Util.stringToDouble(this.config.getString("chunkSize"), 600.0);
        this.rsamEnable = Util.stringToBoolean(this.config.getString("rsam.enable"), true);
        this.rsamDelta = Util.stringToInt(this.config.getString("rsam.delta"), 10);
        this.rsamDuration = Util.stringToInt(this.config.getString("rsam.duration"), 60);
    }

    public void deriveAll() {
        for (String channel : this.sourceChannels) {
            this.logger.info("Working on " + channel);
            this.derive(channel, this.startTime, this.endTime);
        }
    }

    private void derive(String ch, double t1, double t2) {
        this.input.setRowParameters((int)this.chunkSize + 65, 60);
        double ct = t1 - this.chunkSize;
        List<TraceBuf> tbs = null;
        while (ct < t2 && !this.quit) {
            double ret = Math.min((ct += this.chunkSize) + this.chunkSize, t2);
            CodeTimer netTimer = new CodeTimer("net");
            tbs = this.data.getTraceBufs(ch, ct, ret);
            netTimer.stop(false);
            if (tbs == null || tbs.size() <= 0) continue;
            CodeTimer inputTimer = new CodeTimer("input");
            this.input.rederive(tbs, this.rsamEnable, this.rsamDelta, this.rsamDuration);
            inputTimer.stop(false);
            this.logger.info(String.format("Derived %d TraceBufs in %.3fms, insert completed in %.3fms", tbs.size(), netTimer.getRunTimeMillis(), inputTimer.getRunTimeMillis()));
        }
    }

    public static void main(String[] args) {
        new Deriver();
    }
}

