/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.winston.in;

import gov.usgs.earthworm.TraceBuf;
import gov.usgs.util.Arguments;
import gov.usgs.util.CodeTimer;
import gov.usgs.util.ConfigFile;
import gov.usgs.util.Util;
import gov.usgs.vdx.data.wave.Wave;
import gov.usgs.winston.db.Channels;
import gov.usgs.winston.db.Data;
import gov.usgs.winston.db.InputEW;
import gov.usgs.winston.db.WinstonDatabase;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StaticImporter {
    protected static StringBuffer instructions = new StringBuffer();
    protected WinstonDatabase winston;
    protected InputEW input;
    protected Channels channels;
    protected Data data;
    protected static String driver;
    protected static String url;
    protected static String db;
    protected boolean rsamEnable = true;
    protected int rsamDelta = 10;
    protected int rsamDuration = 60;

    public void setupWinston() {
        ConfigFile cf = new ConfigFile("Winston.config");
        String driver = cf.getString("winston.driver");
        String url = cf.getString("winston.url");
        String db = cf.getString("winston.prefix");
        this.winston = new WinstonDatabase(driver, url, db);
        if (!this.winston.checkDatabase()) {
            System.err.println("Winston database does not exist and could not be created.");
            System.exit(-1);
        }
        this.input = new InputEW(this.winston);
        this.channels = new Channels(this.winston);
        this.data = new Data(this.winston);
    }

    public static void outputInstructions() {
        System.out.println(instructions);
        System.exit(-1);
    }

    public void importMap(Map<String, List<Wave>> map) {
        if (map == null) {
            System.out.println("Nothing to import.");
            return;
        }
        CodeTimer timer = new CodeTimer("import");
        double minTime = 1.0E300;
        double maxTime = -1.0E300;
        for (String code : map.keySet()) {
            if (!this.channels.channelExists(code)) {
                System.out.println("Creating new channel '" + code + "' in Winston.");
                this.channels.createChannel(code);
            }
            System.out.printf("Importing channel: %s.\n", code);
            List<Wave> waves = map.get(code);
            System.out.printf("Converting %d waves into TraceBufs.\n", waves.size());
            ArrayList<TraceBuf> tbs = new ArrayList<TraceBuf>(waves.size());
            for (Wave wave : waves) {
                TraceBuf tb = new TraceBuf(code, wave);
                minTime = Math.min(minTime, tb.startTime);
                maxTime = Math.max(maxTime, tb.endTime);
                tb.createBytes();
                tbs.add(tb);
                wave = null;
            }
            waves = null;
            this.input.setRowParameters((int)(maxTime - minTime) + 5, 100);
            System.out.println("Writing TraceBufs to database.");
            this.input.inputTraceBufs(tbs, this.rsamEnable, this.rsamDelta, this.rsamDuration);
            System.out.println("Done.");
        }
        timer.stop(false);
        System.out.printf("Completed in %.2fs\n", timer.getRunTimeMillis() / 1000.0);
    }

    public static void process(List<String> files, StaticImporter impt) {
        if (files.size() == 0) {
            StaticImporter.outputInstructions();
        }
        impt.setupWinston();
        for (String fn : files) {
            System.out.println("Reading file: " + fn);
            File f = new File(fn);
            if (f.isDirectory()) {
                for (File ff : f.listFiles()) {
                    files.add(fn + File.pathSeparatorChar + ff.getName());
                }
                continue;
            }
            impt.importMap(impt.readFile(fn));
        }
    }

    protected Set<String> getArgumentSet() {
        HashSet<String> kvs = new HashSet<String>();
        kvs.add("-rd");
        kvs.add("-rl");
        return kvs;
    }

    public void processArguments(Arguments args) {
        String rd = args.get("-rd");
        this.rsamDelta = Util.stringToInt(rd, 10);
        String rl = args.get("-rl");
        this.rsamDuration = Util.stringToInt(rl, 60);
        System.out.printf("RSAM parameters: delta=%d, duration=%d.\n", this.rsamDelta, this.rsamDuration);
    }

    public void setRsamDelta(int i) {
        this.rsamDelta = i;
    }

    public void setRsamDuration(int i) {
        this.rsamDuration = i;
    }

    public abstract Map<String, List<Wave>> readFile(String var1);
}

