/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.winston.in.ew;

import gov.usgs.earthworm.TraceBuf;
import gov.usgs.util.ConfigFile;
import gov.usgs.util.Util;
import gov.usgs.winston.in.ew.Goertzel;
import gov.usgs.winston.in.ew.Options;
import gov.usgs.winston.in.ew.TraceBufFilter;

public class McCalPulseFilter
extends TraceBufFilter {
    private double preambleFreq;
    private double threshold;

    public void configure(ConfigFile cf) {
        super.configure(cf);
        if (cf == null) {
            return;
        }
        this.preambleFreq = Util.stringToDouble(cf.getString("preambleFreq"), 21.25);
        this.threshold = Util.stringToDouble(cf.getString("threshold"), 500.0);
        this.terminal = Util.stringToBoolean(cf.getString("terminal"), false);
    }

    protected boolean match(TraceBuf tb, Options options) {
        if (tb.startTime == Double.NaN) {
            return false;
        }
        double g = Goertzel.goertzel(this.preambleFreq, tb.samplingRate, tb.data, false);
        double g2 = Goertzel.goertzel(this.preambleFreq / 3.0, tb.samplingRate, tb.data, false);
        double g3 = Goertzel.goertzel(this.preambleFreq / 6.0, tb.samplingRate, tb.data, false);
        double g4 = Goertzel.goertzel(this.preambleFreq / 9.0, tb.samplingRate, tb.data, false);
        if (tb.channel.contains("EHZ") && g / (g2 + g3 + g4) > this.threshold) {
            this.addMetadata("calPulse", String.format("%.2f", Util.ewToJ2K(tb.startTime)));
            return true;
        }
        return false;
    }

    public String toString() {
        return String.format("McCalPulseFilter: accept", new Object[0]);
    }
}

