/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.winston.monitor;

import gov.usgs.net.Server;
import gov.usgs.util.ConfigFile;
import gov.usgs.util.Log;
import gov.usgs.util.Util;
import gov.usgs.winston.monitor.Collector;
import gov.usgs.winston.monitor.server.ServerHandler;
import java.util.ArrayList;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MonitorServer
extends Server
implements Runnable {
    private ConfigFile config;
    public ArrayList<Collector> collectors;
    private static final String DEFAULT_WWS = "WWS";
    private static final String DEFAULT_TITLE = "Winston Dashboard";
    public String defaultWWS;
    public String title;

    public MonitorServer(ConfigFile cf, ArrayList<Collector> collectors) {
        this.config = cf;
        this.collectors = collectors;
        if (cf == null) {
            this.logger.info("Starting MonitorServer with default config");
        }
        this.processConfigFile();
        for (int i = 0; i < 4; ++i) {
            this.addCommandHandler(new ServerHandler(this));
        }
    }

    public void processConfigFile() {
        int p;
        this.port = p = Util.stringToInt(this.config.getString("port"), 9090);
        this.logger.info("config: server=" + this.port);
        this.defaultWWS = Util.stringToString(this.config.getString("defaultWWS"), DEFAULT_WWS);
        this.logger.info("config: server.defaultWWS=" + this.defaultWWS);
        this.title = Util.stringToString(this.config.getString("title"), DEFAULT_TITLE);
    }

    public void setLogLevel(Level level) {
        if (level.equals(Level.ALL)) {
            this.logger.info("Logging set to high.");
        } else if (level.equals(Level.FINE)) {
            this.logger.info("Logging set to normal.");
        } else if (level.equals(Level.SEVERE)) {
            this.logger.info("Logging set to low.");
        } else if (level.equals(Level.OFF)) {
            this.logger.info("Logging turned off.");
        }
        Log.getLogger("gov.usgs").setLevel(level);
    }

    @Override
    public void run() {
        this.startListening();
    }

    public Collector getCollector(String collectorName) {
        for (Collector c : this.collectors) {
            if (!c.getName().equals(collectorName)) continue;
            return c;
        }
        return null;
    }
}

