/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.winston.server.cmd;

import gov.usgs.net.NetTools;
import gov.usgs.util.Util;
import gov.usgs.vdx.data.wave.Wave;
import gov.usgs.winston.db.WinstonDatabase;
import gov.usgs.winston.server.WWS;
import gov.usgs.winston.server.WWSCommandString;
import gov.usgs.winston.server.cmd.BaseCommand;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;

public class GetSCNLCommand
extends BaseCommand {
    public GetSCNLCommand(NetTools nt, WinstonDatabase db, WWS wws) {
        super(nt, db, wws);
    }

    public void doCommand(Object info, SocketChannel channel) {
        double t2;
        WWSCommandString cmd = new WWSCommandString((String)info);
        if (!cmd.isLegalSCNLTT(9)) {
            return;
        }
        int sid = this.emulator.getChannelID(cmd.getS(), cmd.getC(), cmd.getN(), cmd.getL());
        if (sid == -1) {
            this.sendNoChannelResponse(cmd.getID(), 0, cmd.getS(), cmd.getC(), cmd.getN(), cmd.getL(), channel);
            return;
        }
        double t1 = Util.ewToJ2K(cmd.getT1(true));
        double[] bounds = this.checkTimes(sid, t1, t2 = Util.ewToJ2K(cmd.getT2(true)));
        if (!this.allowTransaction(bounds)) {
            this.netTools.writeString(cmd.getEarthwormErrorString(sid, this.getError(bounds)), channel);
            return;
        }
        Wave wave = this.data.getWave(sid, t1, t2);
        if (wave != null) {
            this.writeWaveAsAscii(wave, sid, cmd.getID(), cmd.getS(), cmd.getC(), cmd.getN(), cmd.getL(), t1, t2, cmd.getString(8), channel);
        } else {
            this.netTools.writeString(cmd.getEarthwormErrorString(sid, "FG s4"), channel);
        }
        this.wws.log(Level.FINER, "GETSCNL.", channel);
    }
}

