/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.winston.tools;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import gov.usgs.winston.db.Upgrade;
import gov.usgs.winston.tools.WinstonToolsRunnablePanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class WinstonUpgradePanel
extends WinstonToolsRunnablePanel {
    private static final long serialVersionUID = 1L;
    Upgrade ug;
    JTextField currentVersion;
    JTextArea upgradeDescription;
    JButton upgradeB;

    public WinstonUpgradePanel() {
        super("Winston Upgrade");
    }

    protected void createUI() {
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), "Upgrade Winston Schema"));
        this.setLayout(new BoxLayout(this, 3));
        FormLayout layout = new FormLayout("left:p, 4dlu, fill:p:G", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        this.createFields();
        builder.append("Current schema", (Component)this.currentVersion);
        builder.nextLine();
        builder.append("Available upgrade", (Component)this.upgradeDescription);
        builder.nextLine();
        builder.appendUnrelatedComponentsGapRow();
        builder.nextLine();
        builder.append("", (Component)this.upgradeB);
        this.add(builder.getPanel());
    }

    protected void createFields() {
        this.ug = new Upgrade();
        this.currentVersion = new JTextField(this.ug.getCurrentVersion());
        this.upgradeDescription = new JTextArea(this.ug.getUpgraderDescription());
        this.upgradeDescription.setLineWrap(true);
        this.upgradeDescription.setWrapStyleWord(true);
        this.upgradeB = new JButton("upgrade");
        this.upgradeB.setEnabled(this.ug.upgradeAvailable());
        this.upgradeB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WinstonUpgradePanel.this.start();
            }
        });
    }

    protected void go() {
        this.ug.doUpgrade();
        this.removeAll();
        this.createUI();
    }

    public boolean needsWinston() {
        return true;
    }
}

