/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.Fissures.seed.builder;

import edu.iris.Fissures.seed.builder.ExportBuilder;
import edu.iris.Fissures.seed.container.Blockette;
import edu.iris.Fissures.seed.container.Btime;
import edu.iris.Fissures.seed.container.SeedObject;
import edu.iris.Fissures.seed.container.Waveform;
import edu.iris.Fissures.seed.exception.BuilderException;
import edu.iris.Fissures.seed.exception.SeedException;
import edu.iris.Fissures.seed.util.Utility;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.text.DecimalFormat;
import java.util.StringTokenizer;
import java.util.Vector;

public class SacExportBuilder
extends ExportBuilder {
    private String scriptString;
    private byte dataQuality;
    private String stationName = null;
    private String locationId = null;
    private String channelName = null;
    private String networkCode = null;
    private int numSamples = 0;
    private int srFactor = 0;
    private int srMult = 0;
    private Btime startTime = null;
    private Btime endTime = null;
    private Btime prevEndTime = null;
    private byte[] sacHeaderBlank = null;
    private byte[] sacDataBlank = null;
    private Vector stationList = null;
    private SacStation currentStation = null;
    private SacChannel currentChannel = null;
    private SacEvent sacEvent = null;
    private ExportBuilder.LogicalRecord headerRecord = null;
    private int sampleCount = 0;
    private float lastSampleValue = 0.0f;
    private String fixedEncoding = null;
    private SacSplitFilter splitter = null;

    public SacExportBuilder() {
        this.setDefaultMode();
        this.logicalRecordLength = 1024;
        this.physicalRecordLength = 2000000000;
        this.logicalRecords = new Vector(8, 8);
        this.exportMold = new Vector(8, 8);
        this.recordPadding = 0;
        this.scriptNesting = new int[8];
        this.nestingScore = new int[this.scriptNesting.length];
        this.builderType = "SAC";
        this.stationList = new Vector(8, 8);
    }

    public void setDefaultMode() {
        this.scriptString = new String("^,A,(,50,(,52,(,58,),),),71,v,(,999,),B");
        this.genScriptArray();
    }

    public static Btime getEndTime(Btime startTime, int numSamples, int srFactor, int srMult) throws Exception {
        double true_rate = (double)(srFactor * srMult) == 0.0 ? 10000.0 : Math.pow(Math.abs(srFactor), srFactor / Math.abs(srFactor)) * Math.pow(Math.abs(srMult), srMult / Math.abs(srMult));
        double ttSeconds = (double)numSamples / true_rate * 10000.0;
        return startTime.projectTime(ttSeconds);
    }

    public void splitToFiles(boolean verboseFlag) throws Exception {
        this.close();
        PipedOutputStream pout = new PipedOutputStream();
        DataOutputStream dout = new DataOutputStream(pout);
        PipedInputStream pin = new PipedInputStream(pout);
        this.open(dout);
        this.splitter = new SacSplitFilter(pin, verboseFlag);
        this.splitter.start();
    }

    public void setEncoding(String s) {
        this.fixedEncoding = s;
    }

    protected void padLogical() {
    }

    protected void padPhysical() {
    }

    protected void packToRecord() throws Exception {
        this.logicalPerPhysical = this.physicalRecordLength / this.logicalRecordLength;
        if (this.exportMold == null) {
            throw new BuilderException("null export mold");
        }
        if (this.exportMold.size() == 0) {
            return;
        }
        Blockette blk = (Blockette)this.exportMold.get(0);
        int bType = blk.getType();
        if (bType == 50) {
            SacStation newStation = new SacStation();
            newStation.stationName = blk.toString(3);
            newStation.startEffTime = new Btime(blk.toString(13));
            newStation.endEffTime = new Btime(blk.toString(14));
            newStation.networkCode = blk.toString(16);
            this.stationList.add(newStation);
            this.currentStation = newStation;
        } else if (bType == 52) {
            SacChannel newChannel = new SacChannel();
            newChannel.channelName = blk.toString(4);
            newChannel.locationId = blk.toString(3);
            newChannel.latitude = Float.parseFloat(blk.toString(10));
            newChannel.longitude = Float.parseFloat(blk.toString(11));
            newChannel.elevation = Float.parseFloat(blk.toString(12));
            newChannel.depth = Float.parseFloat(blk.toString(13));
            newChannel.azimuth = Float.parseFloat(blk.toString(14));
            newChannel.dip = Float.parseFloat(blk.toString(15));
            newChannel.sampleRate = Float.parseFloat(blk.toString(18));
            newChannel.startEffTime = new Btime(blk.toString(22));
            newChannel.endEffTime = new Btime(blk.toString(23));
            if (this.currentStation == null) {
                throw new BuilderException("got a channel blockette before a station blockette");
            }
            this.currentStation.channels.add(newChannel);
            this.currentChannel = newChannel;
        } else if (bType == 58) {
            if (Integer.parseInt(blk.toString(3)) == 0) {
                if (this.currentChannel == null) {
                    throw new BuilderException("got a sensitivity blockette before a channel blockette");
                }
                this.currentChannel.scale = Float.parseFloat(blk.toString(4));
            }
        } else if (bType == 71) {
            this.sacEvent = new SacEvent();
            this.sacEvent.eventTime = new Btime(blk.toString(3));
            this.sacEvent.eventLat = Float.parseFloat(blk.toString(5));
            this.sacEvent.eventLon = Float.parseFloat(blk.toString(6));
            this.sacEvent.eventDep = Float.parseFloat(blk.toString(7));
        } else if (bType == 999) {
            float[] dataValues;
            Waveform thisWaveform = blk.getWaveform();
            if (thisWaveform == null) {
                this.exportMold.clear();
                return;
            }
            this.dataQuality = (byte)blk.toString(2).charAt(0);
            this.stationName = blk.toString(4);
            this.locationId = blk.toString(5);
            this.channelName = blk.toString(6);
            this.networkCode = blk.toString(7);
            this.startTime = new Btime(blk.toString(8));
            this.numSamples = Integer.parseInt(blk.toString(9));
            this.srFactor = Integer.parseInt(blk.toString(10));
            this.srMult = Integer.parseInt(blk.toString(11));
            this.prevEndTime = this.endTime;
            this.endTime = SacExportBuilder.getEndTime(this.startTime, this.numSamples, this.srFactor, this.srMult);
            long timeDiff = this.startTime.diffSeconds(this.prevEndTime);
            if (timeDiff < -1L || timeDiff > 1L) {
                this.volumeFinish();
                this.sampleCount = 0;
                this.lastSampleValue = 0.0f;
                this.logicalPerPhysical = this.physicalRecordLength / this.logicalRecordLength;
                this.startNewLogical(null, false);
                this.headerRecord = this.logicalRecord;
                SacStation currentStation = null;
                int stationListSize = this.stationList.size();
                int i = 0;
                while (i < stationListSize) {
                    currentStation = (SacStation)this.stationList.get(i);
                    if (currentStation.stationName.equals(this.stationName) && currentStation.networkCode.equals(this.networkCode) && currentStation.endEffTime.diffSeconds(this.startTime) >= 0L && currentStation.startEffTime.diffSeconds(this.endTime) <= 0L) break;
                    currentStation = null;
                    ++i;
                }
                if (currentStation == null) {
                    throw new BuilderException("data record " + this.stationName + "/" + this.networkCode + "/" + this.channelName + "/" + this.locationId + " without station header info.");
                }
                SacChannel currentChannel = null;
                int channelsSize = currentStation.channels.size();
                int i2 = 0;
                while (i2 < channelsSize) {
                    currentChannel = (SacChannel)currentStation.channels.get(i2);
                    if (currentChannel.channelName.equals(this.channelName) && currentChannel.locationId.equals(this.locationId) && currentChannel.endEffTime.diffSeconds(this.startTime) >= 0L && currentChannel.startEffTime.diffSeconds(this.endTime) <= 0L) break;
                    currentChannel = null;
                    ++i2;
                }
                if (currentChannel == null) {
                    throw new BuilderException("data record " + this.stationName + "/" + this.networkCode + "/" + this.channelName + "/" + this.locationId + " without channel header info.");
                }
                int wordNum = 0;
                float wordVal = 0.0f;
                if (currentChannel.sampleRate == 0.0f) {
                    throw new BuilderException("Sample rate for " + this.stationName + "/" + this.networkCode + "/" + this.channelName + "/" + this.locationId + " has a value of zero.");
                }
                wordVal = 1.0f / currentChannel.sampleRate;
                System.arraycopy(this.floatToBytes(wordVal), 0, this.headerRecord.contents, wordNum * 4, 4);
                wordNum = 3;
                wordVal = currentChannel.scale;
                System.arraycopy(this.floatToBytes(wordVal), 0, this.headerRecord.contents, wordNum * 4, 4);
                wordNum = 5;
                wordVal = 0.0f;
                System.arraycopy(this.floatToBytes(wordVal), 0, this.headerRecord.contents, wordNum * 4, 4);
                if (this.sacEvent != null) {
                    wordNum = 7;
                    wordVal = this.sacEvent.eventTime.diffSeconds(this.startTime);
                    System.arraycopy(this.floatToBytes(wordVal), 0, this.headerRecord.contents, wordNum * 4, 4);
                }
                wordNum = 9;
                wordVal = 2.0f;
                System.arraycopy(this.floatToBytes(wordVal), 0, this.headerRecord.contents, wordNum * 4, 4);
                wordNum = 31;
                wordVal = currentChannel.latitude;
                System.arraycopy(this.floatToBytes(wordVal), 0, this.headerRecord.contents, wordNum * 4, 4);
                wordNum = 32;
                wordVal = currentChannel.longitude;
                System.arraycopy(this.floatToBytes(wordVal), 0, this.headerRecord.contents, wordNum * 4, 4);
                wordNum = 33;
                wordVal = currentChannel.elevation;
                System.arraycopy(this.floatToBytes(wordVal), 0, this.headerRecord.contents, wordNum * 4, 4);
                wordNum = 34;
                wordVal = currentChannel.depth;
                System.arraycopy(this.floatToBytes(wordVal), 0, this.headerRecord.contents, wordNum * 4, 4);
                if (this.sacEvent != null) {
                    wordNum = 35;
                    wordVal = this.sacEvent.eventLat;
                    System.arraycopy(this.floatToBytes(wordVal), 0, this.headerRecord.contents, wordNum * 4, 4);
                    wordNum = 36;
                    wordVal = this.sacEvent.eventLon;
                    System.arraycopy(this.floatToBytes(wordVal), 0, this.headerRecord.contents, wordNum * 4, 4);
                    wordNum = 38;
                    wordVal = this.sacEvent.eventDep;
                    System.arraycopy(this.floatToBytes(wordVal), 0, this.headerRecord.contents, wordNum * 4, 4);
                }
                wordNum = 57;
                wordVal = currentChannel.azimuth;
                System.arraycopy(this.floatToBytes(wordVal), 0, this.headerRecord.contents, wordNum * 4, 4);
                wordNum = 58;
                wordVal = currentChannel.dip + 90.0f;
                System.arraycopy(this.floatToBytes(wordVal), 0, this.headerRecord.contents, wordNum * 4, 4);
                StringTokenizer timeTok = new StringTokenizer(this.startTime.toString(), ",:.");
                int wordInt = 0;
                wordNum = 70;
                wordInt = timeTok.hasMoreTokens() ? Integer.parseInt(timeTok.nextToken()) : 1900;
                System.arraycopy(Utility.longToIntBytes(wordInt), 0, this.headerRecord.contents, wordNum * 4, 4);
                wordNum = 71;
                wordInt = timeTok.hasMoreTokens() ? Integer.parseInt(timeTok.nextToken()) : 1;
                System.arraycopy(Utility.longToIntBytes(wordInt), 0, this.headerRecord.contents, wordNum * 4, 4);
                wordNum = 72;
                wordInt = timeTok.hasMoreTokens() ? Integer.parseInt(timeTok.nextToken()) : 0;
                System.arraycopy(Utility.longToIntBytes(wordInt), 0, this.headerRecord.contents, wordNum * 4, 4);
                wordNum = 73;
                wordInt = timeTok.hasMoreTokens() ? Integer.parseInt(timeTok.nextToken()) : 0;
                System.arraycopy(Utility.longToIntBytes(wordInt), 0, this.headerRecord.contents, wordNum * 4, 4);
                wordNum = 74;
                wordInt = timeTok.hasMoreTokens() ? Integer.parseInt(timeTok.nextToken()) : 0;
                System.arraycopy(Utility.longToIntBytes(wordInt), 0, this.headerRecord.contents, wordNum * 4, 4);
                wordNum = 75;
                wordInt = timeTok.hasMoreTokens() ? Integer.parseInt(timeTok.nextToken()) / 10 : 0;
                System.arraycopy(Utility.longToIntBytes(wordInt), 0, this.headerRecord.contents, wordNum * 4, 4);
                wordNum = 76;
                wordInt = 6;
                System.arraycopy(Utility.longToIntBytes(wordInt), 0, this.headerRecord.contents, wordNum * 4, 4);
                wordNum = 77;
                wordInt = 0;
                System.arraycopy(Utility.longToIntBytes(wordInt), 0, this.headerRecord.contents, wordNum * 4, 4);
                wordNum = 78;
                wordInt = 0;
                System.arraycopy(Utility.longToIntBytes(wordInt), 0, this.headerRecord.contents, wordNum * 4, 4);
                wordNum = 85;
                wordInt = 1;
                System.arraycopy(Utility.longToIntBytes(wordInt), 0, this.headerRecord.contents, wordNum * 4, 4);
                wordNum = 105;
                wordInt = 1;
                System.arraycopy(Utility.longToIntBytes(wordInt), 0, this.headerRecord.contents, wordNum * 4, 4);
                wordNum = 108;
                wordInt = 0;
                System.arraycopy(Utility.longToIntBytes(wordInt), 0, this.headerRecord.contents, wordNum * 4, 4);
                wordNum = 110;
                byte[] wordChar = new byte[]{32, 32, 32, 32, 32, 32, 32, 32};
                System.arraycopy(this.stationName.getBytes(), 0, wordChar, 0, this.stationName.length());
                System.arraycopy(wordChar, 0, this.headerRecord.contents, wordNum * 4, 8);
                wordNum = 116;
                wordChar = new byte[]{32, 32, 32, 32, 32, 32, 32, 32};
                System.arraycopy(this.locationId.getBytes(), 0, wordChar, 0, this.locationId.length());
                System.arraycopy(wordChar, 0, this.headerRecord.contents, wordNum * 4, 8);
                wordNum = 144;
                wordChar = new byte[]{32, 32, 32, 32, 32, 32, 32, 32};
                wordChar[0] = this.dataQuality;
                System.arraycopy(wordChar, 0, this.headerRecord.contents, wordNum * 4, 8);
                wordNum = 150;
                wordChar = new byte[]{32, 32, 32, 32, 32, 32, 32, 32};
                System.arraycopy(this.channelName.getBytes(), 0, wordChar, 0, this.channelName.length());
                System.arraycopy(wordChar, 0, this.headerRecord.contents, wordNum * 4, 8);
                wordNum = 152;
                wordChar = new byte[]{32, 32, 32, 32, 32, 32, 32, 32};
                System.arraycopy(this.networkCode.getBytes(), 0, wordChar, 0, this.networkCode.length());
                System.arraycopy(wordChar, 0, this.headerRecord.contents, wordNum * 4, 8);
                this.headerRecord.position = 632;
            }
            if (this.fixedEncoding != null) {
                thisWaveform.setEncoding(this.fixedEncoding);
            }
            if (thisWaveform.getEncoding().equals("UNKNOWN")) {
                throw new BuilderException("Waveform data encoding is UNKNOWN");
            }
            try {
                dataValues = thisWaveform.getDecodedFloats(this.lastSampleValue);
            }
            catch (SeedException e) {
                String defaultEncoding = "Steim1";
                System.err.println("WARNING: " + e);
                System.err.println("proceeding using default encoding " + defaultEncoding);
                thisWaveform.setEncoding(defaultEncoding);
                dataValues = thisWaveform.getDecodedFloats(this.lastSampleValue);
            }
            byte[] dataBytes = new byte[4 * dataValues.length];
            int i = 0;
            while (i < dataValues.length) {
                System.arraycopy(this.floatToBytes(dataValues[i]), 0, dataBytes, 4 * i, 4);
                this.lastSampleValue = dataValues[i];
                ++i;
            }
            int dataValueOffset = 0;
            while (dataValueOffset < dataBytes.length) {
                int writeLength = this.logicalRecordLength - this.logicalRecord.position;
                if (writeLength > dataBytes.length - dataValueOffset) {
                    writeLength = dataBytes.length - dataValueOffset;
                }
                System.arraycopy(dataBytes, dataValueOffset, this.logicalRecord.contents, this.logicalRecord.position, writeLength);
                this.logicalRecord.position += writeLength;
                dataValueOffset += writeLength;
                if (this.logicalRecord.position < this.logicalRecordLength) continue;
                this.startNewLogical(null, true);
            }
            this.sampleCount += this.numSamples;
        } else {
            throw new BuilderException("SAC builder given invalid Blockette object type: " + bType);
        }
        this.exportMold.clear();
    }

    protected boolean checkTrigger(String s) throws Exception {
        if (s.equals("A")) {
            this.endTime = new Btime("1900,001,00:00:00.0000");
        } else if (!s.equals("B") && !s.equals("C")) {
            return false;
        }
        return true;
    }

    protected void volumeFinish() throws BuilderException {
        if (this.logicalRecords.size() > 0) {
            if (this.sampleCount == 0) {
                throw new BuilderException("Number of samples for " + this.stationName + "/" + this.networkCode + "/" + this.channelName + "/" + this.locationId + " has a value of zero.");
            }
            if (this.headerRecord == null) {
                throw new BuilderException("null headerRecord during EOF header update");
            }
            if (this.currentChannel == null) {
                throw new BuilderException("null channel reference during EOF header update");
            }
            int wordNum = 6;
            float wordVal = (float)(this.sampleCount - 1) / this.currentChannel.sampleRate;
            System.arraycopy(this.floatToBytes(wordVal), 0, this.headerRecord.contents, wordNum * 4, 4);
            wordNum = 79;
            int wordInt = this.sampleCount;
            System.arraycopy(Utility.longToIntBytes(wordInt), 0, this.headerRecord.contents, wordNum * 4, 4);
            byte[] resizedRecord = new byte[this.logicalRecord.position];
            System.arraycopy(this.logicalRecord.contents, 0, resizedRecord, 0, this.logicalRecord.position);
            this.logicalRecord.contents = resizedRecord;
            this.endOfLogical = true;
            this.logicalPerPhysical = this.logicalRecords.size();
        }
    }

    protected void startNewLogical(SeedObject obj, boolean continuation) throws Exception {
        this.logicalRecord = new ExportBuilder.LogicalRecord();
        if (continuation) {
            System.arraycopy(this.getBlank(false), 0, this.logicalRecord.contents, 0, this.logicalRecordLength);
        } else {
            System.arraycopy(this.getBlank(true), 0, this.logicalRecord.contents, 0, this.logicalRecordLength);
        }
        this.logicalRecord.position = 0;
        this.logicalRecords.add(this.logicalRecord);
    }

    private byte[] getBlank(boolean header) throws BuilderException {
        int wordLogicalMax;
        if (header) {
            if (this.sacHeaderBlank != null) {
                return this.sacHeaderBlank;
            }
        } else if (this.sacDataBlank != null) {
            return this.sacDataBlank;
        }
        byte[] currentBlank = new byte[this.logicalRecordLength];
        int position = 0;
        int wordStartInteger = 0;
        int wordStartLogical = 0;
        int wordStartCharacter = 0;
        int wordPosLargeChar = 0;
        int wordStartFloat = 0;
        if (header) {
            wordStartInteger = 70;
            wordStartLogical = 105;
            wordStartCharacter = 110;
            wordPosLargeChar = 112;
            wordStartFloat = 158;
        }
        if (wordStartFloat > (wordLogicalMax = this.logicalRecordLength / 4)) {
            throw new BuilderException("logical record length configuration too small: " + this.logicalRecordLength);
        }
        byte[] floatUndef = this.floatToBytes(-12345.0f);
        byte[] intUndef = Utility.longToIntBytes(-12345L);
        byte[] intFalse = new byte[]{0, 0, 0, 0};
        byte[] charUndef = new byte[]{45, 49, 50, 51, 52, 53, 32, 32};
        byte[] charUndef2 = new byte[]{45, 49, 50, 51, 52, 53, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32};
        int i = 0;
        while (i < wordStartInteger) {
            position = i * 4;
            System.arraycopy(floatUndef, 0, currentBlank, position, 4);
            ++i;
        }
        int i2 = wordStartInteger;
        while (i2 < wordStartCharacter) {
            position = i2 * 4;
            if (i2 >= wordStartLogical) {
                System.arraycopy(intFalse, 0, currentBlank, position, 4);
            } else {
                System.arraycopy(intUndef, 0, currentBlank, position, 4);
            }
            ++i2;
        }
        int i3 = wordStartCharacter;
        while (i3 < wordStartFloat) {
            position = i3 * 4;
            if (i3 == wordPosLargeChar) {
                System.arraycopy(charUndef2, 0, currentBlank, position, 16);
            } else if (i3 != wordPosLargeChar + 2) {
                System.arraycopy(charUndef, 0, currentBlank, position, 8);
            }
            i3 += 2;
        }
        int i4 = wordStartFloat;
        while (i4 < wordLogicalMax) {
            position = i4 * 4;
            System.arraycopy(floatUndef, 0, currentBlank, position, 4);
            ++i4;
        }
        if (header) {
            this.sacHeaderBlank = currentBlank;
            return this.sacHeaderBlank;
        }
        this.sacDataBlank = currentBlank;
        return this.sacDataBlank;
    }

    private void genScriptArray() {
        StringTokenizer expTok = new StringTokenizer(this.scriptString, ",");
        this.exportScript = new String[expTok.countTokens()];
        int i = 0;
        while (expTok.hasMoreTokens()) {
            this.exportScript[i++] = expTok.nextToken();
        }
    }

    private byte[] floatToBytes(float f) {
        long longVal = Float.floatToIntBits(f);
        return Utility.longToIntBytes(longVal);
    }

    class SacSplitFilter
    extends Thread {
        DataInputStream din = null;
        DataOutputStream dout = null;
        int counter = 0;
        int floatMax = 70;
        int integerMax = 110;
        int headerMax = 158;
        int numPts = 0;
        StringBuffer filenameBuffer;
        StringBuffer chanBuffer;
        StringBuffer timeBuffer;
        boolean verbose = false;

        public SacSplitFilter(InputStream is, boolean verboseFlag) {
            this.din = new DataInputStream(new BufferedInputStream(is));
            this.verbose = verboseFlag;
        }

        public void run() {
            try {
                while (!Thread.interrupted()) {
                    float[] floatVal = new float[this.floatMax];
                    int[] intVal = new int[this.integerMax - this.floatMax];
                    byte[] byteVal = new byte[(this.headerMax - this.integerMax) * 4];
                    this.counter = 0;
                    while (this.counter < this.floatMax) {
                        floatVal[this.counter++] = this.din.readFloat();
                    }
                    while (this.counter < this.integerMax) {
                        intVal[this.counter - this.floatMax] = this.din.readInt();
                        ++this.counter;
                    }
                    while (this.counter < this.headerMax) {
                        this.din.readFully(byteVal, (this.counter - this.integerMax) * 4, 4);
                        ++this.counter;
                    }
                    this.filenameBuffer = new StringBuffer("");
                    this.timeBuffer = new StringBuffer("");
                    this.filenameBuffer.append(intVal[70 - this.floatMax]);
                    this.filenameBuffer.append(".");
                    this.timeBuffer.append(intVal[70 - this.floatMax]);
                    this.timeBuffer.append(",");
                    DecimalFormat df = new DecimalFormat("000");
                    this.filenameBuffer.append(df.format(intVal[71 - this.floatMax]));
                    this.filenameBuffer.append(".");
                    this.timeBuffer.append(df.format(intVal[71 - this.floatMax]));
                    this.timeBuffer.append(" ");
                    df = new DecimalFormat("00");
                    this.filenameBuffer.append(df.format(intVal[72 - this.floatMax]));
                    this.filenameBuffer.append(".");
                    this.timeBuffer.append(df.format(intVal[72 - this.floatMax]));
                    this.timeBuffer.append(":");
                    this.filenameBuffer.append(df.format(intVal[73 - this.floatMax]));
                    this.filenameBuffer.append(".");
                    this.timeBuffer.append(df.format(intVal[73 - this.floatMax]));
                    this.timeBuffer.append(":");
                    this.filenameBuffer.append(df.format(intVal[74 - this.floatMax]));
                    this.filenameBuffer.append(".");
                    this.timeBuffer.append(df.format(intVal[74 - this.floatMax]));
                    this.timeBuffer.append(".");
                    df = new DecimalFormat("000");
                    this.filenameBuffer.append(df.format(intVal[75 - this.floatMax]));
                    this.filenameBuffer.append("0.");
                    this.timeBuffer.append(df.format(intVal[75 - this.floatMax]));
                    this.timeBuffer.append("0 UT");
                    this.chanBuffer = new StringBuffer("");
                    int byteOffset = (152 - this.integerMax) * 4;
                    String stringVal = new String(byteVal, byteOffset, 2).trim();
                    this.filenameBuffer.append(stringVal);
                    this.chanBuffer.append(stringVal);
                    this.filenameBuffer.append(".");
                    this.chanBuffer.append(".");
                    byteOffset = (110 - this.integerMax) * 4;
                    stringVal = new String(byteVal, byteOffset, 5).trim();
                    this.filenameBuffer.append(stringVal);
                    this.chanBuffer.append(stringVal);
                    this.filenameBuffer.append(".");
                    this.chanBuffer.append(".");
                    byteOffset = (116 - this.integerMax) * 4;
                    stringVal = new String(byteVal, byteOffset, 2).trim();
                    this.filenameBuffer.append(stringVal);
                    this.chanBuffer.append(stringVal);
                    this.filenameBuffer.append(".");
                    this.chanBuffer.append(".");
                    byteOffset = (150 - this.integerMax) * 4;
                    stringVal = new String(byteVal, byteOffset, 3).trim();
                    this.filenameBuffer.append(stringVal);
                    this.chanBuffer.append(stringVal);
                    this.filenameBuffer.append(".");
                    this.chanBuffer.append(",");
                    byteOffset = (144 - this.integerMax) * 4;
                    if (byteVal[byteOffset] == 81 || byteVal[byteOffset] == 82 || byteVal[byteOffset] == 68) {
                        this.filenameBuffer.append(new String(byteVal, byteOffset, 1));
                    } else {
                        this.filenameBuffer.append("U");
                    }
                    this.filenameBuffer.append(".SAC");
                    this.open(this.filenameBuffer.toString());
                    int i = 0;
                    while (i < floatVal.length) {
                        this.dout.writeFloat(floatVal[i]);
                        ++i;
                    }
                    int i2 = 0;
                    while (i2 < intVal.length) {
                        this.dout.writeInt(intVal[i2]);
                        ++i2;
                    }
                    int i3 = 0;
                    while (i3 < byteVal.length) {
                        this.dout.writeByte(byteVal[i3]);
                        ++i3;
                    }
                    this.numPts = intVal[79 - this.floatMax];
                    if (this.verbose) {
                        System.err.println("Writing " + this.chanBuffer.toString() + " " + this.numPts + " samples (binary), starting " + this.timeBuffer);
                    }
                    this.counter = 0;
                    float[] dataVal = new float[8];
                    int readSize = 8;
                    while (this.counter < this.numPts) {
                        readSize = 8;
                        if (this.numPts - this.counter < 8) {
                            readSize = this.numPts - this.counter;
                        }
                        int j = 0;
                        while (j < readSize) {
                            dataVal[j] = this.din.readFloat();
                            ++j;
                        }
                        int j2 = 0;
                        while (j2 < readSize) {
                            this.dout.writeFloat(dataVal[j2]);
                            ++j2;
                        }
                        this.counter += readSize;
                    }
                    this.close();
                }
            }
            catch (IOException e1) {
                System.err.println("I/O Error in SAC file splitter: " + e1);
            }
        }

        public void open(String filename) throws IOException {
            this.dout = new DataOutputStream(new FileOutputStream(filename));
        }

        public void close() throws IOException {
            this.dout.flush();
            this.dout.close();
            this.dout = null;
        }
    }

    private class SacEvent {
        protected Btime eventTime = null;
        protected float eventLat = 0.0f;
        protected float eventLon = 0.0f;
        protected float eventDep = 0.0f;

        private SacEvent() {
        }
    }

    private class SacChannel {
        protected String channelName = null;
        protected String locationId = null;
        protected float latitude = 0.0f;
        protected float longitude = 0.0f;
        protected float elevation = 0.0f;
        protected float depth = 0.0f;
        protected float azimuth = 0.0f;
        protected float dip = 0.0f;
        protected float scale = 1.0f;
        protected float sampleRate = 0.0f;
        protected Btime startEffTime = null;
        protected Btime endEffTime = null;

        private SacChannel() {
        }
    }

    private class SacStation {
        protected String stationName = null;
        protected String networkCode = null;
        protected Btime startEffTime = null;
        protected Btime endEffTime = null;
        protected Vector channels = new Vector(8, 8);

        private SacStation() {
        }
    }
}

