/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.Fissures.seed.builder;

import edu.iris.Fissures.seed.builder.ExportBuilder;
import edu.iris.Fissures.seed.container.Blockette;
import edu.iris.Fissures.seed.container.BlocketteFactory;
import edu.iris.Fissures.seed.container.Btime;
import edu.iris.Fissures.seed.container.SeedObject;
import edu.iris.Fissures.seed.container.Waveform;
import edu.iris.Fissures.seed.exception.BuilderException;
import edu.iris.Fissures.seed.exception.SeedFormatException;
import java.util.StringTokenizer;
import java.util.Vector;

public class SeedExportBuilder
extends ExportBuilder {
    private float seedVersion = BlocketteFactory.getDefaultVersion();
    private byte[] newByteBlock = null;
    private String organizationName = null;
    private String volumeLabel = null;
    private String scriptString;
    private int dataBegins = 0;
    private int currentRecord = 0;
    private int volumeStart = 0;
    private int volumeOffset = 0;
    private int timeSpanStart = 0;
    private int timeSpanOffset = 0;
    private int synthSeqNum = 0;
    private Vector timeSpanBlockettes = null;
    private Blockette volBlk10 = null;
    private Blockette volBlk11 = null;
    private Blockette volBlk12 = null;
    private Blockette volBlk70 = null;
    private Blockette volBlk74 = null;
    private String stationName = null;
    private String prevStationName = null;
    private String locationId = null;
    private String channelName = null;
    private String networkCode = null;
    private int numSamples = 0;
    private int srFactor = 0;
    private int srMult = 0;
    private Btime startTime = null;
    private Btime endTime = null;

    public SeedExportBuilder() {
        this.setDefaultMode();
        this.logicalRecordLength = 4096;
        this.physicalRecordLength = 32768;
        this.scriptNesting = new int[8];
        this.nestingScore = new int[this.scriptNesting.length];
        this.logicalRecords = new Vector(8, 8);
        this.exportMold = new Vector(8, 8);
        this.recordPadding = (byte)32;
        this.newByteBlock = new byte[65536];
        this.organizationName = "";
        this.volumeLabel = "";
        this.builderType = "SEED";
    }

    public SeedExportBuilder(String mode) {
        this();
        if (mode.equals("mini")) {
            this.setMiniMode();
        } else if (mode.equals("dataless")) {
            this.setDatalessMode();
        } else {
            this.setDefaultMode();
        }
    }

    public void setDatalessMode() {
        this.scriptString = new String("^,L,(,30,),(,31,),(,32,),(,33,),(,34,),(,41,),(,43,),(,44,),(,45,),(,46,),(,47,),(,48,),<,A,(,B,50,(,51,),(,52,(,53,54,61,55,56,57,58,60,),(,59,),),H,<,),I,J,<,K,v,-2,M,10,11,<,(,30,),(,31,),(,32,),(,33,),(,34,),(,41,),(,43,),(,44,),(,45,),(,46,),(,47,),(,48,),<,(,50,(,51,),(,52,(,53,54,61,55,56,57,58,60,),(,59,),),<,)");
        this.genScriptArray();
    }

    public void setMiniMode() {
        this.scriptString = "L,(,[,999,100,200,201,202,300,310,320,390,395,400,405,500,1000,1001,],<,)";
        this.genScriptArray();
    }

    public void setDefaultMode() {
        this.scriptString = new String("^,L,(,30,),(,31,),(,32,),(,33,),(,34,),(,41,),(,43,),(,44,),(,45,),(,46,),(,47,),(,48,),<,A,(,B,50,(,51,),(,52,(,53,54,61,55,56,57,58,60,),(,59,),),H,<,),C,(,D,[,999,100,200,201,202,300,310,320,390,395,400,405,500,1000,1001,],E,<,),F,71,(,72,),G,<,I,J,<,K,v,-2,M,10,11,12,<,(,30,),(,31,),(,32,),(,33,),(,34,),(,41,),(,43,),(,44,),(,45,),(,46,),(,47,),(,48,),<,(,50,(,51,),(,52,(,53,54,61,55,56,57,58,60,),(,59,),),<,),70,71,(,72,),(,74,),<,(,[,999,100,200,201,202,300,310,320,390,395,400,405,500,1000,1001,],<,)");
        this.genScriptArray();
    }

    public void setOrganizationName(String name) throws SeedFormatException {
        if (name.length() > 80) {
            throw new SeedFormatException("originating organization name cannot be longer than 80 characters");
        }
        this.organizationName = name;
    }

    public void setVolumeLabel(String label) throws SeedFormatException {
        if (label.length() > 80) {
            throw new SeedFormatException("volume label cannot be longer than 80 characters");
        }
        this.volumeLabel = label;
    }

    public static Btime getEndTime(Btime startTime, int numSamples, int srFactor, int srMult) throws Exception {
        double true_rate = (double)(srFactor * srMult) == 0.0 ? 10000.0 : Math.pow(Math.abs(srFactor), srFactor / Math.abs(srFactor)) * Math.pow(Math.abs(srMult), srMult / Math.abs(srMult));
        double ttSeconds = (double)numSamples / true_rate * 10000.0;
        return startTime.projectTime(ttSeconds);
    }

    protected void packToRecord() throws Exception {
        int byteBlockPtr = 0;
        if (this.exportMold == null) {
            throw new BuilderException("null export mold");
        }
        if (this.exportMold.size() == 0) {
            return;
        }
        Blockette blk = (Blockette)this.exportMold.get(0);
        int curField = 1;
        int rptCount = 0;
        int waveformOffset = 0;
        int numFields = blk.getNumFields();
        while (curField <= numFields) {
            int rptField = blk.getFieldRepeat(curField);
            rptCount = rptField > 0 ? Integer.parseInt(blk.toString(rptField)) : 1;
            if (rptCount == 0) {
                ++curField;
                continue;
            }
            String fldVal = blk.toString(curField, 0);
            if (blk.getType() == 50) {
                if (curField == 3) {
                    this.stationName = new String(fldVal);
                }
                blk.setFieldVal(11, new Integer(3210));
                blk.setFieldVal(12, new Integer(10));
            }
            if (blk.getType() == 999) {
                if (curField < 4) {
                    ++curField;
                    continue;
                }
                if (curField == 4) {
                    this.stationName = new String(fldVal);
                }
                if (curField == 5) {
                    this.locationId = new String(fldVal);
                }
                if (curField == 6) {
                    this.channelName = new String(fldVal);
                }
                if (curField == 7) {
                    this.networkCode = new String(fldVal);
                }
                if (curField == 8) {
                    this.startTime = new Btime(fldVal);
                }
                if (curField == 9) {
                    this.numSamples = Integer.parseInt(fldVal);
                }
                if (curField == 10) {
                    this.srFactor = Integer.parseInt(fldVal);
                }
                if (curField == 11) {
                    this.srMult = Integer.parseInt(fldVal);
                }
                if (curField == 15) {
                    blk.setFieldVal(15, new Integer(this.exportMold.size() - 1));
                }
                if (curField == 17) {
                    int numBlk = this.exportMold.size();
                    int offset = 48;
                    int i = 1;
                    while (i < numBlk) {
                        Blockette dataBlk = (Blockette)this.exportMold.get(i);
                        int numFields2 = dataBlk.getNumFields();
                        int j = 1;
                        while (j <= numFields2) {
                            offset += Integer.parseInt(dataBlk.getFieldLength(j));
                            ++j;
                        }
                        ++i;
                    }
                    Waveform waveFrm = blk.getWaveform();
                    if (waveFrm == null) {
                        waveformOffset = 0;
                        blk.setFieldVal(17, new Integer(waveformOffset));
                    } else {
                        int k = 1;
                        while (k * 64 < offset && k * 64 < this.logicalRecordLength) {
                            ++k;
                        }
                        if (k * 64 >= this.logicalRecordLength) {
                            throw new BuilderException("waveform offset value too high: " + offset);
                        }
                        waveformOffset = k * 64;
                        blk.setFieldVal(17, new Integer(waveformOffset));
                    }
                }
                if (curField == 18) {
                    if (this.exportMold.size() > 1) {
                        blk.setFieldVal(18, new Integer(48));
                    } else {
                        blk.setFieldVal(18, new Integer(0));
                    }
                }
            }
            Vector rptVec = null;
            int vecSize = 0;
            int curGrp = 0;
            while (curGrp < rptCount) {
                if (rptField > 0) {
                    rptVec = blk.getFieldGrp(curField, curGrp);
                    vecSize = rptVec.size();
                } else {
                    vecSize = 1;
                }
                int vecPos = 0;
                while (vecPos < vecSize) {
                    if (rptVec != null) {
                        fldVal = rptVec.get(vecPos).toString();
                    }
                    byte[] fldBytes = BlocketteFactory.getBytes(blk.getType(), curField + vecPos, fldVal);
                    System.arraycopy(fldBytes, 0, this.newByteBlock, byteBlockPtr, fldBytes.length);
                    byteBlockPtr += fldBytes.length;
                    ++vecPos;
                }
                ++curGrp;
            }
            curField += vecSize;
        }
        if (blk.getType() == 999) {
            int numBlk = this.exportMold.size();
            int i = 1;
            while (i < numBlk) {
                Blockette dataBlk = (Blockette)this.exportMold.get(i);
                numFields = dataBlk.getNumFields();
                if (dataBlk.getType() == 1000) {
                    dataBlk.setFieldVal(4, new Integer(1));
                }
                if (i < numBlk - 1) {
                    int offset = byteBlockPtr + 8;
                    int j = 1;
                    while (j <= numFields) {
                        offset += Integer.parseInt(dataBlk.getFieldLength(j));
                        ++j;
                    }
                    dataBlk.setFieldVal(2, new Integer(offset));
                } else {
                    dataBlk.setFieldVal(2, new Integer(0));
                }
                StringTokenizer blkTok = new StringTokenizer(dataBlk.toString(), "|");
                curField = 1;
                while (blkTok.hasMoreTokens() && curField <= numFields) {
                    String fldVal = blkTok.nextToken();
                    byte[] fldBytes = BlocketteFactory.getBytes(dataBlk.getType(), curField, fldVal);
                    System.arraycopy(fldBytes, 0, this.newByteBlock, byteBlockPtr, fldBytes.length);
                    byteBlockPtr += fldBytes.length;
                    ++curField;
                }
                ++i;
            }
        } else {
            byte[] newSize = BlocketteFactory.getBytes(50, 2, new Integer(byteBlockPtr).toString());
            System.arraycopy(newSize, 0, this.newByteBlock, 3, 4);
        }
        int transcriptionPtr = 0;
        if (this.logicalRecord == null) {
            this.startNewLogical(blk, false);
        }
        boolean continuation = false;
        while (byteBlockPtr - transcriptionPtr > 0) {
            if (this.logicalRecordLength - this.logicalRecord.position < 7) {
                this.padLogical();
                this.startNewLogical(blk, continuation);
            }
            continuation = true;
            int transcriptionAmount = byteBlockPtr - transcriptionPtr;
            if (this.logicalRecordLength - this.logicalRecord.position < transcriptionAmount) {
                transcriptionAmount = this.logicalRecordLength - this.logicalRecord.position;
            }
            System.arraycopy(this.newByteBlock, transcriptionPtr, this.logicalRecord.contents, this.logicalRecord.position, transcriptionAmount);
            transcriptionPtr += transcriptionAmount;
            this.logicalRecord.position += transcriptionAmount;
        }
        if (blk.getType() == 999 && waveformOffset > 0) {
            int i = this.logicalRecord.position;
            while (i < waveformOffset) {
                this.logicalRecord.contents[i] = this.recordPadding;
                ++i;
            }
            this.logicalRecord.position = waveformOffset;
            Waveform waveFrm = blk.getWaveform();
            if (waveFrm == null) {
                throw new BuilderException("could not find waveform in FSDH blockette when waveform offeset > 0");
            }
            byte[] waveBytes = waveFrm.getEncodedBytes();
            if (this.logicalRecord.position + waveBytes.length > this.logicalRecord.contents.length) {
                throw new BuilderException("waveform data exceeds logical record boundaries (offset = " + this.logicalRecord.position + ", length = " + waveBytes.length + ")");
            }
            System.arraycopy(waveBytes, 0, this.logicalRecord.contents, this.logicalRecord.position, waveBytes.length);
            this.logicalRecord.position += waveBytes.length;
        }
        this.exportMold.clear();
    }

    protected boolean checkTrigger(String s) throws Exception {
        if (!s.equals("A")) {
            if (s.equals("B")) {
                this.currentRecord = this.logicalRecordCount;
            } else if (s.equals("C")) {
                this.dataBegins = this.logicalRecordCount;
                this.endTime = new Btime("1900,001,00:00:00.0000");
            } else if (s.equals("D")) {
                this.currentRecord = this.logicalRecordCount;
            } else if (s.equals("E")) {
                if (this.startTime != null) {
                    Btime b70End;
                    Btime prevEndTime = this.endTime;
                    this.endTime = SeedExportBuilder.getEndTime(this.startTime, this.numSamples, this.srFactor, this.srMult);
                    Btime b70Start = (Btime)this.volBlk70.getFieldVal(4);
                    if (this.startTime.compareTo(b70Start) < 0) {
                        this.volBlk70.setFieldVal(4, this.startTime);
                    }
                    if (this.endTime.compareTo(b70End = (Btime)this.volBlk70.getFieldVal(5)) > 0) {
                        this.volBlk70.setFieldVal(5, this.endTime);
                    }
                    if (this.volBlk74 != null) {
                        long timeDiff = this.startTime.diffSeconds(prevEndTime);
                        if (timeDiff < -1L || timeDiff > 1L) {
                            this.timeSpanBlockettes.add(this.volBlk74);
                            this.volBlk74 = null;
                        } else {
                            this.volBlk74.setFieldVal(9, this.endTime);
                            this.volBlk74.setFieldVal(10, new Integer(this.currentRecord));
                        }
                    }
                    if (this.volBlk74 == null) {
                        this.volBlk74 = BlocketteFactory.createBlockette("074|0000|TEMP|OR|ARY|1900,001,00:00:00.0000|000000|01|1900,001,00:00:00.0000|000000|01|000|^|^|^|XX");
                        this.volBlk74.setFieldVal(3, this.stationName);
                        this.volBlk74.setFieldVal(4, this.locationId);
                        this.volBlk74.setFieldVal(5, this.channelName);
                        this.volBlk74.setFieldVal(6, this.startTime);
                        this.volBlk74.setFieldVal(7, new Integer(this.currentRecord));
                        this.volBlk74.setFieldVal(9, this.endTime);
                        this.volBlk74.setFieldVal(10, new Integer(this.currentRecord));
                        this.volBlk74.setFieldVal(16, this.networkCode);
                        this.volBlk74.setLookupId(this.synthSeqNum);
                        ++this.synthSeqNum;
                    }
                    this.startTime = null;
                }
            } else if (s.equals("F")) {
                if (this.volBlk74 != null) {
                    this.timeSpanBlockettes.add(this.volBlk74);
                }
                this.timeSpanOffset = 0;
                this.timeSpanStart = this.currentRecord;
                if (this.timeSpanBlockettes.size() > 0) {
                    this.push(this.volBlk70);
                }
            } else if (s.equals("G")) {
                int blk74VecSize = this.timeSpanBlockettes.size();
                int i = 0;
                while (i < blk74VecSize) {
                    this.volBlk74 = (Blockette)this.timeSpanBlockettes.get(i);
                    this.push(this.volBlk74);
                    ++i;
                }
                this.timeSpanOffset = this.logicalRecordCount - this.timeSpanStart + 1;
            } else if (s.equals("H")) {
                if (this.stationName == null) {
                    throw new BuilderException("ERROR: no station names passed export filter.");
                }
                if (!this.stationName.equals(this.prevStationName)) {
                    Vector<Object> stationVec = new Vector<Object>(2);
                    stationVec.add(this.stationName);
                    stationVec.add(new Integer(this.currentRecord));
                    this.volBlk11.addFieldGrp(4, stationVec);
                }
                this.prevStationName = new String(this.stationName);
            } else if (s.equals("I")) {
                this.volumeOffset = 0;
                this.volumeStart = this.logicalRecordCount;
                if (this.timeSpanBlockettes.size() > 0) {
                    this.volBlk12.setFieldVal(4, this.volBlk70.getFieldVal(4));
                    this.volBlk12.setFieldVal(5, this.volBlk70.getFieldVal(5));
                    this.push(this.volBlk12);
                } else {
                    this.volBlk12.setFieldVal(4, new Btime("1950,001,00:00:00.0000"));
                    this.volBlk12.setFieldVal(5, new Btime("2500,001,00:00:00.0000"));
                }
            } else if (s.equals("J")) {
                this.volBlk10.setFieldVal(3, new Double(this.seedVersion));
                int compare = 1;
                int logRecExp = 0;
                while (compare < this.logicalRecordLength) {
                    compare *= 2;
                    ++logRecExp;
                }
                this.volBlk10.setFieldVal(4, new Integer(logRecExp));
                this.volBlk10.setFieldVal(5, this.volBlk12.getFieldVal(4));
                this.volBlk10.setFieldVal(6, this.volBlk12.getFieldVal(5));
                this.volBlk10.setFieldVal(7, new Btime());
                this.volBlk10.setFieldVal(8, this.organizationName);
                this.volBlk10.setFieldVal(9, this.volumeLabel);
                this.push(this.volBlk10);
                this.push(this.volBlk11);
                this.volumeOffset = this.logicalRecordCount - this.volumeStart + 1;
            } else if (s.equals("K")) {
                int numStations = (Integer)this.volBlk11.getFieldVal(3);
                int i = 0;
                while (i < numStations) {
                    int recordNum = (Integer)this.volBlk11.getFieldVal(5, i);
                    this.volBlk11.setFieldVal(5, i, new Integer(recordNum += this.volumeOffset));
                    ++i;
                }
                this.volBlk12.setFieldVal(6, new Integer(this.dataBegins + this.volumeOffset));
                int numTimes = this.timeSpanBlockettes.size();
                int i2 = 0;
                while (i2 < numTimes) {
                    this.volBlk74 = (Blockette)this.timeSpanBlockettes.get(i2);
                    int recordNum = (Integer)this.volBlk74.getFieldVal(7);
                    this.volBlk74.setFieldVal(7, new Integer(recordNum += this.volumeOffset + this.timeSpanOffset));
                    recordNum = (Integer)this.volBlk74.getFieldVal(10);
                    this.volBlk74.setFieldVal(10, new Integer(recordNum += this.volumeOffset + this.timeSpanOffset));
                    ++i2;
                }
            } else if (s.equals("L")) {
                this.dataBegins = 0;
                this.currentRecord = 0;
                this.timeSpanBlockettes = new Vector(8, 8);
                this.volBlk10 = BlocketteFactory.createBlockette("010|0000|02.3|12|1900,001,00:00:00.0000|1900,001,00:00:00.0000|1900,001,00:00:00.0000|TEMPORARY|^");
                this.volBlk10.setLookupId(this.synthSeqNum);
                ++this.synthSeqNum;
                this.volBlk11 = BlocketteFactory.createBlockette("011|0000|000|^|^");
                this.volBlk11.setLookupId(this.synthSeqNum);
                ++this.synthSeqNum;
                this.volBlk12 = BlocketteFactory.createBlockette("012|0000|0001|1900,001,00:00:00.0000|1900,001,00:00:00.0000|000000");
                this.volBlk12.setLookupId(this.synthSeqNum);
                ++this.synthSeqNum;
                this.volBlk70 = BlocketteFactory.createBlockette("070|0000|P|2500,001,00:00:00.0000|1900,001,00:00:00.0000");
                this.volBlk70.setLookupId(this.synthSeqNum);
                ++this.synthSeqNum;
                this.volBlk74 = null;
                this.prevStationName = new String("");
                this.logicalRecordCount = 1;
            } else if (s.equals("M")) {
                this.logicalRecordCount = 1;
            } else if (s.equals("10")) {
                this.push(this.volBlk10);
            } else if (s.equals("11")) {
                this.push(this.volBlk11);
            } else if (s.equals("12")) {
                if (this.timeSpanBlockettes.size() > 0) {
                    this.push(this.volBlk12);
                }
            } else if (s.equals("70")) {
                if (this.timeSpanBlockettes.size() > 0) {
                    this.push(this.volBlk70);
                }
            } else if (s.equals("74")) {
                int numTimes = this.timeSpanBlockettes.size();
                int i = 0;
                while (i < numTimes) {
                    this.volBlk74 = (Blockette)this.timeSpanBlockettes.get(i);
                    this.push(this.volBlk74);
                    ++i;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    protected void volumeFinish() throws BuilderException {
    }

    protected void startNewLogical(SeedObject obj, boolean continuation) throws Exception {
        Blockette blk = null;
        if (obj != null) {
            blk = (Blockette)obj;
        }
        this.logicalRecord = new ExportBuilder.LogicalRecord();
        String sequenceNum = BlocketteFactory.formatDecimal(12, 6, new Integer(this.logicalRecordCount).toString());
        if (sequenceNum.length() != 6) {
            throw new BuilderException("improper length for logical record sequence number: " + sequenceNum);
        }
        System.arraycopy(sequenceNum.getBytes(), 0, this.logicalRecord.contents, 0, 6);
        this.logicalRecord.contents[7] = continuation ? 42 : 32;
        String recType = null;
        if (obj != null) {
            recType = blk.getCategory();
        }
        if (recType == null) {
            this.logicalRecord.contents[6] = 32;
        } else if (recType.equals("Volume Index")) {
            this.logicalRecord.contents[6] = 86;
        } else if (recType.equals("Abbreviation Dictionary")) {
            this.logicalRecord.contents[6] = 65;
        } else if (recType.equals("Station")) {
            this.logicalRecord.contents[6] = 83;
        } else if (recType.equals("Time Span")) {
            this.logicalRecord.contents[6] = 84;
        } else if (recType.equals("Data Record")) {
            String dataQualStr = blk.toString(2);
            this.logicalRecord.contents[6] = (byte)dataQualStr.charAt(0);
            this.logicalRecord.contents[7] = dataQualStr.length() > 1 ? (int)dataQualStr.charAt(1) : 32;
        } else {
            throw new BuilderException("Unknown category of blockette: " + recType);
        }
        this.logicalRecord.position = 8;
    }

    private void genScriptArray() {
        StringTokenizer expTok = new StringTokenizer(this.scriptString, ",");
        this.exportScript = new String[expTok.countTokens()];
        int i = 0;
        while (expTok.hasMoreTokens()) {
            this.exportScript[i++] = expTok.nextToken();
        }
    }
}

