/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.Fissures.seed.director;

import edu.iris.Fissures.seed.exception.SeedException;
import edu.iris.Fissures.seed.exception.SeedInputException;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Arrays;

public class ReadBuffer {
    protected byte[] buffer;
    private int dataLength = 0;
    private int bufSize = 0;
    public static final int defaultBufSize = 32768;
    private boolean reachedEOF = false;

    public ReadBuffer(int bufSize) {
        this.buffer = new byte[bufSize];
        Arrays.fill(this.buffer, (byte)0);
        this.bufSize = bufSize;
    }

    public ReadBuffer() {
        this(32768);
    }

    public int length() {
        return this.dataLength;
    }

    public int bufSize() {
        return this.bufSize;
    }

    public void fill(DataInputStream inStream) throws SeedException, IOException {
        int emptySpace = this.bufSize - this.dataLength;
        if (emptySpace < 0) {
            throw new SeedInputException("bufSize less than dataLength");
        }
        if (!this.reachedEOF()) {
            int available = inStream.available();
            if (available == 0) {
                this.reachedEOF = true;
                return;
            }
            if (available < emptySpace) {
                this.reachedEOF = true;
                emptySpace = available;
            }
            inStream.readFully(this.buffer, this.dataLength, emptySpace);
            this.dataLength += emptySpace;
            return;
        }
    }

    public void shift(int amount) {
        System.arraycopy(this.buffer, amount, this.buffer, 0, this.bufSize - amount);
        Arrays.fill(this.buffer, this.bufSize - amount, this.bufSize, (byte)0);
        this.dataLength -= amount;
        if (this.dataLength < 0) {
            this.dataLength = 0;
        }
    }

    public boolean reachedEOF() {
        return this.reachedEOF;
    }
}

