/*
 * Decompiled with CFR 0.152.
 */
package com.ooc.OBPortableServer;

import com.ooc.CORBA.LocalObject;
import com.ooc.IMR.ActiveState;
import com.ooc.IMR.ActiveStateFactory;
import com.ooc.IMR.Domain;
import com.ooc.IMR.DomainHelper;
import com.ooc.IMR.NoSuchOAD;
import com.ooc.IMR.NoSuchServer;
import com.ooc.IMR.OADNotRunning;
import com.ooc.IMR.ServerStatus;
import com.ooc.OAD.AlreadyLinked;
import com.ooc.OAD.ProcessEndpointManagerHolder;
import com.ooc.OAD.ProcessEndpoint_impl;
import com.ooc.OB.Assert;
import com.ooc.OB.IIOPConfig;
import com.ooc.OB.IMRActiveStateHolder;
import com.ooc.OB.InitialServiceManager;
import com.ooc.OB.LocationForward;
import com.ooc.OB.Logger;
import com.ooc.OB.ORBControl;
import com.ooc.OB.ORBInstance;
import com.ooc.OB.RefCountPolicyList;
import com.ooc.OBPortableServer.DirectServant;
import com.ooc.OBPortableServer.POALocator;
import com.ooc.OBPortableServer.POAManager;
import com.ooc.OBPortableServer.POAManagerFactory;
import com.ooc.OBPortableServer.POAManagerFactoryPackage.AcceptorConfig;
import com.ooc.OBPortableServer.POAManagerFactoryPackage.POAManagerAlreadyExists;
import com.ooc.OBPortableServer.POAManager_impl;
import com.ooc.OBPortableServer.POA_impl;
import com.ooc.OCI.AccFactoryRegistry;
import com.ooc.OCI.Acceptor;
import com.ooc.OCI.InvalidParam;
import com.ooc.OCI.NoSuchFactory;
import com.ooc.OCI.Param;
import com.ooc.OCI.ProfileInfo;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.portable.IDLEntity;
import org.omg.IOP.IOR;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;
import org.omg.PortableServer.POAManagerPackage.State;

public final class POAManagerFactory_impl
extends LocalObject
implements POAManagerFactory {
    private ORBInstance orbInstance_;
    private Hashtable managers_ = new Hashtable(7);
    private String serverName_;
    private String serverInstance_;
    private int count_;
    private boolean needIMR_;
    private IMRActiveStateHolder imrHolder_;
    private POALocator poaLocator_;
    private ProcessEndpoint_impl processEndpoint_;

    private String getUniqueName() {
        long l = System.currentTimeMillis();
        String string = "POAManager-" + l;
        Assert.assert(!this.managers_.containsKey(string = String.valueOf(string) + this.count_++));
        return string;
    }

    private void validateName(String string) throws POAManagerAlreadyExists {
        POAManager pOAManager = (POAManager)this.managers_.get(string);
        if (pOAManager != null) {
            if (pOAManager.get_state() == State.INACTIVE) {
                this.managers_.remove(string);
                return;
            }
            throw new POAManagerAlreadyExists();
        }
    }

    public POAManagerFactory_impl(String string, String string2) {
        this.serverName_ = string;
        this.serverInstance_ = string2;
        this.imrHolder_ = new IMRActiveStateHolder(string, string2);
        this.poaLocator_ = new POALocator();
        if (string == null) {
            this.serverName_ = "_RootPOA";
            this.needIMR_ = false;
            return;
        }
        this.needIMR_ = true;
    }

    public POAManager create_poa_manager(String string) throws POAManagerAlreadyExists, InvalidParam {
        Hashtable hashtable = this.managers_;
        synchronized (hashtable) {
            IDLEntity iDLEntity;
            Acceptor[] acceptorArray;
            if (string.length() == 0) {
                string = this.getUniqueName();
            } else {
                this.validateName(string);
            }
            Properties properties = this.orbInstance_.getProperties();
            Logger logger = this.orbInstance_.getLogger();
            IIOPConfig iIOPConfig = new IIOPConfig(properties, logger);
            iIOPConfig.parseAll(string);
            Param[] paramArray = iIOPConfig.getParams();
            Acceptor acceptor = null;
            try {
                acceptorArray = this.orbInstance_.getAccFactoryRegistry();
                iDLEntity = acceptorArray.get_factory(1330577409);
                acceptor = iDLEntity.create_acceptor(paramArray);
            }
            catch (NoSuchFactory noSuchFactory) {
                String string2 = "unable to create IIOP acceptor";
                logger.error(string2);
                throw new INITIALIZE(string2);
            }
            acceptorArray = new Acceptor[]{acceptor};
            iDLEntity = new POAManager_impl(this.orbInstance_, this.imrHolder_, this.poaLocator_, string, this.serverName_, acceptorArray);
            this.managers_.put(string, iDLEntity);
            IDLEntity iDLEntity2 = iDLEntity;
            java.lang.Object var4_12 = null;
            return iDLEntity2;
        }
    }

    public POAManager create_poa_manager_with_config(String string, AcceptorConfig[] acceptorConfigArray) throws POAManagerAlreadyExists, NoSuchFactory, InvalidParam {
        Hashtable hashtable = this.managers_;
        synchronized (hashtable) {
            IDLEntity iDLEntity;
            if (string.length() == 0) {
                string = this.getUniqueName();
            } else {
                this.validateName(string);
            }
            AccFactoryRegistry accFactoryRegistry = this.orbInstance_.getAccFactoryRegistry();
            Acceptor[] acceptorArray = new Acceptor[acceptorConfigArray.length];
            int n = 0;
            while (n < acceptorConfigArray.length) {
                iDLEntity = accFactoryRegistry.get_factory(acceptorConfigArray[n].id);
                acceptorArray[n] = iDLEntity.create_acceptor(acceptorConfigArray[n].params);
                ++n;
            }
            iDLEntity = new POAManager_impl(this.orbInstance_, this.imrHolder_, this.poaLocator_, string, this.serverName_, acceptorArray);
            this.managers_.put(string, iDLEntity);
            IDLEntity iDLEntity2 = iDLEntity;
            java.lang.Object var5_9 = null;
            return iDLEntity2;
        }
    }

    public POAManager[] get_poa_managers() {
        java.lang.Object object;
        Enumeration enumeration = this.managers_.keys();
        Vector<POAManager> vector = new Vector<POAManager>();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            POAManager pOAManager = (POAManager)this.managers_.get(object);
            if (pOAManager == null) continue;
            vector.addElement(pOAManager);
        }
        object = new POAManager[vector.size()];
        vector.copyInto((java.lang.Object[])object);
        return object;
    }

    public void destroy() {
        this.orbInstance_ = null;
        if (this.managers_.size() != 0) {
            this._OB_deactivate();
        }
    }

    public void _OB_deactivate() {
        IDLEntity iDLEntity;
        java.lang.Object object;
        Enumeration enumeration = this.managers_.keys();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            iDLEntity = (POAManager)this.managers_.get(object);
            if (iDLEntity == null) continue;
            try {
                iDLEntity.deactivate(true, true);
            }
            catch (AdapterInactive adapterInactive) {}
        }
        this.managers_.clear();
        object = this.imrHolder_.getActiveState();
        if (object != null) {
            iDLEntity = this.orbInstance_.getLogger();
            try {
                object.set_status(this.serverInstance_, ServerStatus.STOPPING);
            }
            catch (SystemException systemException) {
                String string = String.valueOf(this.serverName_) + ": Cannot contact IMR on shutdown";
                iDLEntity.warning(string);
            }
            this.imrHolder_.setActiveState(null);
        }
    }

    public DirectServant _OB_getDirectServant(IOR iOR, RefCountPolicyList refCountPolicyList) throws LocationForward {
        if (this.managers_.size() == 0) {
            return null;
        }
        Enumeration enumeration = this.managers_.keys();
        while (enumeration.hasMoreElements()) {
            try {
                String string = (String)enumeration.nextElement();
                POAManager_impl pOAManager_impl = (POAManager_impl)this.managers_.get(string);
                if (pOAManager_impl == null) continue;
                Acceptor[] acceptorArray = pOAManager_impl.get_acceptors();
                int n = 0;
                while (n < acceptorArray.length) {
                    ProfileInfo[] profileInfoArray = acceptorArray[n].get_local_profiles(iOR);
                    if (profileInfoArray.length > 0) {
                        return pOAManager_impl._OB_getDirectServant(profileInfoArray[0].key, refCountPolicyList);
                    }
                    ++n;
                }
            }
            catch (AdapterInactive adapterInactive) {}
        }
        return null;
    }

    public void _OB_setORBInstance(ORBInstance oRBInstance) {
        this.orbInstance_ = oRBInstance;
    }

    public void _OB_initializeIMR(POA_impl pOA_impl, ORBControl oRBControl) {
        java.lang.Object object;
        java.lang.Object object2;
        if (!this.needIMR_) {
            return;
        }
        this.processEndpoint_ = new ProcessEndpoint_impl(this.serverName_, this.serverInstance_, pOA_impl, oRBControl);
        Domain domain = null;
        try {
            object2 = this.orbInstance_.getInitialServiceManager();
            object = ((InitialServiceManager)object2).resolveInitialReferences("IMR");
            domain = DomainHelper.narrow((Object)object);
        }
        catch (InvalidName invalidName) {
        }
        catch (BAD_PARAM bAD_PARAM) {}
        object2 = this.orbInstance_.getLogger();
        object = this.orbInstance_.getProperties();
        if (domain == null) {
            String string = String.valueOf(this.serverName_) + ": IMRDomain not reachable";
            object2.error(string);
            throw new INITIALIZE(string);
        }
        String string = ((Properties)object).getProperty("com.ooc.imr.register");
        if (string != null) {
            String string2 = String.valueOf(this.serverName_) + ": Self registration not implemented" + " for java servers";
            object2.error(string2);
            throw new INITIALIZE(string2);
        }
        try {
            ActiveStateFactory activeStateFactory = domain.get_active_state_factory();
            ActiveState activeState = activeStateFactory.get_active_state(this.serverName_);
            this.imrHolder_.setActiveState(activeState);
            ProcessEndpointManagerHolder processEndpointManagerHolder = new ProcessEndpointManagerHolder();
            IOR iOR = pOA_impl._OB_createIOR(new byte[0]);
            activeState.startup(this.serverInstance_, iOR, processEndpointManagerHolder);
            this.processEndpoint_._OB_establish_link(processEndpointManagerHolder.value, this.orbInstance_.getORB());
            return;
        }
        catch (BAD_PARAM bAD_PARAM) {
            String string3 = String.valueOf(this.serverName_) + ": (IMR) Server already running";
            object2.error(string3);
            throw new INITIALIZE(string3);
        }
        catch (NoSuchServer noSuchServer) {
            String string4 = String.valueOf(this.serverName_) + ": (IMR) Not registered with IMR";
            object2.error(string4);
            throw new INITIALIZE();
        }
        catch (NoSuchOAD noSuchOAD) {
            String string5 = String.valueOf(this.serverName_) + ": (IMR) No OAD for host";
            object2.error(string5);
            throw new INITIALIZE();
        }
        catch (OADNotRunning oADNotRunning) {
            String string6 = String.valueOf(this.serverName_) + ": (IMR) OAD not running";
            object2.error(string6);
            throw new INITIALIZE();
        }
        catch (AlreadyLinked alreadyLinked) {
            String string7 = String.valueOf(this.serverName_) + ": (IMR) Process registered with OAD";
            object2.error(string7);
            throw new INITIALIZE();
        }
    }
}

