# ewhtmlemail configuration file


# Earthworm stuff
 MyModuleId     MOD_EWHTMLEMAIL          # Module ID
 InRing         HYPO_RING
 HeartbeatInt   30                   # Heartbeat interval in seconds
 LogFile        1                    # If 0. don't write logfile; if 1. do
                                     # if 2. write module log but not stderr/stdout
 Debug          0

# Get messages from
 GetLogo  INST_WILDCARD  MOD_WILDCARD # TYPE_HYP2000ARC
 
# Note that hyp2000arc messages can be very large if the number of stations
# is high.
 MaxMessageSize   16384

# site_file - MANDATORY station file. This corresponds to the station file in
#             hypoinverse-compatible format, as used by hyp2000. It is used to
#             know which waveforms are to be search from the waveservers and
#             also to plot the stations in the static google map.
 site_file    cvarg.hinv
                         


# HTMLFile - MANDATORY base name for the html file of this event. The actual  
#            filename will be <HTMLFile>_<event id>.html
#            This configuration allows creating a folder with html files for the
#            detected seismic events.
 HTMLFile        /home/earthworm/ewhtmlemail/emailfile
 
 
 
# EmailProgram - Optional email program. It is imperative that the email program
#                is capable of handling html email. ewhtmlemail has been created
#                specifically for sendmail. If this option is commented out, the
#                module assumes that emails are not to be sent and will not 
#                include the mime header in the html file. In this sense, this
#                module becomes an event-to-html converter.
 EmailProgram    /usr/sbin/sendmail
 
# List of email recipients
 EmailRecipient recipient@email.com
 
 
 
# StyleFile - Optional style file for the generated html file. Some items have
#             specific ids and classes that allows some customization through a
#             css file. Please consult the example ewhtmlemail.css file for the
#             ids and class names.
 StyleFile       /home/earthworm/params/ewhtmlemail.css




 ####################### 
 # Waveserver Settings #
 #######################
 MAX_SAMPLES   100000    # Maximum number of samples to extract from any given
                         #    station of the waveserver.
                         #    Default: 60000

 WSTimeout          5    # Waveserver timeout in seconds

# List of waveservers aaa.bbb.ccc.ddd:portno
 WaveServer 192.168.0.1:16022
 WaveServer 192.168.0.2:16022
 
 
 # TimeMargin - Optional parameter to set the time margin for downloading 
 #              waveforms from the waveservers in seconds.
 #              Default: 10.0
 TimeMargin     10.0
 

 
 
 
                         
                         
