#
# Makefile for ewaccel  -- Solaris version

CFLAGS = -O ${GLOBALFLAGS}

B = $(EW_HOME)/$(EW_VERSION)/bin
L = $(EW_HOME)/$(EW_VERSION)/lib

LIBS = -lm -lposix4 -lthread  -lnsl -lsocket

EW_LIBS = $L/logit_mt.o \
		$L/kom.o \
		$L/threads_ew.o \
		$L/time_ew.o \
		$L/transport.o \
		$L/sleep_ew.o \
       $L/mem_circ_queue.o \
		$L/getutil.o \
		$L/sema_ew.o \
		$L/ws_clientII.o \
		$L/socket_ew_common.o \
		$L/socket_ew.o \
		$L/swap.o \
		$L/ew_spectra_io.o

OBJS = ewaccel.o butterworth_c.o


ewaccel: $(OBJS) $(EW_LIBS)
	$(CC) $(CFLAGS) -o $B/ewaccel $(OBJS) $(EW_LIBS) $(LIBS)

lint:
	lint ewaccel.c \
			$(GLOBALFLAGS)

# Clean-up rules
clean:
	rm -f a.out core *.o *.obj *% *~

clean_bin:
	rm -f $B/ewaccel


.c.o:
	$(CC) -c ${CFLAGS} $<

