      SUBROUTINE HYCRT
C--READS A TRAVEL TIME TABLE FOR A LINEAR GRADIENT CRUST MODEL FOR HYPOINVERSE
      INCLUDE 'common.inc'

C--IDENTIFY THE MODEL MOD AS A LINEAR GRADIENT TABLE
      MODTYP(MOD)=0

C--READ HEADER INFO
      READ (14,1000) MODNAM(MOD),LAY(MOD),REDV(MOD)
1000  FORMAT (A20,I2,F8.4)
      CRODE(MOD)=MODNAM(MOD)(1:3)

C--READ DEPTHS & VELOCITIES OF MODEL
      READ (14,1001) (D(I,MOD),I=1,LAY(MOD))
      READ (14,1001) (VEL(I,MOD),I=1,LAY(MOD))
1001  FORMAT (15F5.2)

C--READ DISTANCE & DEPTH GRID INFO
      READ (14,1003) DD1(MOD),ND1(MOD),DD2(MOD),ND2(MOD),
     2 DZ1(MOD),NZ1(MOD),DZ2(MOD),NZ2(MOD)
1003  FORMAT (2(F7.4,I3))
      ND(MOD)=ND1(MOD)+ND2(MOD)+1
      NZ(MOD)=NZ1(MOD)+NZ2(MOD)+1

C--READ REDUCED TRAVEL TIMES, GROUPED BY DEPTH
      DO 20 J=1,NZ(MOD)
      READ (14,1004) KDHR(MOD,J)
1004  FORMAT (20X,I10)
20    READ (14,1005) (KT(MOD,J,I),I=1,ND(MOD))
1005  FORMAT (15I6)
      GD1(MOD)=ND1(MOD).NE.0 .AND. DD1(MOD).NE.0
      GD2(MOD)=ND2(MOD).NE.0 .AND. DD2(MOD).NE.0
      GZ1(MOD)=NZ1(MOD).NE.0 .AND. DZ1(MOD).NE.0
      GZ2(MOD)=NZ2(MOD).NE.0 .AND. DZ2(MOD).NE.0
      RETURN
      END
