      SUBROUTINE HYFILE (IUNIT,ITYPE)
C--DETERMINE THE FILE TYPE AND FORMAT OF A HYPOINVERSE PHASE/ARC/SUM FILE
C--THE FILE MUST ALREADY BE OPENED ON UNIT IUNIT

C--INPUT:  IUNIT - THE UNIT NUMBER OF THE FILE
C--OUTPUT: ITYPE - THE HYPOINVERSE FILE TYPE JUDGED FROM THE FIRST 2 LINES
C  1 HYPOINVERSE (PRE 2000) SUMMARY
C  2 HYPOINVERSE-2000 SUMMARY
C  3 HYPO71 (PRE 2000) SUMMARY
C  4 HYPO71-2000 SUMMARY
C  5 TRADITIONAL HYPO71-HYPOINVERSE PHASE (PRE 2000)
C  6 HYPO71-HYPOINVERSE PHASE (PRE 2000) WITH SHADOW CARDS
C  7 HYPOINVERSE (PRE 2000) ARCHIVE
C  8 HYPOINVERSE-2000 ARCHIVE
C  9 HYPOINVERSE (PRE 2000) ARCHIVE WITH SHADOW CARDS
C 10 HYPOINVERSE-2000 ARCHIVE WITH SHADOW CARDS

C  0 NOT ONE OF THESE FILE TYPES
C -1 EMPTY FILE


C--THE FILE TYPE CAN ONLY BE DISCRIMINATED FROM THESE 10 TYPES
C  (SOME OTHER FILE TYPES MAY PASS ONE OF THESE TESTS, OR
C  AN ERRONEOUS HYPOINVERSE FILE MAY FAIL ALL TESTS)

      CHARACTER REC1*21,REC2*21
      LOGICAL LDIG17,LDIG14,LDIG6,LDIG,LALPH1,LALPH2
      ITYPE=0
      REC2=' '

CC--DETERMINE INPUT FILE FORMAT
C	CALL OPENR (IUNIT, INFIL(1), 'F', IOS)
C	IF (IOS.GT.0) GOTO XXX

C--READ THE FIRST RECORD
C--ALL FILE TYPES EXCEPT PHASE BEGIN WITH A SUMMARY CARD
      READ (IUNIT,'(A17)',END=200) REC1
      IDIG17=ICHAR (REC1(17:17))
      LDIG17=IDIG17.GT.47 .AND. IDIG17.LT.58   !T IF A NUMERICAL DIGIT

      IDIG14=ICHAR (REC1(14:14))
      LDIG14=IDIG14.GT.47 .AND. IDIG14.LT.58   !T IF A NUMERICAL DIGIT

      IDIG6=ICHAR (REC1(6:6))
      LDIG6=IDIG6.GT.47 .AND. IDIG6.LT.58   !T IF A NUMERICAL DIGIT

C--------------------------------
C--FIRST TEST FOR TOO MANY BLANKS
      IF (REC1(1:4).EQ.'    ' .OR. REC1(10:13).EQ.'    ') GOTO 202
C--TEST FOR TOO MANY LETTERS
C--SET FLAG IF A NON-DIGIT OR NON-BLANK CHARACTER IS FOUND
C--SUMMARY CARDS HAVE NO LETTERS IN COLS 1-12, PHASE NO LETTERS IN COLS 10-21
      LALPH1=.FALSE.
      DO I=1,12
        IDIG=ICHAR (REC1(I:I))
        LDIG=(IDIG.GT.47 .AND. IDIG.LT.58) .OR. IDIG.EQ.32 !T IF DIGIT OR BLANK
        IF (.NOT.LDIG) LALPH1=.TRUE.
      END DO
      LALPH2=.FALSE.
      DO I=10,21
        IDIG=ICHAR (REC1(I:I))
        LDIG=(IDIG.GT.47 .AND. IDIG.LT.58) .OR. IDIG.EQ.32 !T IF DIGIT OR BLANK
        IF (.NOT.LDIG) LALPH2=.TRUE.
      END DO
      IF (LALPH1 .AND. LALPH2) GOTO 202

C--------------------------------
C--TEST FOR PHASE CARDS
C  A PHASE CARD ON THE FIRST LINE MEANS ITS A PHASE FILE.
      IF (.NOT.LDIG6) THEN
        READ (IUNIT,'(A1)',END=202) REC2
        IF (REC2(1:1).EQ.'$') THEN
C==PHASE SHADOW FORMAT
          ITYPE=6
          RETURN
        END IF
C==PHASE FORMAT
        ITYPE=5
        RETURN
      END IF

C---------------------------------------
C--THESE 4 SUMMARY TESTS COULD BE DONE IN ANY ORDER, BUT DO MOST COMMON FIRST:
C--HYPOINV-2000
      IF (LDIG17 .AND. REC1(12:12).NE.' ') THEN
        READ (IUNIT,'(A)',END=204) REC2
        IF (REC2(1:1).EQ.'$') THEN
C==ARCHIVE-2000 SHADOW FORMAT
          ITYPE=10
          RETURN
        END IF

C--THE FILE IS EITHER AN ARCHIVE-2000 OR AN HI SUMMARY-2000
C--A STATION ARCHIVE LINE IS BLANK IN COLS 8 & 13
        IF (REC2(8:8).EQ.' ' .AND. REC2(13:13).EQ.' ') THEN
C==ARCHIVE-2000 FORMAT
          ITYPE=8
          RETURN
        END IF
C==HYPOINVERSE-2000 SUMMARY
        ITYPE=2
        RETURN

C--------------------------------------
C--OLD HYPOINVERSE SUMMARY
      ELSE IF (.NOT.LDIG17 .AND. LDIG14) THEN
C      ELSE IF (.NOT.LDIG17 .AND. REC1(9:9).NE.' ') THEN  !INCORRECT
        READ (IUNIT,'(A)',END=206) REC2
        IF (REC2(1:1).EQ.'$') THEN
C==ARCHIVE SHADOW FORMAT
          ITYPE=9
          RETURN
        END IF

C--THE FILE IS EITHER AN ARCHIVE OR AN HI SUMMARY
C--COL 6 IS THE P REMARK (OR BLANK) <ARC>; OR THE DAY OF THE MONTH <SUM>
        IDIG6=ICHAR (REC2(6:6))
        LDIG6=IDIG6.GT.47 .AND. IDIG6.LT.58   !T IF A NUMERICAL DIGIT
        IF (.NOT.LDIG6) THEN
C==ARCHIVE FORMAT
          ITYPE=7
          RETURN
        END IF
C==HYPOINVERSE SUMMARY
        ITYPE=1
        RETURN

C---------------------------------------
      ELSE IF (REC1(9:9).EQ.' ' .AND. REC1(14:14).EQ.' ') THEN
C==HYPO71-2000 SUMMARY
        ITYPE=4
        RETURN

      ELSE IF (LDIG17 .AND. REC1(12:12).EQ.' ') THEN 
C==HYPO71 SUMMARY
        ITYPE=3
        RETURN

      ELSE
c==UNKNOWN FORMAT, NOT SUMMARY OR PHASE
        ITYPE=0
        RETURN
      END IF
 
C--EMPTY FILE
200   ITYPE=-1
      RETURN
C--PREMATURE END OF FILE, OR A LINE WITH TOO MANY BLANKS OR LETTERS
202   ITYPE=0
      RETURN
C--AN END OF FILE HERE MEANS A HYPOINV-2000 SUMMARY FILE WITH 1 LINE
204   ITYPE=2
      RETURN
C--AN END OF FILE HERE MEANS AN OLD HYPOINVERSE SUMMARY FILE WITH 1 LINE
206   ITYPE=1
      RETURN

C	  WRITE (6,*) 'READING HYPOINVERSE-2000 FORMAT'
C	  WRITE (6,*) 'READING OLD HYPOINVERSE FORMAT'
C	  WRITE (6,*) 'READING HYPO71-2000 FORMAT'
C	  WRITE (6,*) 'READING OLD HYPO71 FORMAT'
C	  WRITE (6,*) 'UNRECOGNIZED SUMMARY FORMAT, SELECT QUITS'

      END

