B = $(EW_HOME)/$(EW_VERSION)/bin

# for MAC OS X 
# FC=gfortran
# FLIBS=-lg2c
#
#  HYP	    HYPOINVERSE EARTHQUAKE LOCATION PROGRAM. version 1.3

SRCS =  hyp.for    hybda.for  hycmd.for  hysta.for  hydel.for  hyate.for  \
        hyfmc.for  hycal.for  hyxmc.for  hycrh.for  hycrt.for  hystl.for  \
	hyopen.for hyinit.for hyphs.for  hysou.for  hytrl.for  hyloc.for  \
	hysol.for  hysvd.f    hytra.for  hytrh.for  hytrt.for  hymag.for  \
	hyrep.for  hylst.for  hysum.for  hyinp.for  hypro.for  medwt.for  \
	utmcal.for hydelt.f   hyedit.f   hytime.f   hybeg.f    hypref.for \
	hymagp.for linv.for   linvol.for hyfile.for hylinv.for hylin.for  \
	hycre.for  hytre.for  trvcon.for allsubs.f

OBJS = ${SRCS:%.for=%.o}

OBJS = ${SRCS:%.f=%.o}

LDFLAGS += -Bstatic

hyp2000:   ${OBJS}
	${FC} ${FFLAGS} ${LDFLAGS} ${OBJS} -o $B/hyp2000 ${FLIBS}

# The -Bstatic option loads all fortran system subroutines into the executable
# so hyp can be copied to a similar system without fortran to run without
# the fortran system libraries.

# line for loading all "common" subroutines in a library using f77:
#	-Bstatic -L/home/calnet/klein/subs -lfs -o hyp
# this is no longer used because it is not portable across systems & compilers

#  allsubs - collection of general subroutines into one file
#  This is the ${FC} version of readq subroutine (no q format)

allsubs.o  :  allsubs.f 
	${FC} ${FFLAGS} -c allsubs.f

#  HYP	   * MAIN HYPOINVERSE PROGRAM.
hyp.o  :  hyp.for common.inc
	${FC} ${FFLAGS} -c hyp.for

#  HYBDA   * BLOCK DATA INITIALIZATION OF COMMON.
hybda.o  :  hybda.for common.inc
	${FC} ${FFLAGS} -c hybda.for

#  HYBEG   * INITIALIZATION OF OTHER VARIABLES.
hybeg.o  :  hybeg.f common.inc
	${FC} ${FFLAGS} -c hybeg.f

#  HYCMD   * GETS AND PROCESSES COMMANDS.
hycmd.o  :  hycmd.for common.inc
	${FC} ${FFLAGS} -c hycmd.for

#  HYSTA   * READS IN STATIONS.
hysta.o  :  hysta.for common.inc
	${FC} ${FFLAGS} -c hysta.for

#  HYDEL   * READS IN STATION DELAYS (FOR MULTIPLE MODELS).
hydel.o  :  hydel.for common.inc
	${FC} ${FFLAGS} -c hydel.for

#  HYATE   * READS IN STATION ATTENUATION HISTORY.
hyate.o  :  hyate.for common.inc
	${FC} ${FFLAGS} -c hyate.for

#  HYCAL   * READS IN STATION CAL FACTOR HISTORY.
hycal.o  :  hycal.for common.inc
	${FC} ${FFLAGS} -c hycal.for

#  HYFMC   * READS IN STATION FMAG CORRECTIONS.
hyfmc.o  :  hyfmc.for common.inc
	${FC} ${FFLAGS} -c hyfmc.for

#  HYFILE   * DETERMINES INPUT FILE TYPE.
hyfile.o  :  hyfile.for
	${FC} ${FFLAGS} -c hyfile.for

#  HYXMC   * READS IN STATION XMAG CORRECTIONS.
hyxmc.o  :  hyxmc.for common.inc
	${FC} ${FFLAGS} -c hyxmc.for

#  HYCRH   * READS IN HOMOGENOUS LAYER CRUSTAL MODELS.
hycrh.o  :  hycrh.for common.inc
	${FC} ${FFLAGS} -c hycrh.for

#  HYCRT   * READS IN TRAVEL-TIME-TABLE CRUSTAL MODELS.
hycrt.o  :  hycrt.for common.inc
	${FC} ${FFLAGS} -c hycrt.for

#  HYSTL   * OUTPUTS STATIONS, CRUST & PARAMETERS TO PRINT FILE.
hystl.o  :  hystl.for common.inc
	${FC} ${FFLAGS} -c hystl.for

#  HYOPEN  * OPENS FILES FOR LOCATION RUN.
hyopen.o  :  hyopen.for common.inc
	${FC} ${FFLAGS} -c hyopen.for

#  HYINIT  * INITIALIZES SOME VARIABLES FOR LOCATION RUN.
hyinit.o  :  hyinit.for common.inc
	${FC} ${FFLAGS} -c hyinit.for

#  HYPHS   * READS IN PHASE DATA FOR ONE EVENT.
hyphs.o  :  hyphs.for common.inc
	${FC} ${FFLAGS} -c hyphs.for

#  HYTRL   * SETS TRIAL HYPOCENTER.
hytrl.o  :  hytrl.for common.inc
	${FC} ${FFLAGS} -c hytrl.for

#  HYLOC   * LOCATES ONE EVENT.
hyloc.o  :  hyloc.for common.inc
	${FC} ${FFLAGS} -c hyloc.for

#  HYSOL   * PERFORMS INVERSION FOR ONE ITERATION.
hysol.o  :  hysol.for common.inc
	${FC} ${FFLAGS} -c hysol.for

#  HYSVD     CANNED SINGLE-VALUE-DECOMPOSITION ROUTINE.
hysvd.o  :  hysvd.f
	${FC} ${FFLAGS} -c hysvd.f

#  HYTRA   * MANAGE CRUST MODEL CHOICE & AVERAGING.
hytra.o  :  hytra.for common.inc
	${FC} ${FFLAGS} -c hytra.for

#  HYTRH   * CALC TRAVEL TIMES AND DERIVS FOR HOMO LAYER MODEL.
hytrh.o  :  hytrh.for common.inc
	${FC} ${FFLAGS} -c hytrh.for

#  HYTRT   * CALC TRAVEL TIMES AND DERIVS FROM TRAV-TIME TABLE.
hytrt.o  :  hytrt.for common.inc
	${FC} ${FFLAGS} -c hytrt.for

#  HYLINV  * CALC TT AND DERIVS FROM LINEAR GRAD LAYER OVER HALFSPACE.
hylinv.o  :  hylinv.for common.inc
	${FC} ${FFLAGS} -c hylinv.for

#  HYLIN  * CALC TT AND DERIVS FROM LINEAR GRAD MODEL.
hylin.o  :  hylin.for common.inc
	${FC} ${FFLAGS} -c hylin.for

#  HYCRE  * READS IN HYPOELLIPSE LAYER CRUSTAL MODELS.
hycre.o  :  hycre.for common.inc
	${FC} ${FFLAGS} -c hycre.for

#  HYTRE  * CALC TRAVEL TIMES AND DERIVS FOR HYPOELLIPSE LAYER MODEL.
hytre.o  :  hytre.for common.inc
	${FC} ${FFLAGS} -c hytre.for

#  HYMAG   * COMPUTES DUR & MAX AMP MAGNITUDE.
hymag.o  :  hymag.for common.inc
	${FC} ${FFLAGS} -c hymag.for

#  HYMAGP   * COMPUTES P AMP MAGNITUDE.
hymagp.o  :  hymagp.for common.inc
	${FC} ${FFLAGS} -c hymagp.for

#  HYPREF  * SELECTS PREFERRED MAGNITUDE.
hypref.o  :  hypref.for common.inc
	${FC} ${FFLAGS} -c hypref.for

#  HYREP   * REPORTS A LOCATION ON THE TERMINAL.
hyrep.o  :  hyrep.for common.inc
	${FC} ${FFLAGS} -c hyrep.for

#  HYSOU   * TABULATES MOST COMMON DATA SOURCES.
hysou.o  :  hysou.for common.inc
	${FC} ${FFLAGS} -c hysou.for

#  HYLST   * OUTPUTS DATA BY STATION TO PRINT & ARCHIVE FILES.
hylst.o  :  hylst.for common.inc
	${FC} ${FFLAGS} -c hylst.for

#  HYSUM   * OUTPUTS SUMMARY RECORD (FINAL LOCATION).
hysum.o  :  hysum.for common.inc
	${FC} ${FFLAGS} -c hysum.for

#  HYINP     FOR INTERACTIVE ENTRY OF PHASE DATA.
hyinp.o  :  hyinp.for
	${FC} ${FFLAGS} -c hyinp.for

#  HYPRO   * INTERACTIVELY PROCESSES A SERIES OF EVENTS.
hypro.o  :  hypro.for common.inc
	${FC} ${FFLAGS} -c hypro.for

#  MEDWT     COMPUTES THE WEIGHTED MEDIAN OF A SERIES OF MAGNITUDES.
medwt.o  :  medwt.for
	${FC} ${FFLAGS} -c medwt.for

#  LINV     TRAVEL TIME & DERIVATIVES FOR HYPOELLIPSE GRADIENT MODEL.
linv.o  :  linv.for
	${FC} ${FFLAGS} -c linv.for

#  LINVOL TRAVEL TIME & DERIVs FOR HYPOELLIPSE GRADIENT OVER HALPSPACE MODEL.
linvol.o  :  linvol.for
	${FC} ${FFLAGS} -c linvol.for

#  TRVCON TRAVEL TIME & DERIVs FOR HYPOELLIPSE LAYER MODEL.
trvcon.o  :  trvcon.for
	${FC} ${FFLAGS} -c trvcon.for

#  UTMCAL    CALCULATE STATION DISTANCES ON A UTM GRID
utmcal.o :  utmcal.for
	${FC} ${FFLAGS} -c utmcal.for

#  INIT_EVENT  INITIALIZES CUSP FOR READING OF MEM DATA FILES (VAX ONLY)
#init_event.o  :  init_event.f
#	${FC} ${FFLAGS} -c init_event.f

#  HYDELT DELETES FILES IN INTERACTIVE PROCESSING
hydelt.o  :  hydelt.f
	${FC} ${FFLAGS} -c hydelt.f

#  HYEDIT  RUNS AN EDTIOR WITHIN A PROCESS
hyedit.o  :  hyedit.f
	${FC} ${FFLAGS} -c hyedit.f

#  HYTIME    GETS CURRENT SYSTEM TIME FOR LABELING PRINT FILE
hytime.o  :  hytime.f
	${FC} ${FFLAGS} -c hytime.f

#  ALSO USES THESE GENERAL PURPOSE SUBROUTINES FROM THE SUBROUTINE LIBRARY
#  KLAS      ASSIGNS A NAME AND NUMBER TO AN EVENT BASED ON LOCATION.
#  KLASS (NET 1), BOX2 (NET2) - USED BY KLAS.
#  ISITIN    DETERMINES IF EVENT IS IN A PARTICULAR REGION.
#  UPSTR     CONVERTS A STRING TO UPPER CASE.
#  JASK	     INTERACTIVE PROMPT & ENTRY OF AN INTEGER.
#  ASKC      INTERACTIVE PROMPT AND ENTRY OF A STRING.
#  ASKR      INTERACTIVE PROMPT AND ENTRY OF A REAL VALUE.
#  LASK      INTERACTIVE PROMPT AND ENTRY OF A LOGICAL VALUE.
#  LENG      DETERMINES THE NON-BLANK LENGTH OF A STRING.

#  Simple program to convert P delays to S delays using a constant POS
p2sdly  :  p2sdly.for
	${FC} -g p2sdly.for allsubs.o -o $B/p2sdly


clean:
	rm -f *.o 

clean_bin:
	rm -f $B/hyp2000
