// StartstopConsoleDlg.cpp : implementation file
//

#include "stdafx.h"
#include "StartstopConsole.h"
#include "StartstopConsoleDlg.h"
#include <stdlib.h>
#include <errno.h>
extern "C"
{
 #include "watchdog_client.h"
}

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CStartstopConsoleDlg dialog

CStartstopConsoleDlg::CStartstopConsoleDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CStartstopConsoleDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CStartstopConsoleDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);

	m_hNamedPipe = INVALID_HANDLE_VALUE;
}

void CStartstopConsoleDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CStartstopConsoleDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CStartstopConsoleDlg, CDialog)
	//{{AFX_MSG_MAP(CStartstopConsoleDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_DESTROY()
	ON_BN_CLICKED(IDC_CONSOLE, OnConsole)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CStartstopConsoleDlg message handlers

BOOL CStartstopConsoleDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// Connect to startstop's named pipe
	m_hNamedPipe = CreateFile("\\\\.\\pipe\\HydraStartstopPipe", GENERIC_WRITE, FILE_SHARE_WRITE,
					NULL, OPEN_EXISTING, SECURITY_IDENTIFICATION, NULL);
	if (m_hNamedPipe == INVALID_HANDLE_VALUE)
	{
		reportError(WD_FATAL_ERROR, SYSERR, "Error calling CreateFile: %d\n", GetLastError());
		AfxMessageBox("Unable to connect to startstop!");
		PostMessage(WM_CLOSE);
		return TRUE;
	}

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CStartstopConsoleDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CStartstopConsoleDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CStartstopConsoleDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CStartstopConsoleDlg::OnDestroy() 
{
	CloseHandle(m_hNamedPipe);

	CDialog::OnDestroy();
}

void CStartstopConsoleDlg::OnConsole() 
{
	char szOutBuffer[32];
	DWORD BytesWritten, err;

	CWaitCursor waitcsr;

	GetDlgItem(IDC_CONSOLE)->EnableWindow(FALSE);

	strcpy(szOutBuffer, "NewConsole");

	if (!WriteFile(m_hNamedPipe, szOutBuffer, strlen(szOutBuffer), &BytesWritten, NULL))
	{
		err = GetLastError();
		reportError(WD_FATAL_ERROR, SYSERR, "Error calling WriteFile: %d\n", err);
		AfxMessageBox("Error launching console window!");
		return;
	}
	else if (BytesWritten < strlen(szOutBuffer))
	{
		reportError(WD_FATAL_ERROR, SYSERR, "Not all data written via WriteFile");
		AfxMessageBox("Error launching console window!");
		return;
	}

	// Sleep an extra second, so that startstop has a chance to create the console
	// before we get rid of the wait cursor...
	Sleep(1000);
	GetDlgItem(IDC_CONSOLE)->EnableWindow(TRUE);
}
