/**EWQuakeAlert generates email messages when receiving HYP2000ARC
 * messages from Earthworm.
 * Copyright (C) 2009 Ruben S. Luis
 * This program is free software: you ca redistribute it an/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be usefull,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with EWQuakeAlert. If not, see <http://www.gnu.org/licenses/>.
 **/

package ewquakealert;

import org.jdesktop.application.Action;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.SingleFrameApplication;
import org.jdesktop.application.FrameView;
import org.jdesktop.application.TaskMonitor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.Timer;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;


/**
 * The application's main frame.
 */
public class EWQuakeAlertView extends FrameView {

    public EWQuakeAlertView(SingleFrameApplication app) {
        super(app);

        initComponents();
        this.getFrame().setResizable(false);

        // status bar initialization - message timeout, idle icon and busy animation, etc
        ResourceMap resourceMap = getResourceMap();
        int messageTimeout = resourceMap.getInteger("StatusBar.messageTimeout");
        messageTimer = new Timer(messageTimeout, new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                statusMessageLabel.setText("");
            }
        });
        messageTimer.setRepeats(false);
        int busyAnimationRate = resourceMap.getInteger("StatusBar.busyAnimationRate");
        for (int i = 0; i < busyIcons.length; i++) {
            busyIcons[i] = resourceMap.getIcon("StatusBar.busyIcons[" + i + "]");
        }
        busyIconTimer = new Timer(busyAnimationRate, new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                busyIconIndex = (busyIconIndex + 1) % busyIcons.length;
                statusAnimationLabel.setIcon(busyIcons[busyIconIndex]);
            }
        });
        idleIcon = resourceMap.getIcon("StatusBar.idleIcon");
        statusAnimationLabel.setIcon(idleIcon);
        progressBar.setVisible(false);

        // connecting action tasks to status bar via TaskMonitor
        TaskMonitor taskMonitor = new TaskMonitor(getApplication().getContext());
        taskMonitor.addPropertyChangeListener(new java.beans.PropertyChangeListener() {
            public void propertyChange(java.beans.PropertyChangeEvent evt) {
                String propertyName = evt.getPropertyName();
                if ("started".equals(propertyName)) {
                    if (!busyIconTimer.isRunning()) {
                        statusAnimationLabel.setIcon(busyIcons[0]);
                        busyIconIndex = 0;
                        busyIconTimer.start();
                    }
                    progressBar.setVisible(true);
                    progressBar.setIndeterminate(true);
                } else if ("done".equals(propertyName)) {
                    busyIconTimer.stop();
                    statusAnimationLabel.setIcon(idleIcon);
                    progressBar.setVisible(false);
                    progressBar.setValue(0);
                } else if ("message".equals(propertyName)) {
                    String text = (String)(evt.getNewValue());
                    statusMessageLabel.setText((text == null) ? "" : text);
                    messageTimer.restart();
                } else if ("progress".equals(propertyName)) {
                    int value = (Integer)(evt.getNewValue());
                    progressBar.setVisible(true);
                    progressBar.setIndeterminate(false);
                    progressBar.setValue(value);
                }
            }
        });
    }

    @Action
    public void showAboutBox() {
        if (aboutBox == null) {
            JFrame mainFrame = EWQuakeAlertApp.getApplication().getMainFrame();
            aboutBox = new EWQuakeAlertAboutBox(mainFrame);
            aboutBox.setLocationRelativeTo(mainFrame);
        }
        EWQuakeAlertApp.getApplication().show(aboutBox);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        mainPanel = new javax.swing.JPanel();
        jScrollPane1 = new javax.swing.JScrollPane();
        guiOutput = new javax.swing.JTextArea();
        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();
        jLabel4 = new javax.swing.JLabel();
        jLabel5 = new javax.swing.JLabel();
        jLabel6 = new javax.swing.JLabel();
        jLabel7 = new javax.swing.JLabel();
        originTime = new javax.swing.JLabel();
        Latitude = new javax.swing.JLabel();
        Longitude = new javax.swing.JLabel();
        Depth = new javax.swing.JLabel();
        Magnitude = new javax.swing.JLabel();
        menuBar = new javax.swing.JMenuBar();
        javax.swing.JMenu fileMenu = new javax.swing.JMenu();
        javax.swing.JMenuItem exitMenuItem = new javax.swing.JMenuItem();
        menuSettings = new javax.swing.JMenu();
        showEWImportSettings = new javax.swing.JMenuItem();
        showEWWaveserverSettings = new javax.swing.JMenuItem();
        showEmailSettings = new javax.swing.JMenuItem();
        jMenuItem1 = new javax.swing.JMenuItem();
        javax.swing.JMenu helpMenu = new javax.swing.JMenu();
        javax.swing.JMenuItem aboutMenuItem = new javax.swing.JMenuItem();
        statusPanel = new javax.swing.JPanel();
        javax.swing.JSeparator statusPanelSeparator = new javax.swing.JSeparator();
        statusMessageLabel = new javax.swing.JLabel();
        statusAnimationLabel = new javax.swing.JLabel();
        progressBar = new javax.swing.JProgressBar();

        mainPanel.setName("mainPanel"); // NOI18N

        jScrollPane1.setName("jScrollPane1"); // NOI18N

        guiOutput.setColumns(20);
        guiOutput.setEditable(false);
        org.jdesktop.application.ResourceMap resourceMap = org.jdesktop.application.Application.getInstance(ewquakealert.EWQuakeAlertApp.class).getContext().getResourceMap(EWQuakeAlertView.class);
        guiOutput.setFont(resourceMap.getFont("guiOutput.font")); // NOI18N
        guiOutput.setLineWrap(true);
        guiOutput.setRows(1);
        guiOutput.setName("guiOutput"); // NOI18N
        jScrollPane1.setViewportView(guiOutput);

        jLabel1.setFont(resourceMap.getFont("jLabel1.font")); // NOI18N
        jLabel1.setText(resourceMap.getString("jLabel1.text")); // NOI18N
        jLabel1.setName("jLabel1"); // NOI18N

        jLabel2.setText(resourceMap.getString("jLabel2.text")); // NOI18N
        jLabel2.setName("jLabel2"); // NOI18N

        jLabel3.setText(resourceMap.getString("jLabel3.text")); // NOI18N
        jLabel3.setName("jLabel3"); // NOI18N

        jLabel4.setText(resourceMap.getString("jLabel4.text")); // NOI18N
        jLabel4.setName("jLabel4"); // NOI18N

        jLabel5.setText(resourceMap.getString("jLabel5.text")); // NOI18N
        jLabel5.setName("jLabel5"); // NOI18N

        jLabel6.setText(resourceMap.getString("jLabel6.text")); // NOI18N
        jLabel6.setName("jLabel6"); // NOI18N

        jLabel7.setFont(resourceMap.getFont("jLabel7.font")); // NOI18N
        jLabel7.setText(resourceMap.getString("jLabel7.text")); // NOI18N
        jLabel7.setName("jLabel7"); // NOI18N

        originTime.setText(resourceMap.getString("originTime.text")); // NOI18N
        originTime.setName("originTime"); // NOI18N

        Latitude.setText(resourceMap.getString("Latitude.text")); // NOI18N
        Latitude.setName("Latitude"); // NOI18N

        Longitude.setText(resourceMap.getString("Longitude.text")); // NOI18N
        Longitude.setName("Longitude"); // NOI18N

        Depth.setText(resourceMap.getString("Depth.text")); // NOI18N
        Depth.setName("Depth"); // NOI18N

        Magnitude.setText(resourceMap.getString("Magnitude.text")); // NOI18N
        Magnitude.setName("Magnitude"); // NOI18N

        javax.swing.GroupLayout mainPanelLayout = new javax.swing.GroupLayout(mainPanel);
        mainPanel.setLayout(mainPanelLayout);
        mainPanelLayout.setHorizontalGroup(
            mainPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(mainPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(mainPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 614, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addGroup(mainPanelLayout.createSequentialGroup()
                        .addGroup(mainPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jLabel2)
                            .addComponent(jLabel3)
                            .addComponent(jLabel6)
                            .addComponent(jLabel4)
                            .addComponent(jLabel5))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(mainPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                            .addComponent(Magnitude, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(Depth, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(Longitude, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(Latitude, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(originTime, javax.swing.GroupLayout.DEFAULT_SIZE, 117, Short.MAX_VALUE)))
                    .addComponent(jLabel7)
                    .addComponent(jLabel1))
                .addContainerGap())
        );
        mainPanelLayout.setVerticalGroup(
            mainPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(mainPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabel1)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(mainPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel2)
                    .addComponent(originTime, javax.swing.GroupLayout.PREFERRED_SIZE, 14, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(mainPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel3)
                    .addComponent(Latitude, javax.swing.GroupLayout.PREFERRED_SIZE, 14, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(mainPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel4)
                    .addComponent(Longitude, javax.swing.GroupLayout.PREFERRED_SIZE, 14, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(mainPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel5)
                    .addComponent(Depth, javax.swing.GroupLayout.PREFERRED_SIZE, 14, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(mainPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel6)
                    .addComponent(Magnitude, javax.swing.GroupLayout.PREFERRED_SIZE, 14, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 19, Short.MAX_VALUE)
                .addComponent(jLabel7)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 224, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );

        menuBar.setName("menuBar"); // NOI18N

        fileMenu.setText(resourceMap.getString("fileMenu.text")); // NOI18N
        fileMenu.setName("fileMenu"); // NOI18N

        javax.swing.ActionMap actionMap = org.jdesktop.application.Application.getInstance(ewquakealert.EWQuakeAlertApp.class).getContext().getActionMap(EWQuakeAlertView.class, this);
        exitMenuItem.setAction(actionMap.get("quit")); // NOI18N
        exitMenuItem.setName("exitMenuItem"); // NOI18N
        fileMenu.add(exitMenuItem);

        menuBar.add(fileMenu);

        menuSettings.setText(resourceMap.getString("menuSettings.text")); // NOI18N
        menuSettings.setName("menuSettings"); // NOI18N

        showEWImportSettings.setAction(actionMap.get("showImportSettings")); // NOI18N
        showEWImportSettings.setText(resourceMap.getString("showEWImportSettings.text")); // NOI18N
        showEWImportSettings.setName("showEWImportSettings"); // NOI18N
        menuSettings.add(showEWImportSettings);

        showEWWaveserverSettings.setAction(actionMap.get("showWaveserverSettings")); // NOI18N
        showEWWaveserverSettings.setText(resourceMap.getString("showEWWaveserverSettings.text")); // NOI18N
        showEWWaveserverSettings.setName("showEWWaveserverSettings"); // NOI18N
        menuSettings.add(showEWWaveserverSettings);

        showEmailSettings.setAction(actionMap.get("showEmailSettings")); // NOI18N
        showEmailSettings.setText(resourceMap.getString("showEmailSettings.text")); // NOI18N
        showEmailSettings.setName("showEmailSettings"); // NOI18N
        menuSettings.add(showEmailSettings);

        jMenuItem1.setAction(actionMap.get("showSMSGatewaySettings")); // NOI18N
        jMenuItem1.setText(resourceMap.getString("jMenuItem1.text")); // NOI18N
        jMenuItem1.setName("jMenuItem1"); // NOI18N
        menuSettings.add(jMenuItem1);

        menuBar.add(menuSettings);

        helpMenu.setText(resourceMap.getString("helpMenu.text")); // NOI18N
        helpMenu.setName("helpMenu"); // NOI18N

        aboutMenuItem.setAction(actionMap.get("showAboutBox")); // NOI18N
        aboutMenuItem.setName("aboutMenuItem"); // NOI18N
        helpMenu.add(aboutMenuItem);

        menuBar.add(helpMenu);

        statusPanel.setName("statusPanel"); // NOI18N

        statusPanelSeparator.setName("statusPanelSeparator"); // NOI18N

        statusMessageLabel.setName("statusMessageLabel"); // NOI18N

        statusAnimationLabel.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        statusAnimationLabel.setName("statusAnimationLabel"); // NOI18N

        progressBar.setName("progressBar"); // NOI18N

        javax.swing.GroupLayout statusPanelLayout = new javax.swing.GroupLayout(statusPanel);
        statusPanel.setLayout(statusPanelLayout);
        statusPanelLayout.setHorizontalGroup(
            statusPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(statusPanelSeparator, javax.swing.GroupLayout.DEFAULT_SIZE, 634, Short.MAX_VALUE)
            .addGroup(statusPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(statusMessageLabel)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 464, Short.MAX_VALUE)
                .addComponent(progressBar, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(statusAnimationLabel)
                .addContainerGap())
        );
        statusPanelLayout.setVerticalGroup(
            statusPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(statusPanelLayout.createSequentialGroup()
                .addComponent(statusPanelSeparator, javax.swing.GroupLayout.PREFERRED_SIZE, 2, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addGroup(statusPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(statusMessageLabel)
                    .addComponent(statusAnimationLabel)
                    .addComponent(progressBar, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(3, 3, 3))
        );

        setComponent(mainPanel);
        setMenuBar(menuBar);
        setStatusBar(statusPanel);
    }// </editor-fold>//GEN-END:initComponents

    @Action
    public void showPhases() {
        try {
            Runtime.getRuntime().exec("explorer " + Configuration.last_png);
            Thread.sleep(3000);
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    @Action
    public void startImportClient() {
        try {
            if (Configuration.clientStatus == 1){
                //Client is already connected
                Configuration.clientStatus = 2; //Order disconnect
                while (Configuration.clientStatus!=0)
                    Thread.sleep(1000);
            }
            Configuration.clientStatus = 3; //Order connect
            while (Configuration.clientStatus!=1)
                Thread.sleep(1000);
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    static public void println(String output) {
        try {
            String newline = System.getProperty("line.separator");
            Calendar cal = new GregorianCalendar();
            cal.setTime(new Date());
            @SuppressWarnings("static-access")
            String timeMsg = String.valueOf(cal.get(cal.YEAR)) + "." +
                    String.valueOf(cal.get(cal.MONTH)+1) + "." +
                    String.valueOf(cal.get(cal.DAY_OF_MONTH)) + " " +
                    String.valueOf(cal.get(cal.HOUR_OF_DAY)) + ":" +
                    String.valueOf(cal.get(cal.MINUTE)) + ":" +
                    String.valueOf(cal.get(cal.SECOND)) + " - ";

            guiOutput.append(timeMsg + output + newline);
            String fullString = guiOutput.getText();
            if (fullString.length()>10000)
                guiOutput.setText(fullString.substring(1 + fullString.indexOf(newline)));
            guiOutput.setCaretPosition(guiOutput.getText().length() - 1);

        }
        catch (Exception e) {
        }
    }


    static public void updateLabels(EWMessage msg) {
        NumberFormat nf = NumberFormat.getNumberInstance(new Locale("en", "US"));
        DecimalFormat df = (DecimalFormat)nf;
        df.applyPattern("#0.000");

        originTime.setText(msg.hypOrigin);
        Latitude.setText(df.format(msg.hypLatitude));
        Longitude.setText(df.format(msg.hypLongitude));
        Depth.setText(String.valueOf(msg.hypDepth));
        Magnitude.setText(String.valueOf(msg.hypMag));

        
}




    @Action
    public void showEmailSettings() {
        JFrame mainFrame = EWQuakeAlertApp.getApplication().getMainFrame();
        EWQuakeAlertEmailSettings emailBox = new EWQuakeAlertEmailSettings(mainFrame);
        EWQuakeAlertApp.getApplication().show(emailBox);
    }

    @Action
    public void showImportSettings() {
        JFrame mainFrame = EWQuakeAlertApp.getApplication().getMainFrame();
        EWQuakeAlertImportSettings importBox = new EWQuakeAlertImportSettings(mainFrame);
        EWQuakeAlertApp.getApplication().show(importBox);
    }

    @Action
    public void showWaveserverSettings() {
        JFrame mainFrame = EWQuakeAlertApp.getApplication().getMainFrame();
        EWQuakeAlertWaveserverSettings waveserverBox = new EWQuakeAlertWaveserverSettings(mainFrame);
        EWQuakeAlertApp.getApplication().show(waveserverBox);
    }

    @Action
    public void showSMSGatewaySettings() {
        JFrame mainFrame = EWQuakeAlertApp.getApplication().getMainFrame();
        EWQuakeAlertSMSSettings waveserverBox = new EWQuakeAlertSMSSettings(mainFrame);
        EWQuakeAlertApp.getApplication().show(waveserverBox);
    }


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private static javax.swing.JLabel Depth;
    private static javax.swing.JLabel Latitude;
    private static javax.swing.JLabel Longitude;
    private static javax.swing.JLabel Magnitude;
    public static javax.swing.JTextArea guiOutput;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JMenuItem jMenuItem1;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JPanel mainPanel;
    private javax.swing.JMenuBar menuBar;
    private javax.swing.JMenu menuSettings;
    private static javax.swing.JLabel originTime;
    private javax.swing.JProgressBar progressBar;
    private javax.swing.JMenuItem showEWImportSettings;
    private javax.swing.JMenuItem showEWWaveserverSettings;
    private javax.swing.JMenuItem showEmailSettings;
    private javax.swing.JLabel statusAnimationLabel;
    private javax.swing.JLabel statusMessageLabel;
    private javax.swing.JPanel statusPanel;
    // End of variables declaration//GEN-END:variables

    private final Timer messageTimer;
    private final Timer busyIconTimer;
    private final Icon idleIcon;
    private final Icon[] busyIcons = new Icon[15];
    private int busyIconIndex = 0;

    private JDialog aboutBox;
}
